/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGiftType;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.happy.HappySantaEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class SantaGifts {
    public static final String NAME_HAPPY_SANTA = "entity.happyholidays.happy_santa";
    public static final String NAME_ANGRY_SANTA = "entity.happyholidays.angry_santa";
    public static final String NAME_BASIC_GIFT = "item.happyholidays.santa.basic_gift";
    public static final String NAME_RARE_GIFT = "item.happyholidays.santa.rare_gift";
    public static final String NAME_LEGENDARY_GIFT = "item.happyholidays.santa.legendary_gift";
    public static final ResourceLocation BASIC_GIFT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_basic_gift");
    public static final ResourceLocation RARE_GIFT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_rare_gift");
    public static final ResourceLocation LEGENDARY_GIFT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_legendary_gift");

    public static ItemStack generateGift(SantaGiftType type, BaseSantaEntity santaEntity, ServerLevel level, LootContext lootContext) {
        ItemStack giftItem = ItemStack.f_41583_;
        List items = Lists.newArrayList();
        switch (type) {
            case BASIC: {
                giftItem = ((ChristmasItem)ChristmasItems.BLUE_CHRISTMAS_GIFT_ITEM.get()).m_7968_();
                giftItem.m_41714_((Component)new TranslatableComponent(NAME_BASIC_GIFT));
                LootTable lootTable = level.m_142572_().m_129898_().m_79217_(BASIC_GIFT_LOOT_TABLE);
                items = lootTable.m_79129_(lootContext);
                for (ItemStack item : items) {
                    if (!(item.m_41720_() instanceof BlockItem) || !BlockTags.f_13106_.m_8110_((Object)((BlockItem)item.m_41720_()).m_40614_())) continue;
                    item.m_41764_(santaEntity.m_21187_().nextInt(6) + 6);
                }
                break;
            }
            case RARE: {
                giftItem = ((ChristmasItem)ChristmasItems.GREEN_CHRISTMAS_GIFT_ITEM.get()).m_7968_();
                giftItem.m_41714_((Component)new TranslatableComponent(NAME_RARE_GIFT));
                LootTable lootTable = level.m_142572_().m_129898_().m_79217_(RARE_GIFT_LOOT_TABLE);
                items = lootTable.m_79129_(lootContext);
                break;
            }
            case LEGENDARY: {
                giftItem = ((ChristmasItem)ChristmasItems.GOLD_CHRISTMAS_GIFT_ITEM.get()).m_7968_();
                giftItem.m_41714_((Component)new TranslatableComponent(NAME_LEGENDARY_GIFT));
                LootTable lootTable = level.m_142572_().m_129898_().m_79217_(LEGENDARY_GIFT_LOOT_TABLE);
                items = lootTable.m_79129_(lootContext);
                break;
            }
        }
        CompoundTag giftItemsNBT = new CompoundTag();
        NonNullList nonNullList = NonNullList.m_122780_((int)items.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            nonNullList.set(i, (Object)((ItemStack)items.get(i)));
        }
        ContainerHelper.m_18973_((CompoundTag)giftItemsNBT, (NonNullList)nonNullList);
        String name = santaEntity instanceof HappySantaEntity ? NAME_HAPPY_SANTA : NAME_ANGRY_SANTA;
        CompoundTag giftTag = giftItem.m_41784_();
        giftTag.m_128365_("Gifts", (Tag)giftItemsNBT);
        giftTag.m_128359_("WrappedBy", new TranslatableComponent(name).getString());
        return giftItem;
    }
}

