/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGiftType;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGifts;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.ExplosivePresentEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.ExplosivePresentsAttackGoal;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.Phase;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.PhaseSwitchGoal;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.SleighAttackGoal;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.SleighEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.TeleportGoal;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class AngrySantaEntity
extends BaseSantaEntity {
    public static final EntityDataAccessor<Integer> SANTA_PHASE = SynchedEntityData.m_135353_(AngrySantaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_HIT_ANIM_TIMER = SynchedEntityData.m_135353_(AngrySantaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_SLEIGHS_ANIM_TIMER = SynchedEntityData.m_135353_(AngrySantaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_TELEPORT_ANIM_TIMER = SynchedEntityData.m_135353_(AngrySantaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String ENTITY_ID = "angry_santa";
    public static final int ATTACK_PHASE_SWITCH_TIMER_MAX = 200;
    public static final int ATTACK_PHASE_SWITCH_TIMER_MIN = 80;
    public static final int ATTACK_SLEIGH_CHARGE_TIME = 10;
    public static final int ATTACK_SLEIGH_INTERVAL = 40;
    public static final int ATTACK_SLEIGH_LIFETIME = 80;
    public static final int ATTACK_PRESENTS_CONSIDERATION_RADIUS = 30;
    public static final int ATTACK_PRESENTS_INTERVAL = 30;
    public static final int ATTACK_TELEPORT_CHARGE_TIME = 40;
    public static final int ATTACK_TELEPORT_INTERVAL = 60;
    public static final int ATTACK_TELEPORT_CONSIDERATION_RADIUS = 30;
    public static final float ATTACK_TELEPORT_DAMAGE = 8.0f;
    public static final int ATTACK_TELEPORT_DAMAGE_RADIUS = 4;
    public static final int NUM_LEGENDARY_PRESENTS_MIN = 6;
    public static final int NUM_LEGENDARY_PRESENTS_MAX = 10;
    public static final int NUM_RARE_PRESENTS_MIN = 10;
    public static final int NUM_RARE_PRESENTS_MAX = 16;
    public static final int NUM_BASIC_PRESENTS_MIN = 12;
    public static final int NUM_BASIC_PRESENTS_MAX = 20;
    public static final int AMT_XP_DROP = 4800;
    public static final int NUM_XP_ORBS_MIN = 32;
    public static final int NUM_XP_ORBS_MAX = 48;
    private static final Vec3[] HORIZONTALS = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, -1.0)};
    private static final Vec3[] DIAGONALS = new Vec3[]{new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 0.0, -1.0), new Vec3(-1.0, 0.0, -1.0), new Vec3(-1.0, 0.0, 1.0)};
    private Phase currentPhase = Phase.SLEIGHS;
    private boolean isTeleportCharging;
    private Vec3 teleportTarget;
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private int hitAnimTimer;
    private int sleighAnimTimer;
    private int teleportAnimTimer;
    private boolean isDamagedByPlayer;

    public AngrySantaEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 4));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new PhaseSwitchGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SleighAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ExplosivePresentsAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TeleportGoal(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SANTA_PHASE, (Object)Phase.SLEIGHS.ordinal());
        this.f_19804_.m_135372_(ATTACK_SLEIGHS_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TELEPORT_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(ATTACK_HIT_ANIM_TIMER, (Object)0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.currentPhase = Phase.SLEIGHS;
    }

    public boolean m_6673_(DamageSource dmgSource) {
        return dmgSource.m_19372_();
    }

    private void createBossBar() {
        this.bossEvent.m_142711_(this.m_21223_() / 200.0f);
        AABB areaOfEffect = new AABB(this.m_142538_()).m_82400_(40.0);
        List playerList = this.f_19853_.m_45976_(Player.class, areaOfEffect);
        for (Player playerEntity : playerList) {
            this.bossEvent.m_6543_((ServerPlayer)playerEntity);
        }
    }

    public void setPhase(Phase phase) {
        this.currentPhase = phase;
        this.f_19804_.m_135381_(SANTA_PHASE, (Object)phase.ordinal());
    }

    public void changePhaseRandomly() {
        Phase newPhase;
        this.currentPhase = newPhase = Phase.values()[this.f_19796_.nextInt(Phase.values().length)];
        this.f_19804_.m_135381_(SANTA_PHASE, (Object)newPhase.ordinal());
    }

    public float getAttackIntervalMultiplier() {
        int currentHealth = (int)this.m_21223_();
        return currentHealth >= 150 ? 1.0f : (currentHealth >= 100 ? 1.5f : (currentHealth >= 50 ? 2.0f : 2.5f));
    }

    public void fireHorizontalSleighs() {
        for (Vec3 horizontal : HORIZONTALS) {
            this.fireSleigh(horizontal);
        }
    }

    public void fireDiagonalSleighs() {
        for (Vec3 diagonal : DIAGONALS) {
            this.fireSleigh(diagonal);
        }
    }

    public void fireSleigh(Vec3 vector) {
        this.f_19804_.m_135381_(ATTACK_SLEIGHS_ANIM_TIMER, (Object)20);
        this.sleighAnimTimer = 20;
        SleighEntity sleighEntity = ((SleighEntity)((EntityType)ChristmasEntities.SLEIGH.get()).m_20615_(this.f_19853_)).setRotation(vector);
        sleighEntity.m_20219_(this.m_20182_().m_82549_(sleighEntity.m_20156_().m_82542_(3.0, 3.0, 3.0)));
        this.f_19853_.m_5594_(null, this.m_142538_(), (SoundEvent)ChristmasSounds.SANTA_SUMMON_SLEIGHS.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        this.f_19853_.m_7967_((Entity)sleighEntity);
        for (int i = 0; i < 5; ++i) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, sleighEntity.m_20182_().f_82479_ + this.f_19796_.nextDouble(), sleighEntity.m_20182_().f_82480_ + this.f_19796_.nextDouble(), sleighEntity.m_20182_().f_82481_ + this.f_19796_.nextDouble(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void spawnExplosives(List<Player> playerEntities) {
        for (Player playerEntity : playerEntities) {
            if (!playerEntity.m_6084_()) continue;
            Vec3 playerPos = playerEntity.m_20182_();
            ExplosivePresentEntity explosive = (ExplosivePresentEntity)((EntityType)ChristmasEntities.EXPLOSIVE_PRESENT.get()).m_20615_(this.f_19853_);
            Vec3 explosivePos = playerPos.m_82549_(new Vec3(0.0, 2.0, 0.0));
            explosive.m_20219_(explosivePos);
            for (int i = 0; i < 5; ++i) {
                this.summonPresentsParticles(explosivePos);
            }
            this.f_19853_.m_7967_((Entity)explosive);
            this.f_19853_.m_5594_(null, new BlockPos(explosivePos), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void startTeleportAttack(Vec3 target) {
        this.teleportTarget = target;
        this.f_19804_.m_135381_(ATTACK_TELEPORT_ANIM_TIMER, (Object)40);
        this.teleportAnimTimer = 40;
        this.isTeleportCharging = true;
        this.f_19853_.m_5594_(null, this.m_142538_(), (SoundEvent)ChristmasSounds.SANTA_PREPARE_TELEPORT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        this.f_19853_.m_5594_(null, new BlockPos(target), (SoundEvent)ChristmasSounds.SANTA_PREPARE_TELEPORT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    public void stopTeleportCharging() {
        this.isTeleportCharging = false;
    }

    public void teleportAttack(Vec3 position) {
        this.isTeleportCharging = false;
        this.f_19853_.m_5594_(null, this.m_142538_(), (SoundEvent)ChristmasSounds.SANTA_TELEPORT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        this.m_6021_(position.f_82479_, position.f_82480_ + 2.0, position.f_82481_);
        this.f_19853_.m_5594_(null, this.m_142538_(), (SoundEvent)ChristmasSounds.SANTA_TELEPORT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        List playerEntities = this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82400_((double)(4.0f / this.getAttackIntervalMultiplier())));
        this.summonStompParticles(position);
        for (Player playerEntity : playerEntities) {
            playerEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f * this.getAttackIntervalMultiplier());
        }
    }

    public void m_6123_(Player playerEntity) {
        if (this.m_142469_().m_82400_(1.0).m_82381_(playerEntity.m_142469_())) {
            playerEntity.m_6469_(DamageSource.f_19318_, 12.0f);
            playerEntity.m_20334_(this.f_19796_.nextDouble() * 2.0, this.f_19796_.nextDouble(), this.f_19796_.nextDouble() * 2.0);
            this.f_19853_.m_5594_(null, this.m_142538_(), (SoundEvent)ChristmasSounds.SANTA_FLICK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.hitAnimTimer = 10;
        }
    }

    public Phase getPhase() {
        return this.currentPhase;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.currentPhase = Phase.values()[(Integer)this.f_19804_.m_135370_(SANTA_PHASE)];
            if (this.currentPhase == Phase.SLEIGHS) {
                this.sleighAnimTimer = (Integer)this.f_19804_.m_135370_(ATTACK_SLEIGHS_ANIM_TIMER);
            }
            if (this.currentPhase == Phase.TELEPORT) {
                this.teleportAnimTimer = (Integer)this.f_19804_.m_135370_(ATTACK_TELEPORT_ANIM_TIMER);
            }
            this.hitAnimTimer = (Integer)this.f_19804_.m_135370_(ATTACK_HIT_ANIM_TIMER);
        } else {
            if (this.sleighAnimTimer > 0) {
                --this.sleighAnimTimer;
                this.f_19804_.m_135381_(ATTACK_SLEIGHS_ANIM_TIMER, (Object)this.sleighAnimTimer);
            }
            if (this.teleportAnimTimer > 0) {
                --this.teleportAnimTimer;
                this.f_19804_.m_135381_(ATTACK_TELEPORT_ANIM_TIMER, (Object)this.teleportAnimTimer);
            }
            if (this.hitAnimTimer > 0) {
                --this.hitAnimTimer;
                this.f_19804_.m_135381_(ATTACK_HIT_ANIM_TIMER, (Object)this.hitAnimTimer);
            }
            if (this.isTeleportCharging) {
                this.summonTeleportationParticles(this.m_20182_());
                this.summonTeleportationParticles(this.teleportTarget);
            }
            if (this.currentPhase == Phase.PRESENTS) {
                this.summonSantaPresentsParticles();
            }
            if (this.m_6084_() && this.f_19853_.m_46467_() % 60L == 0L) {
                if (this.bossEvent == null) {
                    this.createBossBar();
                }
                AABB areaOfEffect = new AABB(this.m_142538_()).m_82400_(40.0);
                List playerList = this.f_19853_.m_45976_(Player.class, areaOfEffect);
                for (ServerPlayer serverPlayerEntity : this.bossEvent.m_8324_()) {
                    if (playerList.contains(serverPlayerEntity)) continue;
                    this.bossEvent.m_6539_(serverPlayerEntity);
                }
                for (Player playerEntity : playerList) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
                    if (this.bossEvent.m_8324_().contains(serverPlayerEntity)) continue;
                    this.bossEvent.m_6543_((ServerPlayer)playerEntity);
                }
            }
        }
    }

    private void summonPresentsParticles(Vec3 pos) {
        double d0 = Math.random() * 0.1 + 0.25;
        double d1 = Math.random() * 0.1 + 0.25;
        double d2 = Math.random() * 0.1 + 0.25;
        SimpleParticleType particleType = ParticleTypes.f_123762_;
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)particleType, pos.f_82479_, pos.f_82480_ + d1, pos.f_82481_, 2, d0, d1, d2, 0.0);
    }

    private void summonSantaPresentsParticles() {
        Vec3 pos = this.m_20182_();
        double d0 = Math.random() * 0.1 + 0.25;
        double d1 = Math.random() * 0.1 + 0.25;
        double d2 = Math.random() * 0.1 + 0.25;
        SimpleParticleType particleType = ParticleTypes.f_123762_;
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)particleType, pos.f_82479_ + Math.random() * 2.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), pos.f_82480_ + d1, pos.f_82481_ + Math.random() * 2.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), 2, d0, d1, d2, 0.0);
    }

    private void summonTeleportationParticles(Vec3 pos) {
        double d0 = Math.random() * 0.1 + 0.25;
        double d1 = Math.random() * 0.1 + 0.25;
        double d2 = Math.random() * 0.1 + 0.25;
        double d = Math.random();
        SimpleParticleType particleType = d < 0.5 ? (SimpleParticleType)ChristmasParticles.CHRISTMAS_SANTA_GREEN_SPAWN_PARTICLE.get() : (SimpleParticleType)ChristmasParticles.CHRISTMAS_SANTA_RED_SPAWN_PARTICLE.get();
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)particleType, pos.f_82479_, pos.f_82480_ + d1, pos.f_82481_, 2, d0, d1, d2, 0.0);
    }

    private void summonStompParticles(Vec3 pos) {
        SimpleParticleType particleType = ParticleTypes.f_123796_;
        for (int i = 0; i < 25; ++i) {
            double d0 = Math.random() * 4.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1);
            double d1 = Math.random() * 1.5;
            double d2 = Math.random() * 4.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1);
            double dv0 = Math.random() * 0.1 + 0.25;
            double dv1 = Math.random() * 0.1 + 0.25;
            double dv2 = Math.random() * 0.1 + 0.25;
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)particleType, pos.f_82479_ + d0, pos.f_82480_ + d1, pos.f_82481_ + d2, 2, dv0, dv1, dv2, 0.0);
        }
    }

    protected void m_7472_(DamageSource damageSource, int p_213333_2_, boolean p_213333_3_) {
        super.m_7472_(damageSource, p_213333_2_, p_213333_3_);
        if (damageSource == DamageSource.f_19317_) {
            return;
        }
        for (ItemStack gift : this.generateDrops()) {
            this.m_19983_(gift);
        }
        int numOrbs = this.f_19796_.nextInt(16) + 32;
        for (int i = 0; i < numOrbs; ++i) {
            int xpDrop = ExperienceOrb.m_20782_((int)((int)(1.0 / (double)numOrbs * 4800.0)));
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), xpDrop));
        }
    }

    private List<ItemStack> generateDrops() {
        int i;
        int numLegendaryPresents = this.f_19796_.nextInt(4) + 6;
        int numRarePresents = this.f_19796_.nextInt(6) + 10;
        int numBasicPresents = this.f_19796_.nextInt(8) + 12;
        LootContext ctx = this.m_7771_(true, DamageSource.f_19318_).m_78975_(LootContextParamSets.f_81415_);
        ArrayList gifts = Lists.newArrayList();
        for (i = 0; i < numLegendaryPresents; ++i) {
            ItemStack legendaryGift = SantaGifts.generateGift(SantaGiftType.LEGENDARY, this, (ServerLevel)this.f_19853_, ctx);
            gifts.add(legendaryGift);
        }
        for (i = 0; i < numRarePresents; ++i) {
            ItemStack rareGift = SantaGifts.generateGift(SantaGiftType.RARE, this, (ServerLevel)this.f_19853_, ctx);
            gifts.add(rareGift);
        }
        for (i = 0; i < numBasicPresents; ++i) {
            ItemStack basicGift = SantaGifts.generateGift(SantaGiftType.BASIC, this, (ServerLevel)this.f_19853_, ctx);
            gifts.add(basicGift);
        }
        gifts.add(((ChristmasItem)ChristmasItems.ENCHANTED_SANTA_HAT.get()).m_7968_());
        return gifts;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        boolean flag = super.m_6469_(p_70097_1_, p_70097_2_);
        if (p_70097_1_.m_7639_() instanceof Player) {
            this.isDamagedByPlayer = true;
        }
        this.bossEvent.m_142711_(this.m_21223_() / 200.0f);
        return flag;
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        if (!this.isDamagedByPlayer) {
            AABB searchBox = new AABB(this.m_142538_()).m_82400_(40.0);
            List playerEntities = this.f_19853_.m_45976_(Player.class, searchBox);
            for (Player playerEntity : playerEntities) {
                SantaEvent.AngryDie event = new SantaEvent.AngryDie(this, playerEntity);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
        }
        this.bossEvent.m_7706_();
    }

    public boolean isDamagedByPlayer() {
        return this.isDamagedByPlayer;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ChristmasSounds.SANTA_ANGRY_PASSIVE.get();
    }

    @Override
    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.hitAnimTimer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.attack", Boolean.valueOf(false)));
        } else if (this.currentPhase == Phase.SLEIGHS && this.sleighAnimTimer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.summon_sleighs", Boolean.valueOf(true)));
        } else if (this.currentPhase == Phase.TELEPORT && this.teleportAnimTimer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.teleporting", Boolean.valueOf(false)));
        } else if (this.currentPhase == Phase.PRESENTS) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.summon", Boolean.valueOf(true)));
        } else if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("IsDamagedByPlayer", this.isDamagedByPlayer);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.isDamagedByPlayer = nbt.m_128471_("IsDamagedByPlayer");
    }
}

