/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry;

import com.jumpcutfindo.happyholidays.common.entity.christmas.IChristmasEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SleighEntity
extends Entity
implements IAnimatable,
IChristmasEntity {
    public static final String ENTITY_ID = "sleigh";
    public static final float ENTITY_BOX_SIZE = 2.0f;
    public static final float ENTITY_BOX_HEIGHT = 0.75f;
    @OnlyIn(value=Dist.CLIENT)
    private double lxd;
    @OnlyIn(value=Dist.CLIENT)
    private double lyd;
    @OnlyIn(value=Dist.CLIENT)
    private double lzd;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int remainingCharging = 10;
    private boolean isCharged;
    private int remainingLifespan = 80;
    private boolean isMoving;

    public SleighEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.remainingCharging = 10;
        this.remainingLifespan = 80;
        this.f_19794_ = false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.remainingCharging > 0) {
            this.m_20256_(this.m_20156_().m_82542_(0.01, 0.01, 0.01));
        }
        if (!this.isCharged && --this.remainingCharging <= 0) {
            this.m_20256_(this.m_20156_());
            this.isCharged = true;
            this.isMoving = true;
        }
        if (this.isMoving && --this.remainingLifespan <= 0) {
            this.explode(false);
        }
        if (!this.m_20068_() && !this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if (!this.isDiagonal() && this.isMoving && this.m_20184_().f_82479_ == 0.0 && this.m_20184_().f_82481_ == 0.0) {
            this.m_20256_(this.m_20156_());
            this.m_20219_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
        } else if (this.isDiagonal() && this.isMoving && (this.m_20184_().f_82479_ == 0.0 || this.m_20184_().f_82481_ == 0.0)) {
            this.m_20256_(this.m_20156_());
            this.m_20219_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
        }
    }

    public void m_6123_(Player playerEntity) {
        super.m_6123_(playerEntity);
        if (playerEntity.m_142469_().m_82381_(this.m_142469_())) {
            this.explode(true);
        }
    }

    public boolean m_5843_() {
        return true;
    }

    public SleighEntity setRotation(Vec3 vector) {
        this.m_146922_((float)Math.atan2(vector.f_82481_, vector.f_82479_) * 180.0f / (float)Math.PI);
        return this;
    }

    public boolean isDiagonal() {
        return this.m_146908_() % 90.0f != 0.0f;
    }

    private void explode(boolean isHitPlayer) {
        float explosivePower = isHitPlayer ? 3.0f : 1.0f;
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), explosivePower, Explosion.BlockInteraction.NONE);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.lxd = p_70016_1_;
        this.lyd = p_70016_3_;
        this.lzd = p_70016_5_;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("RemainingCharging")) {
            this.remainingCharging = tag.m_128451_("RemainingCharging");
        }
        this.isCharged = tag.m_128471_("IsCharged");
        if (tag.m_128441_("RemainingLifespan")) {
            this.remainingLifespan = tag.m_128451_("RemainingLifespan");
        }
        this.isMoving = tag.m_128471_("IsMoving");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("RemainingCharging", this.remainingCharging);
        tag.m_128379_("IsCharged", this.isCharged);
        tag.m_128405_("RemainingLifespan", this.remainingLifespan);
        tag.m_128379_("IsMoving", this.isMoving);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

