/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa.happy;

import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGiftType;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGifts;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.happy.SummonGiftsGoal;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.sound.christmas.SantaSummonSound;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class HappySantaEntity
extends BaseSantaEntity {
    public static final EntityDataAccessor<Boolean> IS_SUMMONING = SynchedEntityData.m_135353_(HappySantaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final String ENTITY_ID = "happy_santa";
    public static final int DEFAULT_DESPAWN_DELAY = 12000;
    public static final int NUM_GIFTS_TO_SUMMON = 150;
    public static final int GIFT_SUMMON_RADIUS = 20;
    public static final int GIFT_SUMMON_HEIGHT = 5;
    public static final int GIFT_LIFESPAN = 160;
    public static final int GIFT_SPAWN_INTERVAL_MIN = 5;
    public static final int GIFT_SPAWN_INTERVAL_MAX = 10;
    public static final double BASIC_GIFT_SPAWN_CHANCE_THRESHOLD = 1.0;
    public static final double RARE_GIFT_SPAWN_CHANCE_THRESHOLD = 0.25;
    public static final double LEGENDARY_GIFT_SPAWN_CHANCE_THRESHOLD = 0.05;
    private BlockPos summoningPos = null;
    private boolean hasStartedSummoningGifts = false;
    private boolean hasSummonedGifts = false;
    private boolean isSummoning = false;
    private int giftsRemaining = -1;
    private int despawnDelay;
    private SantaSummonSound summonSound;
    private AABB areaOfEffect;
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public HappySantaEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SUMMONING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SummonGiftsGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isSummoning() {
        return this.isSummoning;
    }

    public boolean hasSummonedGifts() {
        return this.hasSummonedGifts;
    }

    public int getGiftsRemaining() {
        return this.giftsRemaining;
    }

    public void startDropParty() {
        if (!this.hasStartedSummoningGifts) {
            this.giftsRemaining = 150;
        }
        this.isSummoning = true;
        this.f_19804_.m_135381_(IS_SUMMONING, (Object)true);
        this.hasStartedSummoningGifts = true;
        if (this.summoningPos == null) {
            this.summoningPos = this.m_142538_();
        }
        this.summonSound = new SantaSummonSound(this.m_142538_());
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.summonSound);
        if (!this.f_19853_.m_5776_()) {
            this.bossEvent.m_142711_((float)this.giftsRemaining / 150.0f);
            this.areaOfEffect = new AABB(this.summoningPos).m_82400_(40.0);
            List playerList = this.f_19853_.m_45976_(Player.class, this.areaOfEffect);
            for (Player playerEntity : playerList) {
                this.bossEvent.m_6543_((ServerPlayer)playerEntity);
            }
        }
    }

    public void stopDropParty() {
        this.isSummoning = false;
        this.f_19804_.m_135381_(IS_SUMMONING, (Object)false);
        this.hasSummonedGifts = true;
        this.summoningPos = null;
        if (this.summonSound != null) {
            this.summonSound.stopTrack();
        }
        this.bossEvent.m_7706_();
        this.despawnDelay = 12000;
        this.m_19983_(((ChristmasItem)ChristmasItems.ENCHANTED_SANTA_HAT.get()).m_7968_());
        if (!this.f_19853_.m_5776_()) {
            AABB searchBox = new AABB(this.m_142538_()).m_82400_(40.0);
            List playerEntities = this.f_19853_.m_45976_(Player.class, searchBox);
            for (Player playerEntity : playerEntities) {
                SantaEvent.CompleteDropParty event = new SantaEvent.CompleteDropParty(this, playerEntity);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
        }
    }

    public void summonGift() {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        int randomX = this.f_19796_.nextInt(20) * (this.f_19796_.nextBoolean() ? 1 : -1);
        int randomY = this.f_19796_.nextInt(5);
        int randomZ = this.f_19796_.nextInt(20) * (this.f_19796_.nextBoolean() ? 1 : -1);
        BlockPos randomPos = this.m_142538_().m_142082_(randomX, randomY, randomZ);
        BlockState currState = this.f_19853_.m_8055_(randomPos);
        for (int counter = 0; !this.f_19853_.m_8055_(randomPos).m_60713_(Blocks.f_50016_) && counter <= 20; ++counter) {
            randomPos = randomPos.m_7494_();
        }
        if (!this.f_19853_.m_8055_(randomPos).m_60713_(Blocks.f_50016_)) {
            return;
        }
        ItemStack giftItem = ItemStack.f_41583_;
        LootContext ctx = this.m_7771_(true, DamageSource.f_19318_).m_78975_(LootContextParamSets.f_81415_);
        SimpleParticleType particleType = null;
        double giftChance = this.f_19796_.nextDouble();
        if (giftChance < 0.05) {
            giftItem = SantaGifts.generateGift(SantaGiftType.LEGENDARY, this, (ServerLevel)this.f_19853_, ctx);
            particleType = (SimpleParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GOLD_PARTICLE.get();
        } else if (giftChance < 0.25) {
            giftItem = SantaGifts.generateGift(SantaGiftType.RARE, this, (ServerLevel)this.f_19853_, ctx);
            particleType = (SimpleParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GREEN_PARTICLE.get();
        } else {
            giftItem = SantaGifts.generateGift(SantaGiftType.BASIC, this, (ServerLevel)this.f_19853_, ctx);
            particleType = (SimpleParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_BLUE_PARTICLE.get();
        }
        ItemEntity giftEntity = new ItemEntity(this.f_19853_, (double)randomPos.m_123341_(), (double)randomPos.m_123342_(), (double)randomPos.m_123343_(), giftItem);
        giftEntity.lifespan = 160;
        for (int i = 0; i < 3; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)particleType, (double)randomPos.m_123341_() + this.f_19796_.nextDouble(), (double)randomPos.m_123342_() + this.f_19796_.nextDouble(), (double)randomPos.m_123343_() + this.f_19796_.nextDouble(), 1, d0, d1, d2, 0.0);
        }
        this.f_19853_.m_7967_((Entity)giftEntity);
        this.f_19853_.m_6263_(null, (double)randomPos.m_123341_(), (double)randomPos.m_123342_(), (double)randomPos.m_123343_(), (SoundEvent)ChristmasSounds.SANTA_ITEM_APPEAR.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        --this.giftsRemaining;
        this.bossEvent.m_142711_((float)this.giftsRemaining / 150.0f);
    }

    public void createSummoningParticle() {
        double d0 = (double)(this.f_19796_.nextFloat() * 0.1f) + 0.25;
        double d1 = (double)(this.f_19796_.nextFloat() * 0.1f) + 0.25;
        double d2 = (double)(this.f_19796_.nextFloat() * 0.1f) + 0.25;
        double d = this.f_19796_.nextDouble();
        SimpleParticleType particleType = d < 0.25 ? (SimpleParticleType)ChristmasParticles.CHRISTMAS_SMALL_RED_PARTICLE.get() : (d < 0.5 ? (SimpleParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_RED_PARTICLE.get() : (d < 0.75 ? (SimpleParticleType)ChristmasParticles.CHRISTMAS_SMALL_GREEN_PARTICLE.get() : (SimpleParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GREEN_PARTICLE.get()));
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)particleType, this.m_20185_(), this.m_20186_() + d1 + 1.5, this.m_20189_(), 2, d0, d1, d2, 0.0);
    }

    public BlockPos getSummoningPos() {
        return this.summoningPos;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("HasSummonedGifts", this.hasSummonedGifts);
        nbt.m_128379_("HasStartedSummoningGifts", this.hasStartedSummoningGifts);
        nbt.m_128405_("GiftsRemaining", this.giftsRemaining);
        nbt.m_128405_("DespawnDelay", this.despawnDelay);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.hasSummonedGifts = nbt.m_128471_("HasSummonedGifts");
        this.hasStartedSummoningGifts = nbt.m_128471_("HasStartedSummoningGifts");
        this.giftsRemaining = nbt.m_128451_("GiftsRemaining");
        this.despawnDelay = nbt.m_128451_("DespawnDelay");
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        this.bossEvent.m_7706_();
        this.isSummoning = false;
        if (this.summonSound != null) {
            this.summonSound.stopTrack();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.m_5776_()) {
            this.isSummoning = (Boolean)this.f_19804_.m_135370_(IS_SUMMONING);
        } else if (this.isSummoning) {
            this.createSummoningParticle();
            if (this.m_6084_() && this.f_19853_.m_46467_() % 60L == 0L) {
                List playerList = this.f_19853_.m_45976_(Player.class, this.areaOfEffect);
                for (ServerPlayer serverPlayerEntity : this.bossEvent.m_8324_()) {
                    if (playerList.contains(serverPlayerEntity)) continue;
                    this.bossEvent.m_6539_(serverPlayerEntity);
                }
                for (Player playerEntity : playerList) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
                    if (this.bossEvent.m_8324_().contains(serverPlayerEntity)) continue;
                    this.bossEvent.m_6543_((ServerPlayer)playerEntity);
                }
            }
        } else {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && --this.despawnDelay == 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ChristmasSounds.SANTA_PASSIVE.get();
    }

    @Override
    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isSummoning) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.summon", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return super.predicate(event);
    }
}

