/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.events.christmas.handlers;

import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarBlockEntity;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarHelper;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.AngrySantaEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.ChristmasStarEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.GingerbreadConversionEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.GrinchEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaElfEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.StockingEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.food.ChristmasFoodItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.music.SheetMusicItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="happyholidays", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChristmasEvents {
    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        Player playerEntity;
        MobEffectInstance effectInstance;
        if (event.getEntity() instanceof Player && event.getItem().m_41614_() && (effectInstance = (playerEntity = (Player)event.getEntity()).m_21124_((MobEffect)ChristmasEffects.SPIRIT_OF_CHRISTMAS_EFFECT.get())) != null) {
            ItemStack foodItemStack = event.getItem();
            int effectAmplifier = effectInstance.m_19564_();
            int nutritionValue = foodItemStack.m_41720_().m_41473_().m_38744_();
            if (ChristmasFoodItem.isChristmasFood(foodItemStack)) {
                playerEntity.m_36324_().m_38707_((int)((double)(effectAmplifier + 1) * 0.2 * (double)nutritionValue), 0.0f);
            } else {
                playerEntity.m_36324_().m_38707_((int)((double)(effectAmplifier + 1) * 0.1 * (double)nutritionValue), 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof Player && ChristmasBlocks.isInfluencedByStar(event.getPlacedBlock().m_60734_())) {
            Player playerEntity = (Player)event.getEntity();
            ChristmasStarBlockEntity starBlockEntity = ChristmasStarHelper.getStarInfluencingBlock(playerEntity.f_19853_, event.getPos());
            if (starBlockEntity != null && starBlockEntity.isPosAffected(event.getPos())) {
                BlockPos placedBlockPos = event.getBlockSnapshot().getPos();
                int particleCount = starBlockEntity.getCurrentTier() + (starBlockEntity.isBonusActive() ? 1 : 0);
                for (int i = 0; i < starBlockEntity.getCurrentTier(); ++i) {
                    double d0 = (double)(playerEntity.m_21187_().nextFloat() * 0.1f) + 0.25;
                    double d1 = (double)(playerEntity.m_21187_().nextFloat() * 0.1f) + 0.25;
                    double d2 = (double)(playerEntity.m_21187_().nextFloat() * 0.1f) + 0.25;
                    SimpleParticleType particleType = playerEntity.m_21187_().nextBoolean() ? (SimpleParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_RED_PARTICLE.get() : (SimpleParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GREEN_PARTICLE.get();
                    ((ServerLevel)playerEntity.f_19853_).m_8767_((ParticleOptions)particleType, (double)placedBlockPos.m_123341_() + 0.5, (double)placedBlockPos.m_123342_() + 0.5, (double)placedBlockPos.m_123343_() + 0.5, 1, d0, d1, d2, 0.0);
                }
                ((ServerLevel)playerEntity.f_19853_).m_5594_(null, event.getPos(), (SoundEvent)ChristmasSounds.CHRISTMAS_STAR_BLOCK_PLACE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onItemInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)event.getEntity();
            ItemStack itemInHand = playerEntity.m_21120_(event.getHand());
            BlockState blockState = playerEntity.f_19853_.m_8055_(event.getPos());
            if (itemInHand.m_41720_() instanceof SheetMusicItem && blockState.m_60713_((Block)ChristmasBlocks.MUSIC_BOX.get())) {
                ChristmasTriggers.CHRISTMAS_PLAY_MUSIC_BOX.trigger(playerEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        ChristmasStarHelper.onWorldLoad(event);
    }

    @SubscribeEvent
    public static void onGingerbreadConversion(GingerbreadConversionEvent event) {
        if (event instanceof GingerbreadConversionEvent.ToSoggy) {
            ChristmasTriggers.CHRISTMAS_GINGERBREAD_MAN_TURN_SOGGY.trigger((ServerPlayer)event.getPlayer());
        } else if (event instanceof GingerbreadConversionEvent.ToDry) {
            ChristmasTriggers.CHRISTMAS_GINGERBREAD_MAN_TURN_DRY.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onSantaElfInteract(SantaElfEvent event) {
        if (event instanceof SantaElfEvent.Summon) {
            ChristmasTriggers.CHRISTMAS_SANTA_ELF_SUMMON.trigger((ServerPlayer)event.getPlayer());
        } else if (event instanceof SantaElfEvent.Trade) {
            ChristmasTriggers.CHRISTMAS_SANTA_ELF_TRADE.trigger((ServerPlayer)event.getPlayer());
        } else if (event instanceof SantaElfEvent.CompleteRequest) {
            ChristmasTriggers.CHRISTMAS_SANTA_ELF_COMPLETE_REQUEST.trigger((ServerPlayer)event.getPlayer());
            if (((SantaElfEvent.CompleteRequest)event).getTimeTaken() <= 6000) {
                ChristmasTriggers.CHRISTMAS_SANTA_ELF_COMPLETE_REQUEST_QUICK.trigger((ServerPlayer)event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public static void onGrinchInteract(GrinchEvent event) {
        if (event instanceof GrinchEvent.Encounter) {
            ChristmasTriggers.CHRISTMAS_GRINCH_ENCOUNTER.trigger((ServerPlayer)event.getPlayer());
        } else if (event instanceof GrinchEvent.Appease) {
            ChristmasTriggers.CHRISTMAS_GRINCH_APPEASE.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onSantaInteract(SantaEvent event) {
        if (event instanceof SantaEvent.AngryDie) {
            ChristmasTriggers.CHRISTMAS_SANTA_ANGRY_DIE.trigger((ServerPlayer)event.getPlayer());
            AngrySantaEntity angrySantaEntity = (AngrySantaEntity)event.getSantaEntity();
            if (!angrySantaEntity.isDamagedByPlayer()) {
                ChristmasTriggers.CHRISTMAS_SANTA_NO_TOUCHY.trigger((ServerPlayer)event.getPlayer());
            }
        } else if (event instanceof SantaEvent.CompleteDropParty) {
            ChristmasTriggers.CHRISTMAS_SANTA_DROP_PARTY_COMPLETE.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onStockingFill(StockingEvent event) {
        if (event instanceof StockingEvent.Fill) {
            ChristmasTriggers.CHRISTMAS_STOCKING_FILL.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onChristmasStarInteract(ChristmasStarEvent event) {
        if (event instanceof ChristmasStarEvent.PutOrnament) {
            ChristmasTriggers.CHRISTMAS_STAR_PUT_ORNAMENT.trigger((ServerPlayer)event.getPlayer());
        } else if (event instanceof ChristmasStarEvent.IncreaseTier) {
            ChristmasStarEvent.IncreaseTier increaseTierEvent = (ChristmasStarEvent.IncreaseTier)event;
            if (increaseTierEvent.getTier() == 5) {
                ChristmasTriggers.CHRISTMAS_STAR_MAXED_TIER.trigger((ServerPlayer)event.getPlayer());
            }
        } else if (event instanceof ChristmasStarEvent.SummonSanta) {
            ChristmasTriggers.CHRISTMAS_STAR_SUMMON_SANTA.trigger((ServerPlayer)event.getPlayer());
        } else if (event instanceof ChristmasStarEvent.ReachBonus) {
            ChristmasTriggers.CHRISTMAS_STAR_REACH_BONUS.trigger((ServerPlayer)event.getPlayer());
        }
    }
}

