/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.events.christmas.handlers;

import com.jumpcutfindo.happyholidays.common.capabilities.christmas.CapabilityNaughtyNice;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.INaughtyNiceHandler;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceAction;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="happyholidays", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NaughtyNiceEvents {
    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        Player originalPlayer = event.getOriginal();
        if (event.isWasDeath()) {
            originalPlayer.reviveCaps();
            Player newPlayer = event.getPlayer();
            Optional oldCapability = originalPlayer.getCapability(CapabilityNaughtyNice.NAUGHTY_NICE_CAPABILITY).resolve();
            if (oldCapability.isPresent()) {
                Optional newCapability = newPlayer.getCapability(CapabilityNaughtyNice.NAUGHTY_NICE_CAPABILITY).resolve();
                if (newCapability.isPresent()) {
                    NaughtyNiceMeter naughtyNiceMeter = (NaughtyNiceMeter)newCapability.get();
                    naughtyNiceMeter.setValue(((INaughtyNiceHandler)oldCapability.get()).getValue());
                }
                originalPlayer.invalidateCaps();
            }
        }
    }

    @SubscribeEvent
    public static void onKillEntity(LivingDeathEvent event) {
        if (event.getSource().m_7639_() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getSource().m_7639_();
            LivingEntity killedEntity = event.getEntityLiving();
            if (killedEntity.getClassification(false) != MobCategory.MONSTER) {
                if (killedEntity instanceof SantaElfEntity) {
                    NaughtyNiceMeter.evaluateAction((Player)player, NaughtyNiceAction.KILL_SANTA_ELF_EVENT);
                } else {
                    NaughtyNiceMeter.evaluateAction((Player)player, NaughtyNiceAction.KILL_PASSIVE_MOB_EVENT);
                }
            } else if (!(killedEntity instanceof BaseSantaEntity)) {
                NaughtyNiceMeter.evaluateAction((Player)player, NaughtyNiceAction.KILL_HOSTILE_MOB_EVENT);
            }
        }
    }
}

