/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.item.christmas.misc;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaElfEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasRarity;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.sound.christmas.SantaBellSound;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SantaElfBellItem
extends ChristmasItem {
    public static final String ITEM_ID = "santa_elf_bell";
    public static final int ITEM_USE_DURATION = 35;
    public static final int ITEM_COOLDOWN = 24000;
    private static final Item.Properties ITEM_PROPERTIES = new Item.Properties().m_41491_(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP).m_41487_(1).m_41499_(24000);
    private SantaBellSound bellSound;

    public SantaElfBellItem() {
        super(ITEM_PROPERTIES);
        this.setChristmasRarity(ChristmasRarity.LEGENDARY);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        CompoundTag nbt = player.m_21120_(hand).m_41783_();
        long nextUseTime = nbt.m_128454_("NextUseTime");
        if (world.m_46467_() > nextUseTime) {
            player.m_6672_(hand);
            player.m_5496_((SoundEvent)ChristmasSounds.SANTA_ELF_BELL.get(), 1.0f, 1.0f);
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)world.m_5776_());
        }
        long timeRemaining = nbt.m_128454_("NextUseTime") - world.m_46467_();
        TranslatableComponent chatComponent = new TranslatableComponent("chat.happyholidays.santa_elf_bell.not_ready", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)});
        chatComponent.m_130940_(ChatFormatting.RED);
        player.m_5661_((Component)chatComponent, true);
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            BlockPos playerPos = playerEntity.m_142538_();
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128356_("NextUseTime", world.m_46467_() + 24000L);
            BlockPos posAhead = HappyHolidaysUtils.getPosInFront(playerEntity.m_6350_(), playerPos, 4.0);
            double spawnX = posAhead.m_123341_();
            double spawnY = posAhead.m_123342_();
            double spawnZ = posAhead.m_123343_();
            SantaElfEntity santaElfEntity = (SantaElfEntity)((EntityType)ChristmasEntities.SANTA_ELF.get()).m_20615_(world);
            santaElfEntity.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.m_7967_((Entity)santaElfEntity);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0);
            world.m_5594_(null, posAhead, (SoundEvent)ChristmasSounds.SANTA_ELF_ARRIVAL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            SantaElfEvent.Summon elfSummonEvent = new SantaElfEvent.Summon(santaElfEntity, playerEntity);
            MinecraftForge.EVENT_BUS.post((Event)elfSummonEvent);
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 35;
    }

    public boolean m_5812_(ItemStack p_77636_1_) {
        return true;
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> textComponents, TooltipFlag tooltipFlag) {
        long timeRemaining;
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null && world != null && (timeRemaining = nbt.m_128454_("NextUseTime") - world.m_46467_()) > 0L) {
            TranslatableComponent textComponent = new TranslatableComponent("item.happyholidays.santa_elf_bell.cooldown", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)});
            textComponent.m_130940_(ChatFormatting.GRAY);
            textComponents.add((Component)textComponent);
        }
    }
}

