/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.item.christmas.misc;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRequest;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasRarity;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ToyPartsRequestItem
extends ChristmasItem {
    public static final String ITEM_ID = "toy_parts_request";
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().m_41491_(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP).m_41487_(1);

    public ToyPartsRequestItem() {
        super(ITEM_PROPERTIES);
        this.setChristmasRarity(ChristmasRarity.UNIQUE);
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> textComponents, TooltipFlag tooltipFlag) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            SantaElfRequest santaElfRequest = SantaElfRequest.fromTag(nbt.m_128469_("SantaElfRequest"));
            for (SantaElfRequest.SingleElfRequest request : santaElfRequest.getRequestedItems()) {
                TextComponent formattableTextComponent = new TextComponent(request.toString());
                if (request.isCompleted()) {
                    formattableTextComponent.m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                textComponents.add((Component)formattableTextComponent.m_130940_(ChatFormatting.GRAY));
            }
            long timeRemaining = santaElfRequest.getExpiryTime() - world.m_46467_();
            if (timeRemaining > 0L) {
                textComponents.add((Component)new TextComponent(""));
                TranslatableComponent expiryTextComponent = new TranslatableComponent("item.happyholidays.toy_parts_request.expires_in", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)});
                expiryTextComponent.m_130940_(ChatFormatting.GRAY);
                textComponents.add((Component)expiryTextComponent);
            }
        }
    }
}

