/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.utils;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HappyHolidaysUtils {
    public static VoxelShape rotateShape(VoxelShape shape, Rotation rotationDir) {
        double x1 = shape.m_83215_().f_82288_;
        double x2 = shape.m_83215_().f_82291_;
        double y1 = shape.m_83215_().f_82289_;
        double y2 = shape.m_83215_().f_82292_;
        double z1 = shape.m_83215_().f_82290_;
        double z2 = shape.m_83215_().f_82293_;
        if (rotationDir == Rotation.CLOCKWISE_90 || rotationDir == Rotation.COUNTERCLOCKWISE_90) {
            double temp = z1;
            z1 = x1;
            x1 = temp;
            temp = z2;
            z2 = x2;
            x2 = temp;
        }
        if (rotationDir == Rotation.CLOCKWISE_90 || rotationDir == Rotation.CLOCKWISE_180) {
            x1 = 1.0 - x1;
            x2 = 1.0 - x2;
        }
        if (rotationDir == Rotation.COUNTERCLOCKWISE_90 || rotationDir == Rotation.CLOCKWISE_180) {
            z1 = 1.0 - z1;
            z2 = 1.0 - z2;
        }
        return Shapes.m_83048_((double)Math.min(x1, x2), (double)Math.min(y1, y2), (double)Math.min(z1, z2), (double)Math.max(x1, x2), (double)Math.max(y1, y2), (double)Math.max(z1, z2));
    }

    public static VoxelShape combineShapes(VoxelShape[] voxelShapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : voxelShapes) {
            result = Shapes.m_83113_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return result;
    }

    public static BlockPos getPosInFront(Direction facingDirection, BlockPos pos, double offset) {
        BlockPos resultPos = pos;
        if (facingDirection == Direction.NORTH || facingDirection == Direction.UP || facingDirection == Direction.DOWN) {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.m_142127_();
                ++i;
            }
        } else if (facingDirection == Direction.SOUTH) {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.m_142128_();
                ++i;
            }
        } else if (facingDirection == Direction.EAST) {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.m_142126_();
                ++i;
            }
        } else {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.m_142125_();
                ++i;
            }
        }
        return resultPos;
    }

    public static String convertTicksToString(long ticks) {
        long seconds = ticks / 20L;
        return String.format("%dm %ds", seconds / 60L, seconds % 60L);
    }

    public static BlockPos findBlockInRadius(LevelAccessor world, BlockPos currPos, Block block, int radius) {
        BlockPos startPos = currPos.m_142082_(-radius, -radius, -radius);
        for (int x = 0; x < radius * 2; ++x) {
            for (int y = 0; y < radius * 2; ++y) {
                for (int z = 0; z < radius * 2; ++z) {
                    BlockPos checkingPos = startPos.m_142082_(x, y, z);
                    if (!world.m_8055_(checkingPos).m_60713_(block)) continue;
                    return checkingPos;
                }
            }
        }
        return null;
    }

    public static List<Player> findPlayersInRadius(Level world, Vec3 pos, double radius) {
        AABB box = new AABB(new BlockPos(pos)).m_82400_(radius);
        return world.m_45976_(Player.class, box);
    }
}

