/*
 * Decompiled with CFR 0.152.
 */
package fluke.hexlands.util.hex;

import fluke.hexlands.util.hex.Hex;
import java.util.ArrayList;

public class FractionalHex {
    public final double q;
    public final double r;
    public final double s;

    public FractionalHex(double q, double r, double s) {
        this.q = q;
        this.r = r;
        this.s = s;
        if (Math.round(q + r + s) != 0L) {
            throw new IllegalArgumentException("q + r + s must be 0");
        }
    }

    public Hex hexRound() {
        int qi = (int)Math.round(this.q);
        int ri = (int)Math.round(this.r);
        int si = (int)Math.round(this.s);
        double q_diff = Math.abs((double)qi - this.q);
        double r_diff = Math.abs((double)ri - this.r);
        double s_diff = Math.abs((double)si - this.s);
        if (q_diff > r_diff && q_diff > s_diff) {
            qi = -ri - si;
        } else if (r_diff > s_diff) {
            ri = -qi - si;
        } else {
            si = -qi - ri;
        }
        return new Hex(qi, ri, si);
    }

    public FractionalHex hexLerp(FractionalHex b, double t) {
        return new FractionalHex(this.q * (1.0 - t) + b.q * t, this.r * (1.0 - t) + b.r * t, this.s * (1.0 - t) + b.s * t);
    }

    public static ArrayList<Hex> hexLinedraw(Hex a, Hex b) {
        int N = a.distance(b);
        FractionalHex a_nudge = new FractionalHex((double)a.q + 1.0E-6, (double)a.r + 1.0E-6, (double)a.s - 2.0E-6);
        FractionalHex b_nudge = new FractionalHex((double)b.q + 1.0E-6, (double)b.r + 1.0E-6, (double)b.s - 2.0E-6);
        ArrayList<Hex> results = new ArrayList<Hex>(){};
        double step = 1.0 / (double)Math.max(N, 1);
        for (int i = 0; i <= N; ++i) {
            results.add(a_nudge.hexLerp(b_nudge, step * (double)i).hexRound());
        }
        return results;
    }
}

