/*
 * Decompiled with CFR 0.152.
 */
package fluke.hexlands.util.hex;

import fluke.hexlands.util.hex.FractionalHex;
import fluke.hexlands.util.hex.Hex;
import fluke.hexlands.util.hex.Orientation;
import fluke.hexlands.util.hex.Point;
import java.util.ArrayList;

public class Layout {
    public final Orientation orientation;
    public final Point size;
    public final Point origin;
    public static Orientation pointy = new Orientation(1.732050808, 0.866025404, 0.0, 1.5, 0.5773502693333333, -0.3333333333333333, 0.0, 0.6666666666666666, 0.5);
    public static Orientation flat = new Orientation(1.5, 0.0, 0.866025404, 1.732050808, 0.6666666666666666, 0.0, -0.3333333333333333, 0.5773502693333333, 0.0);

    public Layout(Orientation orientation, Point size, Point origin) {
        this.orientation = orientation;
        this.size = size;
        this.origin = origin;
    }

    public Point hexToPixel(Hex h) {
        Orientation M = this.orientation;
        double x = (M.f0 * (double)h.q + M.f1 * (double)h.r) * this.size.x;
        double y = (M.f2 * (double)h.q + M.f3 * (double)h.r) * this.size.y;
        return new Point(x + this.origin.x, y + this.origin.y);
    }

    public FractionalHex pixelToHex(Point p) {
        Orientation M = this.orientation;
        Point pt = new Point((p.x - this.origin.x) / this.size.x, (p.y - this.origin.y) / this.size.y);
        double q = M.b0 * pt.x + M.b1 * pt.y;
        double r = M.b2 * pt.x + M.b3 * pt.y;
        return new FractionalHex(q, r, -q - r);
    }

    public Point hexCornerOffset(int corner) {
        Orientation M = this.orientation;
        double angle = Math.PI * 2 * (M.start_angle - (double)corner) / 6.0;
        return new Point(this.size.x * Math.cos(angle), this.size.y * Math.sin(angle));
    }

    public ArrayList<Point> polygonCorners(Hex h) {
        ArrayList<Point> corners = new ArrayList<Point>(){};
        Point center = this.hexToPixel(h);
        for (int i = 0; i < 6; ++i) {
            Point offset = this.hexCornerOffset(i);
            corners.add(new Point(center.x + offset.x, center.y + offset.y));
        }
        return corners;
    }
}

