/*
 * Decompiled with CFR 0.152.
 */
package fluke.hexlands.world;

import com.google.common.base.Predicate;
import fluke.hexlands.config.Configs;
import fluke.hexlands.util.SimplexNoise;
import fluke.hexlands.util.hex.Hex;
import fluke.hexlands.util.hex.Layout;
import fluke.hexlands.util.hex.Point;
import fluke.hexlands.util.hex.TestEdge;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import net.minecraft.world.gen.feature.WorldGenGlowStone2;
import net.minecraft.world.gen.feature.WorldGenHellLava;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ChunkGeneratorHellHex
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState NETHERRACK = Blocks.field_150424_aL.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState SOUL_SAND = Blocks.field_150425_aM.func_176223_P();
    protected static final IBlockState NETHER_WART_BLOCK = Blocks.field_189878_dg.func_176223_P();
    private final World world;
    private final boolean generateStructures;
    private final Random rand;
    private final WorldGenFire fireFeature = new WorldGenFire();
    private final WorldGenGlowStone1 lightGemGen = new WorldGenGlowStone1();
    private final WorldGenGlowStone2 hellPortalGen = new WorldGenGlowStone2();
    private final WorldGenerator quartzGen = new WorldGenMinable(Blocks.field_150449_bY.func_176223_P(), 14, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private final WorldGenerator magmaGen = new WorldGenMinable(Blocks.field_189877_df.func_176223_P(), 33, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private final WorldGenHellLava lavaTrapGen = new WorldGenHellLava((Block)Blocks.field_150356_k, true);
    private final WorldGenHellLava hellSpringGen = new WorldGenHellLava((Block)Blocks.field_150356_k, false);
    private final WorldGenBush brownMushroomFeature = new WorldGenBush(Blocks.field_150338_P);
    private final WorldGenBush redMushroomFeature = new WorldGenBush(Blocks.field_150337_Q);
    private MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private MapGenBase genNetherCaves = new MapGenCavesHell();
    protected Layout hex_layout;
    public static int netherSeaLevel;
    public static int netherMaxHeight;
    private IBlockState rimBlock;
    public Biome[] biomemap;

    public ChunkGeneratorHellHex(World worldIn, boolean generateStructures, long seed) {
        this.hex_layout = new Layout(Layout.flat, new Point(Configs.worldgen.hexSize, Configs.worldgen.hexSize), new Point(0.0, 0.0));
        this.updateRimBlock();
        netherSeaLevel = Configs.nether.netherSeaLevel;
        this.world = worldIn;
        this.generateStructures = generateStructures;
        this.rand = new Random(seed);
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.genNetherCaves = TerrainGen.getModdedMapGen((MapGenBase)this.genNetherCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.biomemap = new Biome[256];
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                boolean solidHex;
                int realZ = z + chunkZ * 16;
                int hexHeight = 35;
                int hexRoofDepth = 20;
                Hex hexy = this.hex_layout.pixelToHex(new Point(realX, realZ)).hexRound();
                Point center_pt = this.hex_layout.hexToPixel(hexy);
                double wallNoise = SimplexNoise.noise(center_pt.getX() / 80, center_pt.getZ() / 80);
                boolean bl = solidHex = wallNoise > 0.4;
                if (solidHex) {
                    for (int y = 1; y < netherMaxHeight; ++y) {
                        primer.func_177855_a(x, y, z, NETHERRACK);
                    }
                } else {
                    int y;
                    int zdif;
                    double soulNoise = (SimplexNoise.noise(center_pt.getX() * 7, center_pt.getZ() * 7) + 1.0) / 2.0;
                    boolean isTopHexSoul = soulNoise > 1.0 - Configs.nether.souldHexChance;
                    double soulChanceOverlap = 1.0 - Configs.nether.souldHexChance * 0.65;
                    boolean isBottomHexSoul = soulNoise < soulChanceOverlap && soulNoise > soulChanceOverlap - Configs.nether.souldHexChance * 0.8;
                    double hexNoise = SimplexNoise.noise(center_pt.getX() / 40, center_pt.getZ() / 40);
                    double roofHeightNoise = SimplexNoise.noise(center_pt.getX() / 20, center_pt.getZ() / 20);
                    double terrainNoise = SimplexNoise.noise(realX, realZ, 160.0, 160.0, 0.5, 2);
                    double terrainNoiser = SimplexNoise.noise(realX, realZ, 60.0, 60.0, 0.5, 4);
                    double roofNoise = SimplexNoise.noise(realX, realZ, 120.0, 120.0, 0.5, 2);
                    double roofNoiser = SimplexNoise.noise(realX, realZ, 80.0, 80.0, 0.5, 4);
                    double hexTerrainNoise = terrainNoise + 0.7 * terrainNoiser;
                    double roofTerrainNoise = roofNoise + 0.7 * roofNoiser;
                    double midlandTerrainNoise = terrainNoise * 0.8 + 0.5 * roofNoise + 0.5 * roofNoiser;
                    double midlandRoofNoise = Math.abs(roofNoise * 0.8 + 0.5 * terrainNoise + 0.5 * terrainNoiser);
                    boolean isEdgeBlock = TestEdge.isEdge(new Point(realX, realZ), center_pt, hexy, Configs.worldgen.hexSize, Configs.worldgen.hexSize, Configs.nether.netherRimSize);
                    hexHeight = (int)((double)hexHeight + hexNoise * 26.0);
                    hexRoofDepth = (int)((double)hexRoofDepth + roofHeightNoise * 16.0);
                    int roofDepth = (int)((double)hexRoofDepth + roofTerrainNoise * 6.0);
                    int midLand = (netherMaxHeight - hexRoofDepth + hexHeight) / 2;
                    int xdif = realX - center_pt.getX();
                    double distance_from_origin = Math.sqrt(xdif * xdif + (zdif = realZ - center_pt.getZ()) * zdif);
                    double distance_ratio = distance_from_origin / (double)Configs.worldgen.hexSize;
                    if (distance_ratio > 0.9) {
                        distance_ratio = 0.9;
                    }
                    int blockDesiredHeight = (int)Math.round((double)hexHeight + hexTerrainNoise * 6.0);
                    int finalBlockHeight = (int)Math.round((double)blockDesiredHeight * (1.0 - distance_ratio) + (double)hexHeight * distance_ratio);
                    for (y = 1; y < finalBlockHeight; ++y) {
                        if (Configs.nether.netherExtendedRimBlock && isEdgeBlock) {
                            primer.func_177855_a(x, y, z, this.rimBlock);
                            continue;
                        }
                        primer.func_177855_a(x, y, z, NETHERRACK);
                    }
                    if (isBottomHexSoul) {
                        primer.func_177855_a(x, finalBlockHeight - 1, z, SOUL_SAND);
                    }
                    if (finalBlockHeight <= netherSeaLevel) {
                        for (y = finalBlockHeight; y <= netherSeaLevel; ++y) {
                            primer.func_177855_a(x, y, z, LAVA);
                        }
                    } else if (isEdgeBlock) {
                        for (y = finalBlockHeight; y < hexHeight; ++y) {
                            primer.func_177855_a(x, y, z, NETHERRACK);
                        }
                        primer.func_177855_a(x, hexHeight, z, this.rimBlock);
                    }
                    for (int y2 = netherMaxHeight - roofDepth; y2 < netherMaxHeight; ++y2) {
                        primer.func_177855_a(x, y2, z, NETHERRACK);
                    }
                    double midLandNoise = SimplexNoise.noise(center_pt.getX() / 20, midLand, center_pt.getZ() / 20);
                    if (midLandNoise > 0.1) {
                        int midThicc = (int)(Math.abs(midLandNoise) * 6.0) + 3;
                        int midHexBottom = midLand - midThicc;
                        int midBottomDesiredHeight = (int)Math.round((double)midHexBottom - midlandRoofNoise * 4.0);
                        int midHexTop = midLand + midThicc;
                        int midTopDesiredHeight = (int)Math.round((double)midHexTop + midlandTerrainNoise * 4.0);
                        int finalBottomBlockHeight = (int)Math.round((double)midBottomDesiredHeight * (1.0 - distance_ratio) + (double)midHexBottom * distance_ratio);
                        int finalTopBlockHeight = (int)Math.round((double)midTopDesiredHeight * (1.0 - distance_ratio) + (double)midHexTop * distance_ratio);
                        for (int midY = finalBottomBlockHeight; midY < finalTopBlockHeight; ++midY) {
                            if (Configs.nether.netherExtendedRimBlock && isEdgeBlock) {
                                primer.func_177855_a(x, midY, z, this.rimBlock);
                                continue;
                            }
                            primer.func_177855_a(x, midY, z, NETHERRACK);
                        }
                        if (isTopHexSoul) {
                            primer.func_177855_a(x, finalTopBlockHeight - 1, z, SOUL_SAND);
                        }
                        if (isEdgeBlock) {
                            primer.func_177855_a(x, midHexTop, z, this.rimBlock);
                        }
                    }
                }
                primer.func_177855_a(x, 0, z, BEDROCK);
                primer.func_177855_a(x, netherMaxHeight, z, BEDROCK);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.generateTerrain(x, z, chunkprimer);
        this.genNetherCaves.func_186125_a(this.world, x, z, chunkprimer);
        if (this.generateStructures) {
            this.genNetherBridge.func_186125_a(this.world, x, z, chunkprimer);
        }
        this.generateBiomemap(x * 16, z * 16);
        this.replaceBiomeBlocks(x, z, chunkprimer, this.biomemap);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomemap[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, 0.5);
            }
        }
    }

    public void func_185931_b(int x, int z) {
        boolean prevLogging = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos);
        ChunkPos chunkpos = new ChunkPos(x, z);
        this.genNetherBridge.func_175794_a(this.world, this.rand, chunkpos);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA)) {
            for (int k = 0; k < 8; ++k) {
                this.hellSpringGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE)) {
            for (int i1 = 0; i1 < this.rand.nextInt(this.rand.nextInt(10) + 1) + 1; ++i1) {
                this.fireFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE)) {
            for (int j1 = 0; j1 < this.rand.nextInt(this.rand.nextInt(10) + 1); ++j1) {
                this.lightGemGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
            for (int k1 = 0; k1 < 10; ++k1) {
                this.hellPortalGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, blockpos));
        if (TerrainGen.decorate((World)this.world, (Random)this.rand, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            if (this.rand.nextBoolean()) {
                this.brownMushroomFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
            if (this.rand.nextBoolean()) {
                this.redMushroomFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.quartzGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ)) {
            for (int l1 = 0; l1 < 16; ++l1) {
                this.quartzGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(108) + 10, this.rand.nextInt(16)));
            }
        }
        int i2 = this.world.func_181545_F() / 2 + 1;
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_MAGMA)) {
            for (int l = 0; l < 4; ++l) {
                this.magmaGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16), i2 - 5 + this.rand.nextInt(10), this.rand.nextInt(16)));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA2)) {
            for (int j2 = 0; j2 < 16; ++j2) {
                int offset = ForgeModContainer.fixVanillaCascading ? 8 : 0;
                this.lavaTrapGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + offset, this.rand.nextInt(108) + 10, this.rand.nextInt(16) + offset));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, blockpos));
        BlockFalling.field_149832_M = false;
        ForgeModContainer.logCascadingWorldGeneration = prevLogging;
    }

    private void generateBiomemap(int startX, int startZ) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.biomemap[x + z * 16] = this.world.func_72959_q().func_180631_a(new BlockPos(startX + x, 0, startZ + z));
            }
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.genNetherBridge.func_175795_b(pos)) {
                return this.genNetherBridge.func_75059_a();
            }
            if (this.genNetherBridge.func_175796_a(this.world, pos) && this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                return this.genNetherBridge.func_75059_a();
            }
        }
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return "Fortress".equals(structureName) && this.genNetherBridge != null ? this.genNetherBridge.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return "Fortress".equals(structureName) && this.genNetherBridge != null ? this.genNetherBridge.func_175795_b(pos) : false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.genNetherBridge.func_186125_a(this.world, x, z, (ChunkPrimer)null);
    }

    public void updateRimBlock() {
        String rimblock = Configs.nether.netherRimBlock;
        if (rimblock.indexOf("@") > 0) {
            String[] metarim = rimblock.split("@");
            this.rimBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(metarim[0]))).func_176203_a(Integer.parseInt(metarim[1]));
        } else {
            this.rimBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(rimblock))).func_176223_P();
        }
    }

    static {
        netherMaxHeight = 128;
    }
}

