/*
 * Decompiled with CFR 0.152.
 */
package fluke.hexlands.world;

import fluke.hexlands.util.SimplexNoise;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorOverworldCustom
implements IChunkGenerator {
    final Random rand = new Random();
    final World world;
    Biome[] biomesForGeneration;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves forestNoise;
    double[] heightMap = null;
    float[] tittymonster = null;

    public ChunkGeneratorOverworldCustom(World world) {
        this.world = world;
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.forestNoise = new NoiseGeneratorOctaves(this.rand, 8);
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, this.scaleNoise, this.depthNoise, this.forestNoise);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.generateTerrain(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        float prevBH = 0.001f;
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int height;
                int realZ = z + chunkZ * 16;
                Biome this_biome = this.world.func_72959_q().func_180631_a(new BlockPos(realX, 90, realZ));
                float biomeBaseHeight = this_biome.func_185355_j();
                float biomeVariation = this_biome.func_185360_m();
                float bVar = biomeVariation * 0.6f + 0.1f;
                float bBas = (biomeBaseHeight * 16.0f - 2.0f) / 8.0f;
                bBas = 8.5f + bBas * 4.0f;
                double noise = SimplexNoise.noise(realX, realZ, 100.0, 100.0, 0.5, 6);
                double noiser = SimplexNoise.noise(realX, realZ, 40.0, 40.0, 0.5, 2);
                double noisyist = SimplexNoise.noise(realX, realZ, 20.0, 20.0, 0.5, 2);
                noise += noiser * 0.9 + noisyist * 0.6;
                if ((height = (int)((double)(60.0f + 2.0f * bBas) + 50.0 * (noise *= Math.abs(noise + 0.5) * 0.8) * (double)bVar)) > 256) {
                    height = 256;
                } else if (height < 1) {
                    height = 1;
                }
                for (int y = 0; y < height; ++y) {
                    if (y > height) continue;
                    primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                }
                if (height >= 128) continue;
                primer.func_177855_a(x, height, z, Blocks.field_150349_c.func_176223_P());
            }
        }
    }

    public void func_185931_b(int x, int z) {
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return null;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

