/*
 * Decompiled with CFR 0.152.
 */
package fluke.hexlands.world;

import fluke.hexlands.Main;
import fluke.hexlands.config.Configs;
import fluke.hexlands.util.SimplexNoise;
import fluke.hexlands.util.hex.Hex;
import fluke.hexlands.util.hex.Layout;
import fluke.hexlands.util.hex.Point;
import fluke.hexlands.util.hex.TestEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ChunkGeneratorOverworldHex
implements IChunkGenerator {
    private final Random rand;
    final World world;
    Biome[] biomesForGeneration;
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected Layout hex_layout;
    private MapGenBase caveGenerator;
    private MapGenStronghold strongholdGenerator;
    private MapGenVillage villageGenerator;
    private MapGenMineshaft mineshaftGenerator;
    private MapGenScatteredFeature scatteredFeatureGenerator;
    private MapGenBase ravineGenerator;
    private StructureOceanMonument oceanMonumentGenerator;
    private IBlockState rimBlock;
    private WoodlandMansion woodlandMansionGenerator;
    public IBlockState rim2;
    public boolean useExtraHexNoise;
    ArrayList<Biome> sunkenBiomes;
    ArrayList<Biome> wetBiomes;
    public double[] heightmap;
    public Biome[] biomemap;
    private int sealevel;

    public ChunkGeneratorOverworldHex(World world) {
        this.hex_layout = new Layout(Layout.flat, new Point(Configs.worldgen.hexSize, Configs.worldgen.hexSize), new Point(0.0, 0.0));
        this.caveGenerator = new MapGenCaves();
        this.strongholdGenerator = new MapGenStronghold();
        this.villageGenerator = new MapGenVillage();
        this.mineshaftGenerator = new MapGenMineshaft();
        this.scatteredFeatureGenerator = new MapGenScatteredFeature();
        this.ravineGenerator = new MapGenRavine();
        this.oceanMonumentGenerator = new StructureOceanMonument();
        this.rim2 = Block.func_149684_b((String)"minecraft:netherrack").func_176223_P();
        this.sunkenBiomes = new ArrayList();
        this.wetBiomes = new ArrayList();
        this.updateRimBlock();
        this.updateSunkenBiomes();
        this.updateWetBiomes();
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)this.oceanMonumentGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.woodlandMansionGenerator = new WoodlandMansion((ChunkGeneratorOverworld)new TotallyLegitOverworldProvider(world));
        this.world = world;
        world.func_181544_b(Configs.worldgen.seaLevel);
        this.sealevel = Configs.worldgen.seaLevel - 1;
        this.rand = new Random(world.func_72905_C());
        this.heightmap = new double[256];
        this.biomemap = new Biome[256];
        this.useExtraHexNoise = Configs.worldgen.extraHexNoise != 0;
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.generateTerrain(x, z, chunkprimer);
        this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
        if (Configs.worldgen.generateCaves) {
            this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        if (Configs.worldgen.generateRavines) {
            this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        if (Configs.worldgen.generateStructures) {
            if (Configs.worldgen.generateMineshaft) {
                this.mineshaftGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
            if (Configs.worldgen.generateVillage) {
                this.villageGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
            if (Configs.worldgen.generateStronghold) {
                this.strongholdGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
            if (Configs.worldgen.generateTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
            if (Configs.worldgen.generateMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
            if (Configs.worldgen.generateMansions) {
                this.woodlandMansionGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, 0.5);
            }
        }
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.generateBiomemap(chunkX * 16, chunkZ * 16);
        this.generateHeightmap(chunkX * 16, chunkZ * 16);
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int y;
                float biomeBaseHeightRaw;
                int realZ = z + chunkZ * 16;
                Hex hexy = this.hex_layout.pixelToHex(new Point(realX, realZ)).hexRound();
                Point center_pt = this.hex_layout.hexToPixel(hexy);
                boolean isEdgeBlock = TestEdge.isEdge(new Point(realX, realZ), center_pt, hexy, Configs.worldgen.hexSize, Configs.worldgen.hexSize, Configs.worldgen.rimSize);
                boolean isHardEdge = false;
                Biome currentBiome = this.biomemap[x + z * 16];
                boolean isWet = false;
                if (Configs.worldgen.wetBiomes != null) {
                    for (Biome b : this.wetBiomes) {
                        if (b != currentBiome) continue;
                        isWet = true;
                        break;
                    }
                }
                if ((double)(biomeBaseHeightRaw = currentBiome.func_185355_j()) > 4.7) {
                    biomeBaseHeightRaw = 4.7f;
                }
                float biomeVariation = currentBiome.func_185360_m();
                biomeVariation = biomeVariation * 0.6f + 0.1f;
                float biomeBaseHeight = (biomeBaseHeightRaw * 16.0f - 1.0f) / 36.0f;
                if ((double)(biomeBaseHeight = biomeBaseHeight / 2.0f + 0.5f) < 0.5) {
                    biomeBaseHeight = 16.0f * biomeBaseHeight * biomeBaseHeight * biomeBaseHeight * biomeBaseHeight * biomeBaseHeight;
                } else {
                    biomeBaseHeight -= 1.0f;
                    biomeBaseHeight = 1.0f + 16.0f * biomeBaseHeight * biomeBaseHeight * biomeBaseHeight * biomeBaseHeight * biomeBaseHeight;
                }
                biomeBaseHeight = biomeBaseHeight * 2.0f - 0.95f;
                biomeBaseHeight = (float)Math.pow(Math.abs(biomeBaseHeight), (1.0f - biomeBaseHeight) * (1.0f - biomeBaseHeight));
                if (biomeBaseHeightRaw < 0.0f) {
                    biomeBaseHeight *= -1.0f;
                }
                if (!isWet && !Configs.worldgen.outlineAll && !Configs.worldgen.outlineAllDry && isEdgeBlock) {
                    double inner_flat;
                    double inner_diagonal;
                    boolean zPositive;
                    int boundry_size;
                    int testX;
                    int testZ;
                    int pretestZ;
                    ArrayList<Integer> directions_to_test = new ArrayList<Integer>();
                    if (realX - center_pt.getX() > 0) {
                        pretestZ = realZ - center_pt.getZ();
                        testZ = realZ - center_pt.getZ();
                        testX = realX - center_pt.getX();
                        boundry_size = Configs.worldgen.rimSize;
                        zPositive = true;
                        if (testZ <= 0) {
                            testZ = Math.abs(testZ);
                            zPositive = false;
                        }
                        inner_diagonal = 1.732050808 * (double)(Configs.worldgen.hexSize - (boundry_size + 1) - testX);
                        inner_flat = 1.732050808 * (double)((Configs.worldgen.hexSize - boundry_size) / 2);
                        if ((double)testZ > inner_diagonal) {
                            if (testZ <= 2 && (double)(pretestZ * -1) > inner_diagonal + (double)testZ) {
                                if (zPositive) {
                                    directions_to_test.add(1);
                                } else {
                                    directions_to_test.add(0);
                                }
                            }
                            if (zPositive) {
                                directions_to_test.add(0);
                            } else {
                                directions_to_test.add(1);
                            }
                            if ((double)testZ > inner_flat) {
                                if (zPositive) {
                                    directions_to_test.add(5);
                                } else {
                                    directions_to_test.add(2);
                                }
                            }
                        } else if (zPositive) {
                            directions_to_test.add(5);
                        } else {
                            directions_to_test.add(2);
                        }
                    } else {
                        testZ = pretestZ = realZ - center_pt.getZ();
                        testX = Math.abs(realX - center_pt.getX());
                        boundry_size = 3;
                        zPositive = true;
                        if (testZ <= 0) {
                            testZ = Math.abs(testZ);
                            zPositive = false;
                        }
                        inner_diagonal = 1.732050808 * (double)(Configs.worldgen.hexSize - (boundry_size + 1) - testX);
                        inner_flat = 1.732050808 * (double)((Configs.worldgen.hexSize - boundry_size) / 2);
                        if ((double)testZ > inner_diagonal) {
                            if (testZ <= 2 && (double)(pretestZ * -1) > inner_diagonal + (double)testZ) {
                                if (zPositive) {
                                    directions_to_test.add(3);
                                } else {
                                    directions_to_test.add(4);
                                }
                            }
                            if (zPositive) {
                                directions_to_test.add(4);
                            } else {
                                directions_to_test.add(3);
                            }
                            if ((double)testZ > inner_flat) {
                                if (zPositive) {
                                    directions_to_test.add(5);
                                } else {
                                    directions_to_test.add(2);
                                }
                            }
                        } else if (zPositive) {
                            directions_to_test.add(5);
                        } else {
                            directions_to_test.add(2);
                        }
                    }
                    for (Integer direction : directions_to_test) {
                        Hex hex_next_door = hexy.neighbor(direction);
                        Point neighbor_origin = this.hex_layout.hexToPixel(hex_next_door);
                        Biome neighbor_biome = this.world.func_72959_q().func_180631_a(new BlockPos(neighbor_origin.getX(), 90, neighbor_origin.getZ()));
                        if (currentBiome == neighbor_biome) continue;
                        isHardEdge = true;
                    }
                }
                int hex_height = (int)((float)Configs.worldgen.terrainBaseline + (float)Configs.worldgen.biomeHeightAdjustment * biomeBaseHeight);
                if (this.useExtraHexNoise) {
                    double hex_noise = SimplexNoise.noise(center_pt.getX() / 60, center_pt.getZ() / 60);
                    hex_height = (int)((double)hex_height + (double)Configs.worldgen.extraHexNoise * hex_noise);
                }
                int block_height = hex_height;
                if (isWet) {
                    block_height = hex_height -= Configs.worldgen.oceanHeight;
                } else if (currentBiome == Biomes.field_150608_ab) {
                    this.heightmap[x + z * 16] = Math.round(this.heightmap[x + z * 16] * 16.0 * 10.0) / 10L;
                }
                if (Configs.worldgen.outlineAll || Configs.worldgen.outlineAllDry && !isWet) {
                    isHardEdge = isEdgeBlock;
                }
                if (!isHardEdge) {
                    int zdif;
                    int xdif = realX - center_pt.getX();
                    double distance_from_origin = Math.sqrt(xdif * xdif + (zdif = realZ - center_pt.getZ()) * zdif);
                    double distance_ratio = distance_from_origin / (double)Configs.worldgen.hexSize;
                    if (distance_ratio > 0.9) {
                        distance_ratio = 0.9;
                    }
                    int block_desired_height = (int)Math.round((double)block_height + (double)Configs.worldgen.terrainHeight * this.heightmap[x + z * 16] * (double)biomeVariation);
                    block_height = (int)Math.round((double)block_desired_height * (1.0 - distance_ratio) + (double)hex_height * distance_ratio);
                } else {
                    block_height += Configs.worldgen.extraRimHeight;
                }
                if (block_height > 255) {
                    block_height = 255;
                } else if (block_height < 1) {
                    block_height = 1;
                }
                for (y = 0; y < block_height; ++y) {
                    if (Configs.worldgen.borderToBedrock && isHardEdge) {
                        primer.func_177855_a(x, y, z, this.rimBlock);
                        continue;
                    }
                    primer.func_177855_a(x, y, z, STONE);
                }
                if (block_height < this.sealevel) {
                    if (Configs.worldgen.borderToBedrock && isHardEdge) {
                        for (y = block_height; y <= this.sealevel; ++y) {
                            primer.func_177855_a(x, y, z, this.rimBlock);
                        }
                    } else {
                        for (y = block_height; y <= this.sealevel; ++y) {
                            primer.func_177855_a(x, y, z, WATER);
                        }
                    }
                    block_height = this.sealevel;
                } else if (Configs.worldgen.borderToBedrock && isHardEdge) {
                    primer.func_177855_a(x, block_height, z, this.rimBlock);
                } else {
                    primer.func_177855_a(x, block_height, z, STONE);
                }
                if (!Configs.worldgen.outlineAll && !isHardEdge && (!Configs.worldgen.outlineAllDry || isWet)) continue;
                int extraRimHeight = 1;
                if (this.sunkenBiomes == null) {
                    extraRimHeight = 0;
                } else {
                    for (Biome b : this.sunkenBiomes) {
                        if (b != currentBiome) continue;
                        extraRimHeight = 0;
                    }
                }
                if (!isEdgeBlock) continue;
                primer.func_177855_a(x, block_height + extraRimHeight, z, this.rimBlock);
            }
        }
    }

    private void generateBiomemap(int startX, int startZ) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.biomemap[x + z * 16] = this.world.func_72959_q().func_180631_a(new BlockPos(startX + x, 0, startZ + z));
            }
        }
    }

    public void generateHeightmap(int startX, int startZ) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double noise = SimplexNoise.noise(startX + x, startZ + z, 190.0, 190.0, 0.5, 2);
                double noiser = SimplexNoise.noise(startX + x, startZ + z, 90.0, 90.0, 0.5, 4);
                double noisyist = SimplexNoise.noise(startX + x, startZ + z, 50.0, 50.0, 0.5, 4);
                noise += noiser * 0.8 + noisyist * 0.25 + 0.1;
                noise *= Math.abs(noise + 0.5) * 0.8;
                this.heightmap[x + z * 16] = noise;
            }
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean villageHere = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)villageHere);
        if (Configs.worldgen.generateStructures) {
            if (Configs.worldgen.generateMineshaft) {
                this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (Configs.worldgen.generateVillage) {
                villageHere = this.villageGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (Configs.worldgen.generateStronghold) {
                this.strongholdGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (Configs.worldgen.generateTemples) {
                this.scatteredFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (Configs.worldgen.generateMonuments) {
                this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (Configs.worldgen.generateMansions) {
                this.woodlandMansionGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
        }
        if (Configs.worldgen.lakesGenerate && biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && !villageHere && this.rand.nextInt(Configs.worldgen.lakeRarity) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)villageHere, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (!villageHere && this.rand.nextInt(8) == 0 && Configs.worldgen.lavaLakesGenerate && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)villageHere, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            if (l2 < this.world.func_181545_F() || this.rand.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)villageHere, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int j2 = 0; j2 < Configs.worldgen.dungeonCount; ++j2) {
                int i3 = this.rand.nextInt(16) + 8;
                int l3 = this.rand.nextInt(256);
                int l1 = this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i3, l3, l1));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)villageHere, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)villageHere, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)villageHere);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (Configs.worldgen.generateStructures && Configs.worldgen.generateMonuments && chunkIn.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        if (Configs.worldgen.generateStructures) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (creatureType == EnumCreatureType.MONSTER && Configs.worldgen.generateMonuments && this.oceanMonumentGenerator.func_175796_a(this.world, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return biome.func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (!Configs.worldgen.generateStructures) {
            return null;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (Configs.worldgen.generateStructures) {
            if (Configs.worldgen.generateMineshaft) {
                this.mineshaftGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (Configs.worldgen.generateVillage) {
                this.villageGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (Configs.worldgen.generateStronghold) {
                this.strongholdGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (Configs.worldgen.generateTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (Configs.worldgen.generateMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (Configs.worldgen.generateMansions) {
                this.woodlandMansionGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
        }
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (!Configs.worldgen.generateStructures) {
            return false;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(pos);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_175795_b(pos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(pos);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(pos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_175795_b(pos) : false;
    }

    public void updateRimBlock() {
        String rimblock = Configs.worldgen.rimBlock;
        if (rimblock.indexOf("@") > 0) {
            String[] metarim = rimblock.split("@");
            this.rimBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(metarim[0]))).func_176203_a(Integer.parseInt(metarim[1]));
        } else {
            this.rimBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(rimblock))).func_176223_P();
        }
    }

    public void updateSunkenBiomes() {
        if (Configs.worldgen.sunkenBiomes.length == 0) {
            this.sunkenBiomes = null;
            return;
        }
        for (String biomeString : Configs.worldgen.sunkenBiomes) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeString));
            if (biome == null) {
                Main.LOGGER.warn("Cannot find biome: " + biomeString);
                continue;
            }
            this.sunkenBiomes.add(biome);
        }
    }

    public void updateWetBiomes() {
        if (Configs.worldgen.wetBiomes.length == 0) {
            this.wetBiomes = null;
            return;
        }
        for (String biomeString : Configs.worldgen.wetBiomes) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeString));
            if (biome == null) {
                Main.LOGGER.warn("Cannot find biome: " + biomeString);
                continue;
            }
            this.wetBiomes.add(biome);
        }
    }

    private class TotallyLegitOverworldProvider
    extends ChunkGeneratorOverworld {
        public TotallyLegitOverworldProvider(World world) {
            super(world, world.func_72905_C(), true, "");
        }

        public void func_185976_a(int x, int z, ChunkPrimer primer) {
            ChunkGeneratorOverworldHex.this.generateTerrain(x, z, primer);
        }
    }
}

