/*
 * Decompiled with CFR 0.152.
 */
package fluke.hexlands.world;

import fluke.hexlands.config.Configs;
import fluke.hexlands.util.hex.Hex;
import fluke.hexlands.util.hex.Layout;
import fluke.hexlands.util.hex.Point;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.storage.WorldInfo;

public class HexBiomeProvider
extends BiomeProvider {
    protected Layout hex_layout;
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private final BiomeCache biomeCache;

    public HexBiomeProvider(long seed, WorldType worldTypeIn) {
        this.hex_layout = new Layout(Layout.flat, new Point(Configs.worldgen.hexSize, Configs.worldgen.hexSize), new Point(0.0, 0.0));
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        GenLayer[] agenlayer = GenLayer.func_180781_a((long)seed, (WorldType)worldTypeIn, null);
        agenlayer = this.getModdedBiomeGenerators(worldTypeIn, seed, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
    }

    public HexBiomeProvider(WorldInfo info) {
        this(info.func_76063_b(), info.func_76067_t());
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        Hex hexy = this.hex_layout.pixelToHex(new Point(pos.func_177958_n(), pos.func_177952_p())).hexRound();
        Point center_pt = this.hex_layout.hexToPixel(hexy);
        return this.biomeCache.func_180284_a(center_pt.getX(), center_pt.getZ(), defaultBiome);
    }

    public Biome[] func_76937_a(Biome[] biomes, int chunkX, int chunkZ, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        try {
            Hex prev_hex = this.hex_layout.pixelToHex(new Point(chunkX - 1000, chunkZ - 1000)).hexRound();
            Biome prev_biome = Biomes.field_180279_ad;
            for (int i = 0; i < width * height; ++i) {
                int realX = i % width + chunkX;
                int realZ = i / height + chunkZ;
                Hex hexy = this.hex_layout.pixelToHex(new Point(realX, realZ)).hexRound();
                if (hexy.q != prev_hex.q || hexy.r != prev_hex.r) {
                    prev_biome = Biome.func_180276_a((int)this.biomeIndexLayer.func_75904_a(hexy.q * Configs.worldgen.biomeSize, hexy.r * Configs.worldgen.biomeSize, 1, 1)[0], (Biome)Biomes.field_180279_ad);
                    prev_hex = hexy;
                }
                biomes[i] = prev_biome;
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)chunkX);
            crashreportcategory.func_71507_a("z", (Object)chunkZ);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int chunkX, int chunkZ, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (chunkX & 0xF) == 0 && (chunkZ & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.func_76839_e(chunkX, chunkZ);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        Hex prev_hex = this.hex_layout.pixelToHex(new Point(chunkX - 1000, chunkZ - 1000)).hexRound();
        Biome prev_biome = Biomes.field_180279_ad;
        for (int i = 0; i < width * length; ++i) {
            int realX = i % width + chunkX;
            int realZ = i / length + chunkZ;
            Hex hexy = this.hex_layout.pixelToHex(new Point(realX, realZ)).hexRound();
            if (hexy.q != prev_hex.q || hexy.r != prev_hex.r) {
                prev_biome = Biome.func_180276_a((int)this.biomeIndexLayer.func_75904_a(hexy.q * Configs.worldgen.biomeSize, hexy.r * Configs.worldgen.biomeSize, 1, 1)[0], (Biome)Biomes.field_180279_ad);
                prev_hex = hexy;
            }
            listToReuse[i] = prev_biome;
        }
        return listToReuse;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int xStart = x - range >> 2;
        int zStart = z - range >> 2;
        int xEnd = x + range >> 2;
        int zEnd = z + range >> 2;
        int xRange = xEnd - xStart + 1;
        int zRange = zEnd - zStart + 1;
        BlockPos blockpos = null;
        int k1 = 0;
        Hex prev_hex = this.hex_layout.pixelToHex(new Point(xStart - 1000, zStart - 1000)).hexRound();
        Biome new_biome = Biomes.field_180279_ad;
        for (int i = 0; i < xRange * zRange; ++i) {
            int xCord = xStart + i % xRange << 2;
            int zCord = zStart + i / xRange << 2;
            Hex hexy = this.hex_layout.pixelToHex(new Point(xCord, zCord)).hexRound();
            if (hexy.q == prev_hex.q && hexy.r == prev_hex.r) continue;
            new_biome = Biome.func_180276_a((int)this.biomeIndexLayer.func_75904_a(hexy.q * Configs.worldgen.biomeSize, hexy.r * Configs.worldgen.biomeSize, 1, 1)[0], (Biome)Biomes.field_180279_ad);
            if (biomes.contains(new_biome) && (blockpos == null || random.nextInt(k1 + 1) == 0)) {
                blockpos = new BlockPos(xCord, 0, zCord);
                ++k1;
            }
            prev_hex = hexy;
        }
        return blockpos;
    }

    public boolean func_76940_a(int x, int z, int range, List<Biome> allowed) {
        int xStart = x - range >> 2;
        int zStart = z - range >> 2;
        int xEnd = x + range >> 2;
        int zEnd = z + range >> 2;
        int xRange = xEnd - xStart + 1;
        int zRange = zEnd - zStart + 1;
        Hex prev_hex = this.hex_layout.pixelToHex(new Point(xStart - 1000, zStart - 1000)).hexRound();
        Biome new_biome = Biomes.field_180279_ad;
        for (int i = 0; i < xRange * zRange; ++i) {
            int xCord = xStart + i % xRange << 2;
            int zCord = zStart + i / xRange << 2;
            Hex hexy = this.hex_layout.pixelToHex(new Point(xCord, zCord)).hexRound();
            if (hexy.q == prev_hex.q && hexy.r == prev_hex.r) continue;
            new_biome = Biome.func_180276_a((int)this.biomeIndexLayer.func_75904_a(hexy.q * Configs.worldgen.biomeSize, hexy.r * Configs.worldgen.biomeSize, 1, 1)[0], (Biome)Biomes.field_180279_ad);
            if (!allowed.contains(new_biome)) {
                return false;
            }
            prev_hex = hexy;
        }
        return true;
    }

    public boolean func_190944_c() {
        return false;
    }

    public Biome func_190943_d() {
        return null;
    }
}

