/*
 * Decompiled with CFR 0.152.
 */
package fluke.hexlands.world;

import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.BiomeProviderBOPHell;
import fluke.hexlands.config.Configs;
import fluke.hexlands.util.hex.Hex;
import fluke.hexlands.util.hex.Layout;
import fluke.hexlands.util.hex.Point;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class HexHellBoPBiomeProvider
extends BiomeProvider {
    protected Layout hex_layout;
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private final BiomeCache biomeCache;

    public HexHellBoPBiomeProvider(long seed, WorldType worldType) {
        this.hex_layout = new Layout(Layout.flat, new Point(Configs.worldgen.hexSize, Configs.worldgen.hexSize), new Point(0.0, 0.0));
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        GenLayer[] genlayers = BiomeProviderBOPHell.setupBOPGenLayers((long)seed, (BOPWorldSettings)new BOPWorldSettings(""));
        this.genBiomes = genlayers[0];
        this.biomeIndexLayer = genlayers[1];
    }

    public HexHellBoPBiomeProvider(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public Biome[] func_76937_a(Biome[] biomes, int chunkX, int chunkZ, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        try {
            Hex prev_hex = this.hex_layout.pixelToHex(new Point(chunkX - 1000, chunkZ - 1000)).hexRound();
            Biome prev_biome = Biomes.field_180279_ad;
            for (int i = 0; i < width * height; ++i) {
                int realX = i % width + chunkX;
                int realZ = i / height + chunkZ;
                Hex hexy = this.hex_layout.pixelToHex(new Point(realX, realZ)).hexRound();
                if (hexy.q != prev_hex.q || hexy.r != prev_hex.r) {
                    prev_biome = Biome.func_180276_a((int)this.biomeIndexLayer.func_75904_a(hexy.q * (Configs.worldgen.biomeSize / 4), hexy.r * (Configs.worldgen.biomeSize / 4), 1, 1)[0], (Biome)Biomes.field_76778_j);
                    prev_hex = hexy;
                }
                biomes[i] = prev_biome;
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)chunkX);
            crashreportcategory.func_71507_a("z", (Object)chunkZ);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int chunkX, int chunkZ, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (chunkX & 0xF) == 0 && (chunkZ & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.func_76839_e(chunkX, chunkZ);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        Hex prev_hex = this.hex_layout.pixelToHex(new Point(chunkX - 1000, chunkZ - 1000)).hexRound();
        Biome prev_biome = Biomes.field_180279_ad;
        for (int i = 0; i < width * length; ++i) {
            int realX = i % width + chunkX;
            int realZ = i / length + chunkZ;
            Hex hexy = this.hex_layout.pixelToHex(new Point(realX, realZ)).hexRound();
            if (hexy.q != prev_hex.q || hexy.r != prev_hex.r) {
                prev_biome = Biome.func_180276_a((int)this.biomeIndexLayer.func_75904_a(hexy.q * Configs.worldgen.biomeSize, hexy.r * Configs.worldgen.biomeSize, 1, 1)[0], (Biome)Biomes.field_76778_j);
                prev_hex = hexy;
            }
            listToReuse[i] = prev_biome;
        }
        return listToReuse;
    }
}

