/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells;

import com.divinity.hlspells.compat.CuriosCompat;
import com.divinity.hlspells.init.ConfigData;
import com.divinity.hlspells.items.capabilities.spellholdercap.ISpellHolder;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolder;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolderStorage;
import com.divinity.hlspells.items.capabilities.totemcap.ITotemCap;
import com.divinity.hlspells.items.capabilities.totemcap.TotemCap;
import com.divinity.hlspells.items.capabilities.totemcap.TotemItemStorage;
import com.divinity.hlspells.player.capability.IPlayerCap;
import com.divinity.hlspells.player.capability.PlayerCap;
import com.divinity.hlspells.player.capability.PlayerCapStorage;
import com.divinity.hlspells.setup.RegistryHandler;
import com.divinity.hlspells.setup.client.ClientSetup;
import com.divinity.hlspells.villages.POIFixUp;
import com.divinity.hlspells.villages.StructureGen;
import com.divinity.hlspells.villages.Villagers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hlspells")
public class HLSpells {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "hlspells";
    public static final ConfigData CONFIG;
    public static boolean isCurioLoaded;
    private static final ForgeConfigSpec CONFIG_SPEC;

    public HLSpells() {
        RegistryHandler.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendImc);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::init));
        this.registerAllDeferredRegistryObjects(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::setupMageHouses);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CONFIG_SPEC);
        isCurioLoaded = ModList.get().isLoaded("curios");
    }

    private void registerAllDeferredRegistryObjects(IEventBus modBus) {
        Villagers.POI.register(modBus);
        Villagers.PROFESSIONS.register(modBus);
    }

    public void setupMageHouses(FMLServerAboutToStartEvent event) {
        StructureGen.setupVillageWorldGen(event.getServer().func_244267_aX());
    }

    public void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ISpellHolder.class, (Capability.IStorage)new SpellHolderStorage(), SpellHolder::new);
        CapabilityManager.INSTANCE.register(ITotemCap.class, (Capability.IStorage)new TotemItemStorage(), TotemCap::new);
        CapabilityManager.INSTANCE.register(IPlayerCap.class, (Capability.IStorage)new PlayerCapStorage(), PlayerCap::new);
        POIFixUp.registerPOI();
    }

    public void sendImc(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.sendImc();
        }
    }

    static {
        isCurioLoaded = false;
        Pair specPair = new ForgeConfigSpec.Builder().configure(ConfigData::new);
        CONFIG = (ConfigData)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

