/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.compat;

import com.divinity.hlspells.items.ModTotemItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosCompat {
    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getItemInCuriosSlot(LivingEntity entity, Item item) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(item, entity);
    }

    public static Optional<ICurioStacksHandler> getStackHandler(LivingEntity entity) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).map(iCuriosItemHandler -> iCuriosItemHandler.getStacksHandler("charm")).orElse(Optional.empty());
    }

    public static LazyOptional<IItemHandlerModifiable> getCuriosHandler(LivingEntity livingEntity) {
        return CuriosApi.getCuriosHelper().getEquippedCurios(livingEntity);
    }

    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("charm").build());
    }

    public static ListNBT getCuriosInv(PlayerEntity player) {
        ListNBT list = new ListNBT();
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(curioHandler -> curioHandler.getCurios().forEach((id, stackHandler) -> {
            ListNBT list1 = new ListNBT();
            ListNBT list2 = new ListNBT();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                CompoundNBT stack = new CompoundNBT();
                stackHandler.getStacks().getStackInSlot(i).func_77955_b(stack);
                stack.func_74768_a("Slot", i);
                list1.add((Object)stack);
                CompoundNBT cosmeticStack = new CompoundNBT();
                stackHandler.getCosmeticStacks().getStackInSlot(i).func_77955_b(cosmeticStack);
                cosmeticStack.func_74768_a("Slot", i);
                list2.add((Object)cosmeticStack);
            }
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("Identifier", id);
            tag.func_218657_a("Stacks", (INBT)list1);
            tag.func_218657_a("CosmeticStacks", (INBT)list2);
            list.add((Object)tag);
        }));
        return list;
    }

    public static void restoreCuriosInv(PlayerEntity player, ListNBT curiosNBT) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            for (int i = 0; i < curiosNBT.size(); ++i) {
                CompoundNBT tag = curiosNBT.func_150305_b(i);
                String id = tag.func_74779_i("Identifier");
                handler.getStacksHandler(id).ifPresent(stacksHandler -> {
                    ListNBT stacks = tag.func_150295_c("Stacks", 10);
                    for (int j = 0; j < stacks.size(); ++j) {
                        CompoundNBT compoundnbt = stacks.func_150305_b(j);
                        int slot = compoundnbt.func_74762_e("Slot");
                        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compoundnbt);
                        if (itemstack.func_190926_b()) continue;
                        stacksHandler.getStacks().setStackInSlot(slot, itemstack);
                        CuriosApi.getCuriosHelper().getCurio(itemstack).ifPresent(curio -> player.func_233645_dx_().func_233793_b_(curio.getAttributeModifiers(id)));
                    }
                    ListNBT cosmeticStacks = tag.func_150295_c("CosmeticStacks", 10);
                    for (int j = 0; j < cosmeticStacks.size(); ++j) {
                        CompoundNBT compoundnbt = cosmeticStacks.func_150305_b(j);
                        int slot = compoundnbt.func_74762_e("Slot");
                        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compoundnbt);
                        if (itemstack.func_190926_b()) continue;
                        stacksHandler.getCosmeticStacks().setStackInSlot(slot, itemstack);
                    }
                });
            }
        });
    }

    public static void attachCapabilities(final AttachCapabilitiesEvent<ItemStack> evt) {
        if (((ItemStack)evt.getObject()).func_77973_b() instanceof ModTotemItem) {
            final ICurio curio = new ICurio(){

                public boolean canEquipFromUse(SlotContext ctx) {
                    return true;
                }

                public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
                    return true;
                }

                public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                    ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                    ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                    matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
                    matrixStack.func_227861_a_(0.0, 0.5, (double)-0.4f);
                    matrixStack.func_227863_a_(Direction.DOWN.func_229384_a_());
                    Minecraft.func_71410_x().func_175599_af().func_229110_a_((ItemStack)evt.getObject(), ItemCameraTransforms.TransformType.NONE, light, OverlayTexture.field_229196_a_, matrixStack, renderTypeBuffer);
                }
            };
            ICapabilityProvider provider = new ICapabilityProvider(){
                private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
                }
            };
            evt.addCapability(CuriosCapability.ID_ITEM, provider);
        }
    }
}

