/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.events.entity;

import com.divinity.hlspells.HLSpells;
import com.divinity.hlspells.compat.CuriosCompat;
import com.divinity.hlspells.init.EnchantmentInit;
import com.divinity.hlspells.init.ItemInit;
import com.divinity.hlspells.items.ModTotemItem;
import com.divinity.hlspells.items.capabilities.totemcap.ITotemCap;
import com.divinity.hlspells.items.capabilities.totemcap.TotemItemProvider;
import com.divinity.hlspells.player.capability.PlayerCapProvider;
import com.divinity.hlspells.setup.client.ClientSetup;
import com.divinity.hlspells.util.Util;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hlspells")
public class EntityDiesEvent {
    @SubscribeEvent
    public static void onEntityDies(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            ItemStack heldItem;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            World world = player.field_70170_p;
            boolean griefingTotem = true;
            boolean escapingTotem = true;
            boolean returnTotem = true;
            boolean keepingTotem = true;
            boolean soulBond = player.field_71071_by.field_184440_g.stream().flatMap(Collection::stream).anyMatch(p -> EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.SOUL_BOND.get()), (ItemStack)p) > 0);
            if (HLSpells.isCurioLoaded) {
                if (CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_ESCAPING.get()).isPresent()) {
                    event.setCanceled(true);
                    CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_ESCAPING.get()).ifPresent(map -> {
                        ItemStack stack = (ItemStack)map.getRight();
                        ModTotemItem.vanillaTotemBehavior(player, stack, (Item)ItemInit.TOTEM_OF_ESCAPING.get());
                    });
                    event.setCanceled(true);
                    player.func_195064_c(new EffectInstance(Effects.field_76441_p, 200, 0));
                    EntityDiesEvent.randomTeleport((LivingEntity)player);
                    escapingTotem = false;
                    keepingTotem = false;
                    returnTotem = false;
                    griefingTotem = false;
                }
                if (CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_KEEPING.get()).isPresent()) {
                    CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_KEEPING.get()).ifPresent(map -> {
                        ItemStack stack = (ItemStack)map.getRight();
                        stack.getCapability(TotemItemProvider.TOTEM_CAP).ifPresent(cap -> {
                            cap.hasDied(true);
                            cap.setTotemInHand(Hand.MAIN_HAND);
                            cap.setCuriosSlot((Integer)map.getMiddle());
                            cap.setDiedTotemInCurios(true);
                        });
                    });
                    escapingTotem = false;
                    keepingTotem = false;
                    soulBond = false;
                }
                if (CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_GRIEFING.get()).isPresent() && griefingTotem) {
                    CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_GRIEFING.get()).ifPresent(triple -> {
                        world.func_217385_a((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 5.0f, Explosion.Mode.BREAK);
                        ((ItemStack)triple.getRight()).func_190918_g(1);
                    });
                    escapingTotem = false;
                    griefingTotem = false;
                }
                if (CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_RETURNING.get()).isPresent() && returnTotem) {
                    CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_RETURNING.get()).ifPresent(map -> {
                        ItemStack stack = (ItemStack)map.getRight();
                        stack.getCapability(TotemItemProvider.TOTEM_CAP).ifPresent(cap -> {
                            cap.hasDied(true);
                            cap.setTotemInHand(Hand.MAIN_HAND);
                            cap.setCuriosSlot((Integer)map.getMiddle());
                            cap.setDiedTotemInCurios(true);
                            cap.setBlockPos(player.func_233580_cy_());
                        });
                    });
                    escapingTotem = false;
                    returnTotem = false;
                }
            }
            for (Hand hand : Hand.values()) {
                heldItem = player.func_184586_b(hand);
                if (heldItem.func_77973_b() != Items.field_190929_cY) continue;
                escapingTotem = false;
                keepingTotem = false;
                griefingTotem = false;
                returnTotem = false;
            }
            for (Hand hand : Hand.values()) {
                heldItem = player.func_184586_b(hand);
                if (heldItem.func_77973_b() != ItemInit.TOTEM_OF_ESCAPING.get() || !escapingTotem) continue;
                event.setCanceled(true);
                ModTotemItem.vanillaTotemBehavior(player, heldItem, (Item)ItemInit.TOTEM_OF_ESCAPING.get());
                player.func_195064_c(new EffectInstance(Effects.field_76441_p, 200, 0));
                EntityDiesEvent.randomTeleport((LivingEntity)player);
                escapingTotem = false;
                keepingTotem = false;
                returnTotem = false;
                griefingTotem = false;
            }
            for (Hand hand : Hand.values()) {
                heldItem = player.func_184586_b(hand);
                if (heldItem.func_77973_b() != ItemInit.TOTEM_OF_GRIEFING.get() || !griefingTotem) continue;
                world.func_217385_a((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 5.0f, Explosion.Mode.BREAK);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                griefingTotem = false;
            }
            for (Hand hand : Hand.values()) {
                heldItem = player.func_184586_b(hand);
                if (heldItem.func_77973_b() != ItemInit.TOTEM_OF_RETURNING.get() || !returnTotem) continue;
                heldItem.getCapability(TotemItemProvider.TOTEM_CAP).ifPresent(cap -> {
                    cap.hasDied(true);
                    cap.setBlockPos(player.func_233580_cy_());
                    if (hand == Hand.MAIN_HAND) {
                        cap.setTotemInHand(Hand.MAIN_HAND);
                    } else if (hand == Hand.OFF_HAND) {
                        cap.setTotemInHand(Hand.OFF_HAND);
                    }
                });
                returnTotem = false;
            }
            for (Hand hand : Hand.values()) {
                heldItem = player.func_184586_b(hand);
                if (heldItem.func_77973_b() != ItemInit.TOTEM_OF_KEEPING.get() || !keepingTotem) continue;
                heldItem.getCapability(TotemItemProvider.TOTEM_CAP).ifPresent(cap -> {
                    cap.hasDied(true);
                    if (hand == Hand.MAIN_HAND) {
                        cap.setTotemInHand(Hand.MAIN_HAND);
                    } else if (hand == Hand.OFF_HAND) {
                        cap.setTotemInHand(Hand.OFF_HAND);
                    }
                    cap.setInventoryNBT(player.field_71071_by.func_70442_a(new ListNBT()));
                    if (HLSpells.isCurioLoaded) {
                        cap.setCuriosNBT(CuriosCompat.getCuriosInv(player));
                    }
                });
                keepingTotem = false;
                soulBond = false;
            }
            if (HLSpells.isCurioLoaded && CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_KEEPING.get()).isPresent()) {
                soulBond = false;
                CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_KEEPING.get()).ifPresent(map -> {
                    ItemStack stack = (ItemStack)map.getRight();
                    stack.getCapability(TotemItemProvider.TOTEM_CAP).ifPresent(cap -> {
                        cap.setInventoryNBT(player.field_71071_by.func_70442_a(new ListNBT()));
                        cap.setCuriosNBT(CuriosCompat.getCuriosInv(player));
                    });
                });
            }
            if (soulBond) {
                player.getCapability(PlayerCapProvider.PLAYER_CAP).ifPresent(cap -> {
                    int size = player.field_71071_by.field_184440_g.stream().mapToInt(NonNullList::size).sum();
                    for (int i = 0; i < size; ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.SOUL_BOND.get()), (ItemStack)stack) <= 0) continue;
                        cap.addSoulBondItem(i, stack);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            ItemStack stack;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            boolean[] keepingTotem = new boolean[1];
            Iterator itemEntityIterator = event.getDrops().iterator();
            while (itemEntityIterator.hasNext()) {
                stack = ((ItemEntity)itemEntityIterator.next()).func_92059_d();
                if (stack.func_77973_b() == ItemInit.TOTEM_OF_KEEPING.get() && !keepingTotem[0]) {
                    stack.getCapability(TotemItemProvider.TOTEM_CAP).filter(ITotemCap::getHasDied).ifPresent(cap -> {
                        Hand hand = cap.getTotemInHand();
                        if (hand == Hand.MAIN_HAND || hand == Hand.OFF_HAND) {
                            player.field_71071_by.func_70443_b(cap.getInventoryNBT());
                            if (HLSpells.isCurioLoaded) {
                                CuriosCompat.restoreCuriosInv(player, cap.getCuriosNBT());
                                CuriosCompat.getItemInCuriosSlot((LivingEntity)player, (Item)ItemInit.TOTEM_OF_KEEPING.get()).ifPresent(triple -> ((ItemStack)triple.getRight()).getCapability(TotemItemProvider.TOTEM_CAP).ifPresent(totemCap -> {
                                    totemCap.setDiedTotemInCurios(true);
                                    totemCap.setCuriosSlot(cap.getCuriosSlot());
                                }));
                            }
                            cap.setTotemInHand(null);
                            keepingTotem[0] = true;
                            itemEntityIterator.remove();
                        }
                    });
                }
                if (stack.func_77973_b() != ItemInit.TOTEM_OF_RETURNING.get()) continue;
                stack.getCapability(TotemItemProvider.TOTEM_CAP).filter(ITotemCap::getHasDied).ifPresent(cap -> {
                    Hand hand = cap.getTotemInHand();
                    boolean returnInCurio = false;
                    if (HLSpells.isCurioLoaded && cap.diedTotemInCurios()) {
                        CuriosCompat.getStackHandler((LivingEntity)player).ifPresent(stackHandler -> stackHandler.getStacks().setStackInSlot(cap.getCuriosSlot(), stack));
                        itemEntityIterator.remove();
                        cap.setTotemInHand(null);
                        returnInCurio = true;
                    }
                    if (!returnInCurio) {
                        if (hand == Hand.MAIN_HAND) {
                            player.field_71071_by.func_191971_c(player.field_71071_by.field_70461_c, stack);
                            itemEntityIterator.remove();
                            cap.setTotemInHand(null);
                        } else if (hand == Hand.OFF_HAND) {
                            player.field_71071_by.field_184439_c.set(0, (Object)stack);
                            itemEntityIterator.remove();
                            cap.setTotemInHand(null);
                        }
                    }
                });
            }
            itemEntityIterator = event.getDrops().iterator();
            while (itemEntityIterator.hasNext()) {
                stack = ((ItemEntity)itemEntityIterator.next()).func_92059_d();
                if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.SOUL_BOND.get()), (ItemStack)stack) <= 0 || keepingTotem[0]) continue;
                itemEntityIterator.remove();
            }
            if (!keepingTotem[0]) {
                player.getCapability(PlayerCapProvider.PLAYER_CAP).ifPresent(cap -> cap.getSoulBondItems().forEach((pIndex, pStack) -> {
                    if (player.field_71071_by.func_70301_a(pIndex.intValue()).func_190926_b()) {
                        player.field_71071_by.func_70299_a(pIndex.intValue(), pStack);
                    } else {
                        player.field_71071_by.func_70441_a(pStack);
                    }
                }));
            }
            if (keepingTotem[0]) {
                event.getDrops().removeIf(itemEntity -> {
                    if (player.field_71071_by.func_70431_c(itemEntity.func_92059_d())) {
                        return true;
                    }
                    return HLSpells.isCurioLoaded && CuriosCompat.getItemInCuriosSlot((LivingEntity)player, itemEntity.func_92059_d().func_77973_b()).isPresent();
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && !event.getEntity().field_70170_p.func_201670_d()) {
            PlayerEntity original = event.getOriginal();
            PlayerEntity current = event.getPlayer();
            boolean keepingActivated = false;
            if (HLSpells.isCurioLoaded && CuriosCompat.getItemInCuriosSlot((LivingEntity)original, (Item)ItemInit.TOTEM_OF_KEEPING.get()).isPresent()) {
                CuriosCompat.getItemInCuriosSlot((LivingEntity)original, (Item)ItemInit.TOTEM_OF_KEEPING.get()).ifPresent(triple -> ((ItemStack)triple.getRight()).getCapability(TotemItemProvider.TOTEM_CAP).ifPresent(cap -> {
                    if (cap.diedTotemInCurios()) {
                        ((ItemStack)triple.getRight()).func_190918_g(1);
                    }
                }));
                CuriosCompat.restoreCuriosInv(current, CuriosCompat.getCuriosInv(original));
                keepingActivated = true;
            } else if (original.func_184614_ca().func_77973_b() == ItemInit.TOTEM_OF_KEEPING.get()) {
                int mainSlot = original.field_71071_by.func_184429_b(original.func_184614_ca());
                original.field_71071_by.func_70301_a(mainSlot != -1 ? mainSlot : 0).func_190918_g(mainSlot != -1 ? 1 : 0);
                keepingActivated = true;
            } else if (original.func_184592_cb().func_77973_b() == ItemInit.TOTEM_OF_KEEPING.get()) {
                ((ItemStack)original.field_71071_by.field_184439_c.get(0)).func_190918_g(1);
                keepingActivated = true;
            }
            if (keepingActivated) {
                current.field_71071_by.func_70455_b(original.field_71071_by);
                EntityDiesEvent.displayActivation(current, (Item)ItemInit.TOTEM_OF_KEEPING.get(), true);
            }
            if (HLSpells.isCurioLoaded && CuriosCompat.getItemInCuriosSlot((LivingEntity)original, (Item)ItemInit.TOTEM_OF_RETURNING.get()).isPresent()) {
                CuriosCompat.restoreCuriosInv(current, CuriosCompat.getCuriosInv(original));
            } else if (original.func_184614_ca().func_77973_b() == ItemInit.TOTEM_OF_RETURNING.get()) {
                current.field_71071_by.func_70299_a(original.field_71071_by.field_70461_c, original.field_71071_by.func_70448_g());
            } else if (original.func_184592_cb().func_77973_b() == ItemInit.TOTEM_OF_RETURNING.get()) {
                current.field_71071_by.field_184439_c.set(0, original.field_71071_by.field_184439_c.get(0));
            }
            if (!keepingActivated) {
                original.getCapability(PlayerCapProvider.PLAYER_CAP).ifPresent(cap -> {
                    if (!cap.getSoulBondItems().isEmpty()) {
                        cap.getSoulBondItems().forEach((pIndex, pStack) -> {
                            if (current.field_71071_by.func_70301_a(pIndex.intValue()).func_190926_b()) {
                                current.field_71071_by.func_70299_a(pIndex.intValue(), pStack);
                            } else {
                                current.field_71071_by.func_70441_a(pStack);
                            }
                        });
                        cap.getSoulBondItems().clear();
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        if (event.getPlayer() != null) {
            PlayerEntity player = event.getPlayer();
            World world = player.field_70170_p;
            if (!world.func_201670_d()) {
                for (Hand hand : Hand.values()) {
                    ItemStack stack = player.func_184586_b(hand);
                    if (stack.func_77973_b() != ItemInit.TOTEM_OF_RETURNING.get()) continue;
                    stack.getCapability(TotemItemProvider.TOTEM_CAP).filter(ITotemCap::getHasDied).ifPresent(cap -> {
                        BlockPos pos = cap.getBlockPos();
                        EntityDiesEvent.displayActivation(player, (Item)ItemInit.TOTEM_OF_RETURNING.get(), true);
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 0.3f, 0.3f);
                        player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                        Util.teleportParticles(world, pos, 200);
                        world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.7f, 0.7f);
                    });
                    return;
                }
            }
        }
    }

    public static void displayActivation(PlayerEntity player, Item item, boolean particleIn) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSetup.displayActivation(player, new ItemStack((IItemProvider)item), particleIn));
    }

    private static void randomTeleport(LivingEntity entity) {
        double d0 = entity.func_226277_ct_();
        double d1 = entity.func_226278_cu_();
        double d2 = entity.func_226281_cx_();
        for (int i = 0; i < 16; ++i) {
            double d3 = entity.func_226277_ct_() + (entity.func_70681_au().nextDouble() - 0.5) * 16.0;
            double d4 = MathHelper.func_151237_a((double)(entity.func_226278_cu_() + (double)(entity.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(entity.field_70170_p.func_234938_ad_() - 1));
            double d5 = entity.func_226281_cx_() + (entity.func_70681_au().nextDouble() - 0.5) * 16.0;
            if (entity.func_184218_aH()) {
                entity.func_184210_p();
            }
            if (!entity.func_213373_a(d3, d4, d5, true)) continue;
            SoundEvent soundevent = SoundEvents.field_187544_ad;
            entity.field_70170_p.func_184148_a(null, d0, d1, d2, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
            entity.func_184185_a(soundevent, 1.0f, 1.0f);
            break;
        }
    }
}

