/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.goal;

import com.divinity.hlspells.init.SpellInit;
import com.divinity.hlspells.items.SpellHoldingItem;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolderProvider;
import com.divinity.hlspells.spell.Spell;
import com.divinity.hlspells.util.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ResourceLocation;

public class SpellBookLureGoal
extends Goal {
    public static final double LURE_RANGE = 20.0;
    private static final EntityPredicate TEMP_TARGETING = new EntityPredicate().func_221013_a(20.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    private final MobEntity entity;
    private final double speedModifier;
    private PlayerEntity player;
    private double pRotX;
    private double pRotY;
    private double px;
    private double py;
    private double pz;
    private boolean isRunning;

    public SpellBookLureGoal(MobEntity entity, double speedModifier) {
        this.entity = entity;
        this.speedModifier = speedModifier;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.entity.func_70661_as() instanceof GroundPathNavigator || this.entity.func_70661_as() instanceof FlyingPathNavigator) {
            this.player = this.entity.field_70170_p.func_217370_a(TEMP_TARGETING, (LivingEntity)this.entity);
            return this.player != null && this.player.func_184587_cr() && this.canFollowItem(this.player, this.player.func_184586_b(this.player.func_184600_cs())) && this.entity.func_70032_d((Entity)this.player) >= 1.0f;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.player != null && (double)this.entity.func_70032_d((Entity)this.player) <= 20.0) {
            if (this.player.func_70092_e(this.px, this.py, this.pz) > 0.010000000000000002) {
                return false;
            }
            if (Math.abs((double)this.player.field_70125_A - this.pRotX) > 5.0 || Math.abs((double)this.player.field_70177_z - this.pRotY) > 5.0) {
                return false;
            }
        } else if (this.player != null) {
            this.px = this.player.func_226277_ct_();
            this.py = this.player.func_226278_cu_();
            this.pz = this.player.func_226281_cx_();
            this.pRotX = this.player.field_70125_A;
            this.pRotY = this.player.field_70177_z;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.px = this.player.func_226277_ct_();
        this.py = this.player.func_226278_cu_();
        this.pz = this.player.func_226281_cx_();
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.player = null;
        this.entity.func_70661_as().func_75499_g();
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.entity.func_70671_ap().func_75651_a((Entity)this.player, (float)(this.entity.func_184649_cE() + 20), (float)this.entity.func_70646_bf());
        if (this.entity.func_70032_d((Entity)this.player) < 1.0f) {
            this.entity.func_70661_as().func_75499_g();
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)this.player, this.speedModifier);
        }
    }

    private boolean canFollowItem(PlayerEntity player, ItemStack stack) {
        boolean[] canDo = new boolean[2];
        if (stack.func_77973_b() instanceof SpellHoldingItem) {
            stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP, null).ifPresent(cap -> {
                ResourceLocation location = ((Spell)SpellInit.LURE.get()).getRegistryName();
                canDo[0] = location != null && cap.getCurrentSpell().equals(location.toString());
                canDo[1] = SpellUtils.checkXpReq(player, (Spell)SpellInit.LURE.get());
            });
            return canDo[0] && canDo[1];
        }
        return false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

