/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.goal;

import com.divinity.hlspells.init.SpellInit;
import com.divinity.hlspells.items.SpellHoldingItem;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolderProvider;
import com.divinity.hlspells.spell.Spell;
import com.divinity.hlspells.util.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class SpellBookRepelGoal
extends Goal {
    private static final EntityPredicate TEMP_TARGETING = new EntityPredicate().func_221013_a(15.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    protected final PathNavigator pathNav;
    private final MobEntity entity;
    private final double speedModifier;
    protected Path path;
    private PlayerEntity toAvoid;

    public SpellBookRepelGoal(MobEntity entity, double speedModifier) {
        this.entity = entity;
        this.speedModifier = speedModifier;
        this.pathNav = entity.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    private static Vector3d getPosAvoid(MobEntity entity, int horizontalRange, int verticalRange, Vector3d direction) {
        Vector3d vector3d = entity.func_213303_ch().func_178788_d(direction);
        return SpellBookRepelGoal.generateRandomPos(entity, horizontalRange, verticalRange, 0, vector3d, true, 1.5707963705062866, value -> 0.0, false, 0, 0, true);
    }

    @Nullable
    private static BlockPos getRandomDelta(Random random, int horizontalRange, int verticalRange, int startHeight, @Nullable Vector3d direction, double angleRange) {
        if (direction != null && angleRange < Math.PI) {
            double d3 = MathHelper.func_181159_b((double)direction.field_72449_c, (double)direction.field_72450_a) - 1.5707963705062866;
            double d4 = d3 + (double)(2.0f * random.nextFloat() - 1.0f) * angleRange;
            double d0 = Math.sqrt(random.nextDouble()) * (double)MathHelper.field_180189_a * (double)horizontalRange;
            double d1 = -d0 * Math.sin(d4);
            double d2 = d0 * Math.cos(d4);
            if (Math.abs(d1) <= (double)horizontalRange && Math.abs(d2) <= (double)horizontalRange) {
                int l = random.nextInt(2 * verticalRange + 1) - verticalRange + startHeight;
                return new BlockPos(d1, (double)l, d2);
            }
            return null;
        }
        int i = random.nextInt(2 * horizontalRange + 1) - horizontalRange;
        int j = random.nextInt(2 * verticalRange + 1) - verticalRange + startHeight;
        int k = random.nextInt(2 * horizontalRange + 1) - horizontalRange;
        return new BlockPos(i, j, k);
    }

    private static BlockPos moveUpToAboveSolid(BlockPos pos, int extraAbove, int max, Predicate<BlockPos> condition) {
        BlockPos blockpos2;
        if (extraAbove < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + extraAbove + ", expected >= 0");
        }
        if (!condition.test(pos)) {
            return pos;
        }
        BlockPos blockpos = pos.func_177984_a();
        while (blockpos.func_177956_o() < max && condition.test(blockpos)) {
            blockpos = blockpos.func_177984_a();
        }
        BlockPos blockpos1 = blockpos;
        while (blockpos1.func_177956_o() < max && blockpos1.func_177956_o() - blockpos.func_177956_o() < extraAbove && !condition.test(blockpos2 = blockpos1.func_177984_a())) {
            blockpos1 = blockpos2;
        }
        return blockpos1;
    }

    @Nullable
    private static Vector3d generateRandomPos(MobEntity entity, int horizontalRange, int maxVerticalDistance, int preferredYDifference, @Nullable Vector3d preferredAngle, boolean notInWater, double angleRange, ToDoubleFunction<BlockPos> scorer, boolean aboveGround, int distanceAboveGroundRange, int minDistanceAboveGround, boolean validPositionsOnly) {
        PathNavigator pathnavigator = entity.func_70661_as();
        Random random = entity.func_70681_au();
        boolean flag = entity.func_213394_dL() ? entity.func_213384_dI().func_218137_a((IPosition)entity.func_213303_ch(), (double)(entity.func_213391_dJ() + (float)horizontalRange) + 1.0) : false;
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos blockpos = entity.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            double d1;
            PathNodeType pathnodetype;
            BlockPos blockpos3;
            BlockPos blockpos1 = SpellBookRepelGoal.getRandomDelta(random, horizontalRange, maxVerticalDistance, preferredYDifference, preferredAngle, angleRange);
            if (blockpos1 == null) continue;
            int j = blockpos1.func_177958_n();
            int k = blockpos1.func_177956_o();
            int l = blockpos1.func_177952_p();
            if (entity.func_213394_dL() && horizontalRange > 1) {
                BlockPos blockpos2 = entity.func_213384_dI();
                j = entity.func_226277_ct_() > (double)blockpos2.func_177958_n() ? (j -= random.nextInt(horizontalRange / 2)) : (j += random.nextInt(horizontalRange / 2));
                l = entity.func_226281_cx_() > (double)blockpos2.func_177952_p() ? (l -= random.nextInt(horizontalRange / 2)) : (l += random.nextInt(horizontalRange / 2));
            }
            if ((blockpos3 = new BlockPos((double)j + entity.func_226277_ct_(), (double)k + entity.func_226278_cu_(), (double)l + entity.func_226281_cx_())).func_177956_o() < 0 || blockpos3.func_177956_o() > entity.field_70170_p.func_217301_I() || flag && !entity.func_213389_a(blockpos3) || validPositionsOnly && !pathnavigator.func_188555_b(blockpos3)) continue;
            if (aboveGround) {
                blockpos3 = SpellBookRepelGoal.moveUpToAboveSolid(blockpos3, random.nextInt(distanceAboveGroundRange + 1) + minDistanceAboveGround, entity.field_70170_p.func_217301_I(), blockPosx -> entity.field_70170_p.func_180495_p(blockPosx).func_185904_a().func_76220_a());
            }
            if (!notInWater && entity.field_70170_p.func_204610_c(blockpos3).func_206884_a((ITag)FluidTags.field_206959_a) || entity.func_184643_a(pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)entity.field_70170_p, (BlockPos.Mutable)blockpos3.func_239590_i_())) != 0.0f || !((d1 = scorer.applyAsDouble(blockpos3)) > d0)) continue;
            d0 = d1;
            blockpos = blockpos3;
            flag1 = true;
        }
        return flag1 ? Vector3d.func_237492_c_((Vector3i)blockpos) : null;
    }

    public boolean func_75250_a() {
        if (this.entity.func_70661_as() instanceof GroundPathNavigator || this.entity.func_70661_as() instanceof FlyingPathNavigator) {
            this.toAvoid = this.entity.field_70170_p.func_217370_a(TEMP_TARGETING, (LivingEntity)this.entity);
            if (this.toAvoid == null) {
                return false;
            }
            if (this.toAvoid.func_184587_cr() && this.canRepelItem(this.toAvoid, this.toAvoid.func_184586_b(this.toAvoid.func_184600_cs())) && this.entity.func_70032_d((Entity)this.toAvoid) <= 15.0f) {
                Vector3d vector3d = SpellBookRepelGoal.getPosAvoid(this.entity, 16, 7, this.toAvoid.func_213303_ch());
                if (vector3d == null) {
                    return false;
                }
                if (this.toAvoid.func_70092_e(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c) < this.toAvoid.func_70068_e((Entity)this.entity)) {
                    return false;
                }
                this.path = this.pathNav.func_225466_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0);
                return this.path != null;
            }
            return false;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.pathNav.func_75500_f();
    }

    public void func_75249_e() {
        this.pathNav.func_75484_a(this.path, this.speedModifier);
    }

    public void func_75251_c() {
        this.toAvoid = null;
    }

    public void func_75246_d() {
        if ((double)this.entity.func_70032_d((Entity)this.toAvoid) <= 15.0) {
            this.entity.func_70661_as().func_75489_a(this.speedModifier);
        }
    }

    private boolean canRepelItem(PlayerEntity player, ItemStack stack) {
        boolean[] canDo = new boolean[2];
        if (stack.func_77973_b() instanceof SpellHoldingItem) {
            stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP, null).ifPresent(cap -> {
                ResourceLocation location = ((Spell)SpellInit.REPEL.get()).getRegistryName();
                canDo[0] = location != null && cap.getCurrentSpell().equals(location.toString());
                canDo[1] = SpellUtils.checkXpReq(player, (Spell)SpellInit.REPEL.get());
            });
            return canDo[0] && canDo[1];
        }
        return false;
    }
}

