/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.init;

import com.divinity.hlspells.HLSpells;
import com.divinity.hlspells.spell.Spell;
import com.divinity.hlspells.spell.SpellType;
import com.divinity.hlspells.spells.SpellActions;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class SpellInit {
    public static final DeferredRegister<Spell> SPELLS_DEFERRED_REGISTER = DeferredRegister.create(Spell.class, (String)"hlspells");
    public static final RegistryObject<Spell> EMPTY = SpellInit.register("empty", () -> new Spell(SpellType.CAST, (p, w) -> false, "No Spell"));
    public static final RegistryObject<Spell> SLOW_FALL = SpellInit.register("slow_fall", () -> new Spell(SpellType.HELD, SpellActions::doSlowFall, "Slow Falling", 1, 15));
    public static final RegistryObject<Spell> BLAST = SpellInit.register("blast", () -> new Spell(SpellType.CAST, SpellActions::doBlastSpell, "Blast", 6));
    public static final RegistryObject<Spell> TELEPORT = SpellInit.register("teleport", () -> new Spell(SpellType.CAST, SpellActions::doTeleport, "Teleport", 9));
    public static final RegistryObject<Spell> ARROW_RAIN = SpellInit.register("arrow_rain", () -> new Spell(SpellType.HELD, SpellActions::doArrowRain, "Arrow Rain", 1, 6));
    public static final RegistryObject<Spell> BOLT = SpellInit.register("bolt", () -> new Spell(SpellType.CAST, SpellActions::doBoltSpell, "Bolt", 5));
    public static final RegistryObject<Spell> HEALING_CIRCLE = SpellInit.register("healing_circle", () -> new Spell(SpellType.HELD, SpellActions::doHealingCircle, "Healing Circle", 1, 3));
    public static final RegistryObject<Spell> SOUL_SUMMON = SpellInit.register("soul_summon", () -> new Spell(SpellType.CAST, SpellActions::doSummonSpell, "Soul Summon", 16));
    public static final RegistryObject<Spell> PULL = SpellInit.register("pull", () -> new Spell(SpellType.CAST, SpellActions::doPullSpell, "Pull", 3));
    public static final RegistryObject<Spell> BOND = SpellInit.register("bond", () -> new Spell(SpellType.CAST, SpellActions::doBondSpell, "Bond", 1));
    public static final RegistryObject<Spell> LIGHTNING_CHAIN = SpellInit.register("lightning_chain", () -> new Spell(SpellType.CAST, SpellActions::doLightingChain, "Lightning Chain", 14));
    public static final RegistryObject<Spell> FIRE_BALL = SpellInit.register("fire_ball", () -> new Spell(SpellType.CAST, SpellActions::doFireBallSpell, "Fire Ball", 5));
    public static final RegistryObject<Spell> LEVITATION = SpellInit.register("levitation", () -> new Spell(SpellType.HELD, SpellActions::doLevitation, "Levitation", 1, 6));
    public static final RegistryObject<Spell> LIGHTNING_BOLT = SpellInit.register("lightning_bolt", () -> new Spell(SpellType.CAST, SpellActions::doLightningBolt, "Lightning Bolt", 8));
    public static final RegistryObject<Spell> KNOCKBACK_BOLT = SpellInit.register("knockback_bolt", () -> new Spell(SpellType.CAST, SpellActions::doKnockBackBolt, "Knockback Bolt", 3));
    public static final RegistryObject<Spell> RESPIRATION = SpellInit.register("respiration", () -> new Spell(SpellType.HELD, SpellActions::doRespiration, "Respiration", 1, 15));
    public static final RegistryObject<Spell> SPEED = SpellInit.register("speed", () -> new Spell(SpellType.HELD, SpellActions::doSpeed, "Speed", 1, 1));
    public static final RegistryObject<Spell> PIERCING_BOLT = SpellInit.register("piercing_bolt", () -> new Spell(SpellType.CAST, SpellActions::doPiercingBolt, "Piercing Bolt", 12));
    public static final RegistryObject<Spell> ABSORBING = SpellInit.register("absorbing", () -> new Spell(SpellType.CAST, SpellActions::doAbsorbing, "Absorbing", 6));
    public static final RegistryObject<Spell> FANGS = SpellInit.register("fangs", () -> new Spell(SpellType.CAST, SpellActions::doFangsSpell, "Fangs", 6));
    public static final RegistryObject<Spell> FLAMING_BOLT = SpellInit.register("flaming_bolt", () -> new Spell(SpellType.CAST, SpellActions::doFlamingBolt, "Flaming Bolt", 7));
    public static final RegistryObject<Spell> AQUA_BOLT = SpellInit.register("aqua_bolt", () -> new Spell(SpellType.CAST, SpellActions::doAquaBolt, "Aqua Bolt", 4));
    public static final RegistryObject<Spell> LURE = SpellInit.register("lure", () -> new Spell(SpellType.HELD, SpellActions::doLure, "Lure", 1, 10));
    public static final RegistryObject<Spell> REPEL = SpellInit.register("repel", () -> new Spell(SpellType.HELD, SpellActions::doRepel, "Repel", 1, 3));
    public static final RegistryObject<Spell> FLAMING_CIRCLE = SpellInit.register("flaming_circle", () -> new Spell(SpellType.HELD, SpellActions::doFlamingCircle, "Flaming Circle", 1, 6));
    public static final RegistryObject<Spell> FROST_PATH = SpellInit.register("frost_path", () -> new Spell(SpellType.HELD, SpellActions::doFrostPath, "Frost Path", 1, 6));
    public static Supplier<IForgeRegistry<Spell>> SPELLS_REGISTRY = SPELLS_DEFERRED_REGISTER.makeRegistry("spell", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE).onAdd((owner, stage, id, obj, oldObj) -> {}).setDefaultKey(new ResourceLocation("hlspells", "empty")));

    public static <T extends IForgeRegistryEntry<?>> ResourceLocation getName(T type) {
        return Objects.requireNonNull(type.getRegistryName());
    }

    public static RegistryObject<Spell> register(String name, Supplier<Spell> spell) {
        RegistryObject registryObject = SPELLS_DEFERRED_REGISTER.register(name, spell);
        HLSpells.LOGGER.info("Spell added : " + spell.get().getTrueDisplayName() + " ");
        return registryObject;
    }
}

