/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.items;

import com.divinity.hlspells.enchantments.ISpell;
import com.divinity.hlspells.init.SpellInit;
import com.divinity.hlspells.items.capabilities.spellholdercap.ISpellHolder;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolderProvider;
import com.divinity.hlspells.spell.Spell;
import com.divinity.hlspells.spell.SpellType;
import com.divinity.hlspells.spells.RunSpells;
import com.divinity.hlspells.spells.SpellActions;
import com.divinity.hlspells.util.SpellUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class SpellHoldingItem
extends ShootableItem {
    private final boolean isSpellBook;
    private Spell currentStoredSpell = null;

    public SpellHoldingItem(Item.Properties properties, boolean isSpellBook) {
        super(properties);
        this.isSpellBook = isSpellBook;
    }

    public boolean isSpellBook() {
        return this.isSpellBook;
    }

    public boolean isWand() {
        return !this.isSpellBook;
    }

    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a;
    }

    public int func_230305_d_() {
        return 8;
    }

    public void func_77624_a(ItemStack stack, @Nullable World pLevel, List<ITextComponent> text, ITooltipFlag pFlag) {
        stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP, null).ifPresent(cap -> {
            List<String> spells = cap.getSpells();
            if (this.isSpellBook) {
                Spell spell = SpellUtils.getSpell(stack);
                text.add((ITextComponent)spell.getDisplayName().func_240699_a_(spell.getType().getTooltipFormatting()));
            } else {
                text.add(1, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Spells: "));
                if (spells.isEmpty()) {
                    text.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "   Empty"));
                } else {
                    spells.forEach(c -> {
                        Spell spell = SpellUtils.getSpellByID(c);
                        if (cap.getCurrentSpell().equals(c)) {
                            text.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "   " + spell.getTrueDisplayName()));
                        } else {
                            text.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "   " + spell.getTrueDisplayName()));
                        }
                    });
                }
            }
        });
    }

    public boolean func_77636_d(ItemStack pStack) {
        List spells = pStack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP).map(ISpellHolder::getSpells).orElse(null);
        return this.isSpellBook && SpellUtils.getSpell(pStack) != SpellInit.EMPTY.get() || !this.isSpellBook && spells != null && !spells.isEmpty();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new SpellHolderProvider();
    }

    public void func_150895_a(ItemGroup pGroup, NonNullList<ItemStack> pItems) {
        if (this.isSpellBook) {
            if (this.func_194125_a(pGroup)) {
                for (Spell spell : SpellInit.SPELLS_REGISTRY.get()) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP).ifPresent(cap -> {
                        if (spell != SpellInit.EMPTY.get()) {
                            cap.addSpell(spell.getRegistryName().toString());
                        }
                    });
                    pItems.add((Object)stack);
                }
            }
        } else {
            super.func_150895_a(pGroup, pItems);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        this.currentStoredSpell = SpellUtils.getSpell(itemstack);
        LazyOptional capability = itemstack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP);
        if (capability.isPresent()) {
            List spells = capability.map(ISpellHolder::getSpells).orElse(null);
            if (spells != null && !spells.isEmpty()) {
                player.func_184598_c(hand);
            } else {
                return ActionResult.func_226251_d_((Object)itemstack);
            }
        }
        capability.ifPresent(cap -> cap.setHeldActive(true));
        if (!world.func_201670_d()) {
            Spell spell;
            if (this.isSpellBook) {
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_219617_ah, SoundCategory.NEUTRAL, 0.6f, 1.0f);
            }
            if ((spell = SpellUtils.getSpell(itemstack)) != SpellInit.EMPTY.get() && spell.getType() == SpellType.HELD) {
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_191248_br, SoundCategory.NEUTRAL, 0.6f, 1.0f);
            }
        }
        return ActionResult.func_226248_a_((Object)itemstack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int pItemSlot, boolean pIsSelected) {
        if (entity instanceof PlayerEntity && stack.func_77973_b() instanceof SpellHoldingItem) {
            PlayerEntity player = (PlayerEntity)entity;
            stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP).ifPresent(cap -> {
                if (cap.isHeldActive()) {
                    for (Hand hand : Hand.values()) {
                        ItemStack heldStack = player.func_184586_b(hand);
                        if (SpellUtils.getSpell(heldStack) != this.currentStoredSpell) continue;
                        return;
                    }
                    cap.setHeldActive(false);
                }
            });
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int power) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            LazyOptional capability = stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP);
            capability.ifPresent(cap -> cap.setHeldActive(false));
            if (player.func_184605_cv() < 71988 && !world.func_201670_d()) {
                RunSpells.doCastSpell(player, world, stack);
                capability.filter(p -> !p.getSpells().isEmpty()).ifPresent(cap -> {
                    world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_191244_bn, SoundCategory.NEUTRAL, 0.6f, 1.0f);
                    SpellActions.doParticles(player);
                });
            }
        }
    }

    public int func_77626_a(ItemStack pStack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack pStack) {
        return this.isSpellBook ? UseAction.CROSSBOW : UseAction.BOW;
    }

    public boolean func_77616_k(ItemStack pStack) {
        return this.isSpellBook;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.isSpellBook;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.isSpellBook && SpellUtils.getSpell(stack) == SpellInit.EMPTY.get() && enchantment instanceof ISpell;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT capTag = new CompoundNBT();
        LazyOptional spellHolder = stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP);
        if (spellHolder.isPresent()) {
            spellHolder.ifPresent(cap -> capTag.func_218657_a("spellHolder", Objects.requireNonNull(SpellHolderProvider.SPELL_HOLDER_CAP.writeNBT(spellHolder.orElseThrow(RuntimeException::new), null))));
        }
        CompoundNBT stackTag = stack.func_77978_p();
        if (capTag.isEmpty()) {
            return stackTag;
        }
        stackTag = stackTag == null ? new CompoundNBT() : stackTag.func_74737_b();
        stackTag.func_218657_a("spellCap", (INBT)capTag);
        return stackTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        CompoundNBT capTags;
        stack.func_77982_d(nbt);
        if (nbt != null && nbt.func_74764_b("spellCap") && (capTags = nbt.func_74775_l("spellCap")).func_74764_b("spellHolder")) {
            stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP).ifPresent(spellHolder -> SpellHolderProvider.SPELL_HOLDER_CAP.readNBT(spellHolder, null, capTags.func_74781_a("spellHolder")));
        }
    }
}

