/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.items.capabilities.spellholdercap;

import com.divinity.hlspells.init.SpellInit;
import com.divinity.hlspells.items.capabilities.spellholdercap.ISpellHolder;
import com.divinity.hlspells.spell.Spell;
import java.util.ArrayList;
import java.util.List;

public class SpellHolder
implements ISpellHolder {
    private final List<String> spells = new ArrayList<String>();
    private int currentSpellCycle = 0;
    private boolean isHeld = false;

    @Override
    public List<String> getSpells() {
        return this.spells;
    }

    @Override
    public void addSpell(String spell) {
        if (!this.spells.contains(spell)) {
            this.spells.add(spell);
        }
    }

    @Override
    public void removeSpell(String spell) {
        this.spells.remove(spell);
    }

    @Override
    public boolean containsSpell(String spell) {
        return this.spells.contains(spell);
    }

    @Override
    public int getCurrentSpellCycle() {
        return this.currentSpellCycle;
    }

    @Override
    public void setCurrentSpellCycle(int currentSpellCycle) {
        this.currentSpellCycle = currentSpellCycle;
        this.cycleSpellCheck();
    }

    private void cycleSpellCheck() {
        if (this.currentSpellCycle > this.getSpells().size() - 1) {
            this.currentSpellCycle = 0;
        }
    }

    @Override
    public String getCurrentSpell() {
        return this.getCurrentSpellCycle() < this.spells.size() ? this.spells.get(this.getCurrentSpellCycle()) : ((Spell)SpellInit.EMPTY.get()).getRegistryName().toString();
    }

    @Override
    public boolean isHeldActive() {
        return this.isHeld;
    }

    @Override
    public void setHeldActive(boolean held) {
        this.isHeld = held;
    }
}

