/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.loot;

import com.divinity.hlspells.loot.SetSpell;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hlspells")
public class LootTableHandler {
    public static final LootFunctionType SET_SPELL = LootTableHandler.register("set_spell", new SetSpell.Serializer());

    @SubscribeEvent
    public static void registerLoot(LootTableLoadEvent evt) {
        String prefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "woodland_mansion": 
                case "end_city_treasure": 
                case "stronghold_library": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "desert_pyramid": 
                case "nether_bridge": 
                case "bastion_treasure": {
                    evt.getTable().addPool(LootTableHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    public static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(LootTableHandler.getInjectEntry(entryName)).bonusRolls(0.0f, 1.0f).name("inject").func_216044_b();
    }

    private static LootEntry.Builder<?> getInjectEntry(String name) {
        ResourceLocation table = new ResourceLocation("hlspells", "inject/" + name);
        return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(1);
    }

    private static LootFunctionType register(String id, LootFunction.Serializer<? extends ILootFunction> serializer) {
        return (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation("hlspells", id), (Object)new LootFunctionType(serializer));
    }
}

