/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.network.packets;

import com.divinity.hlspells.items.SpellHoldingItem;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolderProvider;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WandInputPacket {
    private int key;

    public WandInputPacket() {
    }

    public WandInputPacket(int key) {
        this.key = key;
    }

    public static void encode(WandInputPacket message, PacketBuffer buffer) {
        buffer.writeInt(message.key);
    }

    public static WandInputPacket decode(PacketBuffer buffer) {
        return new WandInputPacket(buffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player != null) {
                boolean offHandWand;
                ItemStack mainHandStack = player.func_184614_ca();
                ItemStack offHandStack = player.func_184592_cb();
                boolean mainHandWand = mainHandStack.func_77973_b() instanceof SpellHoldingItem && ((SpellHoldingItem)mainHandStack.func_77973_b()).isWand();
                boolean bl = offHandWand = offHandStack.func_77973_b() instanceof SpellHoldingItem && ((SpellHoldingItem)offHandStack.func_77973_b()).isWand();
                if (mainHandWand) {
                    mainHandStack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP, null).ifPresent(p -> p.setCurrentSpellCycle(p.getCurrentSpellCycle() + 1));
                } else if (offHandWand) {
                    offHandStack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP, null).ifPresent(p -> p.setCurrentSpellCycle(p.getCurrentSpellCycle() + 1));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

