/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.setup.client;

import com.divinity.hlspells.init.EntityInit;
import com.divinity.hlspells.init.ItemInit;
import com.divinity.hlspells.init.SpellInit;
import com.divinity.hlspells.items.SpellHoldingItem;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolderProvider;
import com.divinity.hlspells.items.capabilities.totemcap.ITotemCap;
import com.divinity.hlspells.items.capabilities.totemcap.TotemItemProvider;
import com.divinity.hlspells.network.NetworkManager;
import com.divinity.hlspells.network.packets.WandInputPacket;
import com.divinity.hlspells.renderers.BaseBoltRenderer;
import com.divinity.hlspells.renderers.StormBoltRenderer;
import com.divinity.hlspells.spell.Spell;
import com.divinity.hlspells.util.SpellUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="hlspells", value={Dist.CLIENT})
public class ClientSetup {
    public static final KeyBinding WAND_BINDING = new KeyBinding("Wand Cycle", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputMappings.Type.KEYSYM, 71, "HLSpells");
    static boolean buttonPressedFlag;

    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.SPELL_BOOK.get()), (ResourceLocation)new ResourceLocation("using"), (stack, world, living) -> {
                if (living instanceof PlayerEntity && living.func_184587_cr() && living.func_184607_cu() == stack) {
                    if ((double)living.func_184605_cv() < 72000.0 && (double)living.func_184605_cv() >= 71997.0) {
                        return 0.2f;
                    }
                    if ((double)living.func_184605_cv() < 71997.0 && (double)living.func_184605_cv() >= 71994.0) {
                        return 0.4f;
                    }
                    if ((double)living.func_184605_cv() < 71994.0 && (double)living.func_184605_cv() >= 71991.0) {
                        return 0.6f;
                    }
                    if ((double)living.func_184605_cv() < 71991.0 && (double)living.func_184605_cv() >= 71988.0) {
                        return 0.8f;
                    }
                    if ((double)living.func_184605_cv() < 71988.0) {
                        return 1.0f;
                    }
                }
                return 0.0f;
            });
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.WAND.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, living) -> {
                if (living instanceof PlayerEntity && living.func_184587_cr() && living.func_184607_cu() == stack) {
                    if ((double)living.func_184605_cv() < 72000.0 && (double)living.func_184605_cv() >= 71997.0) {
                        return 0.2f;
                    }
                    if ((double)living.func_184605_cv() < 71997.0 && (double)living.func_184605_cv() >= 71994.0) {
                        return 0.4f;
                    }
                    if ((double)living.func_184605_cv() < 71994.0 && (double)living.func_184605_cv() >= 71991.0) {
                        return 0.6f;
                    }
                    if ((double)living.func_184605_cv() < 71991.0 && (double)living.func_184605_cv() >= 71988.0) {
                        return 0.8f;
                    }
                    if ((double)living.func_184605_cv() < 71988.0) {
                        return 1.0f;
                    }
                }
                return 0.0f;
            });
            ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.STAFF.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, living) -> {
                if (living instanceof PlayerEntity && living.func_184587_cr() && living.func_184607_cu() == stack) {
                    if ((double)living.func_184605_cv() < 72000.0 && (double)living.func_184605_cv() >= 71997.0) {
                        return 0.2f;
                    }
                    if ((double)living.func_184605_cv() < 71997.0 && (double)living.func_184605_cv() >= 71994.0) {
                        return 0.4f;
                    }
                    if ((double)living.func_184605_cv() < 71994.0 && (double)living.func_184605_cv() >= 71991.0) {
                        return 0.6f;
                    }
                    if ((double)living.func_184605_cv() < 71991.0 && (double)living.func_184605_cv() >= 71988.0) {
                        return 0.8f;
                    }
                    if ((double)living.func_184605_cv() < 71988.0) {
                        return 1.0f;
                    }
                }
                return 0.0f;
            });
        });
        ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.TOTEM_OF_RETURNING.get()), (ResourceLocation)new ResourceLocation("used"), (stack, world, living) -> {
            LazyOptional totemCap;
            if (living instanceof PlayerEntity && (totemCap = stack.getCapability(TotemItemProvider.TOTEM_CAP)).isPresent()) {
                return totemCap.map(ITotemCap::getHasDied).orElse(false) != false ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
        ClientRegistry.registerKeyBinding((KeyBinding)WAND_BINDING);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityInit.INVISIBLE_TARGETING_ENTITY.get()), StormBoltRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityInit.PIERCING_BOLT_ENTITY.get()), manager -> new BaseBoltRenderer(manager, new ResourceLocation("hlspells", "textures/entity/bolt/green_bolt.png")));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityInit.FLAMING_BOLT_ENTITY.get()), manager -> new BaseBoltRenderer(manager, new ResourceLocation("hlspells", "textures/entity/bolt/orange_bolt.png")));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityInit.AQUA_BOLT_ENTITY.get()), manager -> new BaseBoltRenderer(manager, new ResourceLocation("hlspells", "textures/entity/bolt/blue_bolt.png")));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityInit.SUMMONED_VEX_ENTITY.get()), VexRenderer::new);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (WAND_BINDING.func_151470_d() && !buttonPressedFlag) {
                if (player != null && !player.func_184587_cr()) {
                    boolean offHandWand;
                    NetworkManager.INSTANCE.sendToServer((Object)new WandInputPacket(WAND_BINDING.getKey().func_197937_c()));
                    ItemStack stack = ItemStack.field_190927_a;
                    ItemStack mainHand = player.func_184614_ca();
                    ItemStack offHand = player.func_184592_cb();
                    boolean mainHandWand = mainHand.func_77973_b() instanceof SpellHoldingItem && ((SpellHoldingItem)mainHand.func_77973_b()).isWand();
                    boolean bl = offHandWand = offHand.func_77973_b() instanceof SpellHoldingItem && ((SpellHoldingItem)offHand.func_77973_b()).isWand();
                    if (mainHandWand) {
                        stack = mainHand;
                    } else if (offHandWand) {
                        stack = offHand;
                    }
                    if (!stack.func_190926_b()) {
                        stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP, null).ifPresent(cap -> {
                            if (!cap.getSpells().isEmpty()) {
                                cap.setCurrentSpellCycle(cap.getCurrentSpellCycle() + 1);
                                Spell spell = SpellUtils.getSpellByID(cap.getCurrentSpell());
                                player.func_146105_b((ITextComponent)new StringTextComponent("Spell : " + spell.getTrueDisplayName()).func_240699_a_(TextFormatting.GOLD), true);
                            }
                        });
                    }
                }
                buttonPressedFlag = true;
            }
            if (!WAND_BINDING.func_151470_d() && buttonPressedFlag) {
                buttonPressedFlag = false;
            }
        }
    }

    @SubscribeEvent
    public static void onInput(InputUpdateEvent event) {
        ClientPlayerEntity player = (ClientPlayerEntity)event.getPlayer();
        Hand hand = player.func_184600_cs();
        if (hand != null) {
            Spell spell;
            ItemStack stack = player.func_184586_b(hand);
            if (player.func_184587_cr() && !player.func_184218_aH() && stack.func_77973_b() instanceof SpellHoldingItem && ((spell = SpellUtils.getSpell(stack)) == SpellInit.SPEED.get() || spell == SpellInit.FROST_PATH.get())) {
                player.field_71158_b.field_78902_a /= 0.2f;
                player.field_71158_b.field_192832_b /= 0.2f;
            }
        }
    }

    public static void displayActivation(PlayerEntity playerEntity, ItemStack stack, boolean particleIn) {
        Minecraft.func_71410_x().field_71460_t.func_190565_a(stack);
        if (particleIn) {
            Minecraft.func_71410_x().field_71452_i.func_199281_a((Entity)playerEntity, (IParticleData)ParticleTypes.field_197604_O, 30);
        }
    }
}

