/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.spells;

import com.divinity.hlspells.HLSpells;
import com.divinity.hlspells.entities.AquaBoltEntity;
import com.divinity.hlspells.entities.FlamingBoltEntity;
import com.divinity.hlspells.entities.InvisibleTargetingEntity;
import com.divinity.hlspells.entities.PiercingBoltEntity;
import com.divinity.hlspells.entities.SmartShulkerBolt;
import com.divinity.hlspells.entities.SummonedVexEntity;
import com.divinity.hlspells.goal.SpellBookLureGoal;
import com.divinity.hlspells.goal.SpellBookRepelGoal;
import com.divinity.hlspells.init.BlockInit;
import com.divinity.hlspells.init.EntityInit;
import com.divinity.hlspells.player.capability.PlayerCapProvider;
import com.divinity.hlspells.util.Util;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.IPacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;

@Mod.EventBusSubscriber(modid="hlspells")
public class SpellActions {
    public static final EffectInstance GLOWING = new EffectInstance(Effects.field_188423_x, Integer.MAX_VALUE, 5, false, false);
    public static final EffectInstance LEVITATION = new EffectInstance(Effects.field_188424_y, Integer.MAX_VALUE, 5, false, false);
    public static final EffectInstance SLOW_FALLING = new EffectInstance(Effects.field_204839_B, Integer.MAX_VALUE, 5, false, false);
    static final UUID speedUUID = UUID.fromString("05b61a62-ae84-492e-8536-f365b7143296");
    static final AttributeModifier speedModifier = new AttributeModifier(speedUUID, "Speed", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    static int flameTimer = 0;
    static int arrowRainArrowSpawnTimer = 0;
    static int arrowRainCloudSpawnTimer = 0;
    static int protectionCircleTimer = 0;
    static boolean arrowRainCloudSpawnBoolean = true;
    static int healingTimer = 0;
    static int airTimer = 0;

    public static Comparator<Entity> getEntityComparator(PlayerEntity player) {
        return new Object(){

            Comparator<Entity> compareDistOf(double x, double y, double z) {
                return Comparator.comparing(entity -> entity.func_70092_e(x, y, z));
            }
        }.compareDistOf(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
    }

    public static boolean doBlastSpell(PlayerEntity player, World world) {
        double x = player.func_226277_ct_();
        double y = player.func_226278_cu_();
        double z = player.func_226281_cx_();
        List entities = world.func_175647_a(Entity.class, new AxisAlignedBB(x - 6.0, y - 6.0, z - 6.0, x + 6.0, y + 6.0, z + 6.0), null).stream().sorted(SpellActions.getEntityComparator(player)).collect(Collectors.toList());
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_233627_a_(2.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
            livingEntity.func_70097_a(DamageSource.func_188405_b((LivingEntity)livingEntity), 4.0f);
            player.func_213317_d(player.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
        }
        world.func_184133_a(null, new BlockPos(x, y, z), SoundEvents.field_187539_bB, SoundCategory.WEATHER, 0.6f, 1.0f);
        world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, x, y, z, 1.0, 0.0, 0.0);
        return true;
    }

    public static boolean doBoltSpell(PlayerEntity player, World world) {
        if (Util.rayTrace(world, player, 25.0) != null && player.func_225608_bj_()) {
            Entity entity = Util.rayTrace(world, player, 25.0);
            SmartShulkerBolt smartBullet = new SmartShulkerBolt(world, (LivingEntity)player, entity, player.func_174811_aO().func_176740_k());
            smartBullet.func_70107_b(player.func_226277_ct_() + player.func_70676_i((float)1.0f).field_72450_a, player.func_226278_cu_() + 1.35, player.func_226281_cx_() + player.func_70676_i((float)1.0f).field_72449_c);
            world.func_217376_c((Entity)smartBullet);
        } else {
            ShulkerBulletEntity dumbBullet = new ShulkerBulletEntity(EntityType.field_200739_ae, world){

                public void func_184569_a(@Nullable Direction.Axis axis) {
                }

                public void func_70227_a(RayTraceResult result) {
                    RayTraceResult.Type type = result.func_216346_c();
                    if (type == RayTraceResult.Type.ENTITY) {
                        this.func_213868_a((EntityRayTraceResult)result);
                    } else if (type == RayTraceResult.Type.BLOCK) {
                        this.func_230299_a_((BlockRayTraceResult)result);
                    }
                }

                public void func_70071_h_() {
                    super.func_70071_h_();
                    if (this.func_234616_v_() != null && this.func_70032_d(this.func_234616_v_()) >= 40.0f) {
                        this.func_70106_y();
                    }
                }

                public IPacket<?> func_213297_N() {
                    return NetworkHooks.getEntitySpawningPacket((Entity)this);
                }

                public void func_213868_a(EntityRayTraceResult result) {
                    LivingEntity livingentity;
                    Entity entity = result.func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    LivingEntity livingEntity = livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
                    if (result.func_216348_a() == this.func_234616_v_()) {
                        return;
                    }
                    boolean flag = entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)livingentity).func_76349_b(), 8.0f);
                    if (flag) {
                        this.func_174815_a(livingentity, entity);
                        this.func_70106_y();
                    }
                }
            };
            dumbBullet.func_189654_d(true);
            dumbBullet.func_212361_a((Entity)player);
            dumbBullet.func_70107_b(player.func_226277_ct_() + player.func_70676_i((float)1.0f).field_72450_a, player.func_226278_cu_() + 1.35, player.func_226281_cx_() + player.func_70676_i((float)1.0f).field_72449_c);
            dumbBullet.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.3f, 1.3f, 1.3f);
            world.func_217376_c((Entity)dumbBullet);
        }
        return true;
    }

    public static boolean doAbsorbing(PlayerEntity player, World world) {
        boolean used = false;
        for (BlockPos blockPos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)(player.func_226277_ct_() - 8.0)), (int)MathHelper.func_76128_c((double)(player.func_226278_cu_() - 8.0)), (int)MathHelper.func_76128_c((double)(player.func_226281_cx_() - 8.0)), (int)MathHelper.func_76128_c((double)(player.func_226277_ct_() + 8.0)), (int)MathHelper.func_76128_c((double)(player.func_226278_cu_() + 8.0)), (int)MathHelper.func_76128_c((double)(player.func_226281_cx_() + 8.0)))) {
            BlockState blockState = world.func_180495_p(blockPos);
            FluidState fluidState = world.func_204610_c(blockPos);
            if (!fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            used = true;
            if (blockState.func_177230_c() instanceof IWaterLoggable && ((IWaterLoggable)blockState.func_177230_c()).func_204508_a((IWorld)world, blockPos, blockState) != Fluids.field_204541_a) {
                world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.FALSE), 3);
                continue;
            }
            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return used;
    }

    public static boolean doFlamingBolt(PlayerEntity player, World world) {
        FlamingBoltEntity flamingBolt = new FlamingBoltEntity((EntityType<? extends FlamingBoltEntity>)((EntityType)EntityInit.FLAMING_BOLT_ENTITY.get()), world);
        flamingBolt.func_212361_a((Entity)player);
        flamingBolt.func_70107_b(player.func_226277_ct_() + player.func_70676_i((float)1.0f).field_72450_a, player.func_226278_cu_() + 1.35, player.func_226281_cx_() + player.func_70676_i((float)1.0f).field_72449_c);
        flamingBolt.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.3f, 1.3f, 1.3f);
        world.func_217376_c((Entity)flamingBolt);
        return true;
    }

    public static boolean doAquaBolt(PlayerEntity player, World world) {
        AquaBoltEntity aquaBolt = new AquaBoltEntity((EntityType<? extends AquaBoltEntity>)((EntityType)EntityInit.AQUA_BOLT_ENTITY.get()), world);
        aquaBolt.func_212361_a((Entity)player);
        aquaBolt.func_70107_b(player.func_226277_ct_() + player.func_70676_i((float)1.0f).field_72450_a, player.func_226278_cu_() + 1.35, player.func_226281_cx_() + player.func_70676_i((float)1.0f).field_72449_c);
        aquaBolt.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.3f, 1.3f, 1.3f);
        world.func_217376_c((Entity)aquaBolt);
        return true;
    }

    public static boolean doPiercingBolt(PlayerEntity player, World world) {
        PiercingBoltEntity piercingBullet = new PiercingBoltEntity((EntityType<? extends PiercingBoltEntity>)((EntityType)EntityInit.PIERCING_BOLT_ENTITY.get()), world);
        piercingBullet.func_212361_a((Entity)player);
        piercingBullet.func_70107_b(player.func_226277_ct_() + player.func_70676_i((float)1.0f).field_72450_a, player.func_226278_cu_() + 1.35, player.func_226281_cx_() + player.func_70676_i((float)1.0f).field_72449_c);
        piercingBullet.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.3f, 1.3f, 1.3f);
        world.func_217376_c((Entity)piercingBullet);
        return true;
    }

    public static boolean doFireBallSpell(PlayerEntity player, World world) {
        Vector3d vector3d = player.func_70676_i(1.0f);
        FireballEntity fireballEntity = new FireballEntity(world, (LivingEntity)player, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
        fireballEntity.func_70107_b(player.func_226277_ct_() + vector3d.field_72450_a * 1.5, player.func_226278_cu_() + 0.5, player.func_226281_cx_() + vector3d.field_72449_c * 1.5);
        fireballEntity.func_212361_a((Entity)player);
        world.func_217376_c((Entity)fireballEntity);
        return true;
    }

    public static boolean doKnockBackBolt(PlayerEntity player, World world) {
        ShulkerBulletEntity entity = new ShulkerBulletEntity(EntityType.field_200739_ae, world){

            public void func_184569_a(@Nullable Direction.Axis axis) {
            }

            public void func_70071_h_() {
                super.func_70071_h_();
                if (this.func_234616_v_() != null && this.func_70032_d(this.func_234616_v_()) >= 40.0f) {
                    this.func_70106_y();
                }
            }

            public void func_213868_a(EntityRayTraceResult result) {
                LivingEntity livingentity;
                Entity entity = result.func_216348_a();
                Entity entity1 = this.func_234616_v_();
                LivingEntity livingEntity = livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
                if (result.func_216348_a() == this.func_234616_v_()) {
                    return;
                }
                boolean flag = entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)livingentity).func_76349_b(), 0.0f);
                if (flag) {
                    entity.func_213317_d(this.func_70040_Z().func_216371_e().func_216372_d(5.0, 0.0, 5.0));
                    this.func_70106_y();
                }
            }
        };
        entity.func_189654_d(true);
        entity.func_70107_b(player.func_226277_ct_() + player.func_70676_i((float)1.0f).field_72450_a, player.func_226278_cu_() + 1.35, player.func_226281_cx_() + player.func_70676_i((float)1.0f).field_72449_c);
        entity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.3f, 1.3f, 1.3f);
        world.func_217376_c((Entity)entity);
        return true;
    }

    public static boolean doLightningBolt(PlayerEntity player, World world) {
        RayTraceResult rayTraceResult = Util.lookAt((Entity)player, 25.0, 1.0f, false);
        Vector3d location = rayTraceResult.func_216347_e();
        int stepX = 0;
        int stepY = 0;
        int stepZ = 0;
        if (rayTraceResult instanceof BlockRayTraceResult) {
            Direction rayTraceDirection = ((BlockRayTraceResult)rayTraceResult).func_216354_b();
            stepX = rayTraceDirection.func_82601_c();
            stepY = rayTraceDirection.func_96559_d();
            stepZ = rayTraceDirection.func_82599_e();
        }
        double dx = location.func_82615_a() + (double)stepX;
        double dy = location.func_82617_b() + (double)stepY - 1.0;
        double dz = location.func_82616_c() + (double)stepZ;
        LightningBoltEntity lightning = new LightningBoltEntity(EntityType.field_200728_aG, world);
        lightning.func_225653_b_(dx, dy, dz);
        world.func_217376_c((Entity)lightning);
        return true;
    }

    public static boolean doBondSpell(PlayerEntity player, World world) {
        Entity targetEntity = Util.rayTrace(world, player, 20.0);
        if (targetEntity instanceof TameableEntity) {
            TameableEntity entity = (TameableEntity)targetEntity;
            entity.func_193101_c(player);
            return true;
        }
        return false;
    }

    public static boolean doLightingChain(PlayerEntity player, World world) {
        InvisibleTargetingEntity stormBullet = new InvisibleTargetingEntity((EntityType<? extends ArrowEntity>)((EntityType)EntityInit.INVISIBLE_TARGETING_ENTITY.get()), world);
        stormBullet.setHomePosition(player.func_213303_ch());
        stormBullet.func_212361_a((Entity)player);
        stormBullet.func_70107_b(player.func_226277_ct_() + player.func_70676_i((float)1.0f).field_72450_a, player.func_226278_cu_() + 1.35, player.func_226281_cx_() + player.func_70676_i((float)1.0f).field_72449_c);
        stormBullet.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.3f, 1.3f, 1.3f);
        world.func_217376_c((Entity)stormBullet);
        return true;
    }

    public static boolean doPullSpell(PlayerEntity player, World world) {
        Entity targetEntity;
        if (Util.rayTrace(world, player, 35.0) != null && (targetEntity = Util.rayTrace(world, player, 35.0)) != null && targetEntity.func_70032_d((Entity)player) > 5.0f) {
            targetEntity.func_213317_d(player.func_70040_Z().func_216371_e().func_216372_d(5.0, 5.0, 5.0));
            return true;
        }
        return false;
    }

    public static boolean doTeleport(PlayerEntity player, World world) {
        RayTraceResult rayTraceResult = Util.lookAt((Entity)player, 50.0, 1.0f, false);
        Vector3d location = rayTraceResult.func_216347_e();
        int stepX = 0;
        int stepY = 1;
        int stepZ = 0;
        if (rayTraceResult instanceof BlockRayTraceResult && world.func_180495_p(new BlockPos(location).func_177984_a()).func_185904_a() != Material.field_151579_a) {
            Direction rayTraceDirection = ((BlockRayTraceResult)rayTraceResult).func_216354_b();
            stepX = rayTraceDirection.func_82601_c();
            stepY = rayTraceDirection.func_96559_d();
            stepZ = rayTraceDirection.func_82599_e();
        }
        double tx = location.func_82615_a() + (double)stepX;
        double ty = location.func_82617_b() + (double)stepY;
        double tz = location.func_82616_c() + (double)stepZ;
        BlockPos teleportPos = new BlockPos(tx, ty, tz);
        player.field_70143_R = 0.0f;
        Util.teleport(world, player.func_233580_cy_(), teleportPos, (Entity)player);
        return true;
    }

    public static boolean doSummonSpell(PlayerEntity player, World world) {
        for (int i = 0; i < 4; ++i) {
            BlockPos blockpos = player.func_233580_cy_().func_177982_a(-2 + world.field_73012_v.nextInt(5), 1, -2 + world.field_73012_v.nextInt(5));
            SummonedVexEntity vexEntity = new SummonedVexEntity((EntityType<? extends VexEntity>)((EntityType)EntityInit.SUMMONED_VEX_ENTITY.get()), world);
            vexEntity.func_174828_a(blockpos, 0.0f, 0.0f);
            vexEntity.setSummonedOwner(player);
            vexEntity.func_190653_a(20 * (30 + world.field_73012_v.nextInt(50)));
            if (!(world instanceof ServerWorld)) continue;
            ServerWorld serverWorld = (ServerWorld)world;
            vexEntity.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(blockpos), SpawnReason.MOB_SUMMONED, null, null);
            serverWorld.func_242417_l((Entity)vexEntity);
        }
        return true;
    }

    public static void doParticles(PlayerEntity player) {
        SpellActions.doBookParticles(player.field_70170_p, new BlockPos(player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_()), 100);
        player.field_70170_p.func_184133_a(null, new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), SoundEvents.field_190021_aL, SoundCategory.AMBIENT, 0.6f, 1.0f);
    }

    public static void doBookParticles(World world, BlockPos pos, int number) {
        for (int l = 0; l < number; ++l) {
            double d0 = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            double d1 = (float)pos.func_177956_o() + world.field_73012_v.nextFloat();
            double d2 = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            double d3 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
            double d4 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
            double d5 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
            world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, d0, d1, d2, d3, d4, d5);
        }
    }

    public static boolean doFangsSpell(PlayerEntity player, World world) {
        float f = (float)MathHelper.func_181159_b((double)player.func_226281_cx_(), (double)player.func_226277_ct_());
        if (!player.func_225608_bj_()) {
            InvisibleTargetingEntity stormBullet = new InvisibleTargetingEntity((EntityType<? extends ArrowEntity>)((EntityType)EntityInit.INVISIBLE_TARGETING_ENTITY.get()), world);
            stormBullet.setHomePosition(player.func_213303_ch());
            stormBullet.setIsLightning(false);
            stormBullet.func_212361_a((Entity)player);
            stormBullet.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            stormBullet.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.2f, 1.2f, 1.2f);
            stormBullet.func_213293_j(MathHelper.func_76134_b((float)((float)Math.toRadians(player.field_70177_z + 90.0f))), 0.0, MathHelper.func_76126_a((float)((float)Math.toRadians(player.field_70177_z + 90.0f))));
            world.func_217376_c((Entity)stormBullet);
        } else {
            for (int i = 0; i < 5; ++i) {
                float f1 = f + (float)i * (float)Math.PI * 0.4f;
                SpellActions.createFangsEntity((LivingEntity)player, world, player.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f1) * 1.5, player.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f1) * 1.5, player.func_226278_cu_(), f1, 0);
            }
            for (int k = 0; k < 8; ++k) {
                float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                SpellActions.createFangsEntity((LivingEntity)player, world, player.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.5, player.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.5, player.func_226278_cu_(), f2, 3);
            }
        }
        return true;
    }

    public static boolean doSlowFall(PlayerEntity player, World world) {
        if (player.func_213322_ci().field_72448_b <= 0.0) {
            EffectInstance effect = player.func_70660_b(Effects.field_204839_B);
            if (effect != null && effect.func_188418_e()) {
                player.getCapability(PlayerCapProvider.PLAYER_CAP).ifPresent(cap -> {
                    if (cap.getEffect() == null) {
                        cap.setEffect(effect.func_188419_a());
                        cap.setEffectDuration(effect.func_76459_b());
                        cap.setEffectAmplifier(effect.func_76458_c());
                    }
                });
            }
            player.func_195064_c(SLOW_FALLING);
            for (int i = 0; i < 3; ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_(), player.func_226278_cu_() - 1.0, player.func_226281_cx_(), 0.0, player.func_213322_ci().field_72448_b, 0.0);
            }
            return true;
        }
        return false;
    }

    public static boolean doFrostPath(PlayerEntity player, World world) {
        BlockPos pos = player.func_233580_cy_();
        BlockState blockstate = ((Block)BlockInit.CUSTOM_FROSTED_ICE.get()).func_176223_P();
        float f = 3.0f;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        boolean used = false;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), -1.0, (double)(-f)), (BlockPos)pos.func_177963_a((double)f, -1.0, (double)f))) {
            BlockState state;
            if (!blockpos.func_218137_a((IPosition)player.func_213303_ch(), (double)f)) continue;
            mutablePos.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState mutableState = world.func_180495_p((BlockPos)mutablePos);
            if (!mutableState.isAir((IBlockReader)world, (BlockPos)mutablePos) || !(state = world.func_180495_p(blockpos)).func_185904_a().func_76222_j() || !blockstate.func_196955_c((IWorldReader)world, blockpos) || !world.func_226663_a_(blockstate, blockpos, ISelectionContext.func_216377_a()) || ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
            used = true;
            world.func_175656_a(blockpos, blockstate);
            world.func_205220_G_().func_205360_a(blockpos, (Object)BlockInit.CUSTOM_FROSTED_ICE.get(), MathHelper.func_76136_a((Random)player.func_70681_au(), (int)60, (int)120));
        }
        return used;
    }

    public static boolean doLure(PlayerEntity player, World world) {
        EffectInstance effect = player.func_70660_b(Effects.field_188423_x);
        if (effect != null && effect.func_188418_e()) {
            player.getCapability(PlayerCapProvider.PLAYER_CAP).ifPresent(cap -> {
                if (cap.getEffect() == null) {
                    cap.setEffect(effect.func_188419_a());
                    cap.setEffectDuration(effect.func_76459_b());
                    cap.setEffectAmplifier(effect.func_76458_c());
                }
            });
        }
        player.func_195064_c(GLOWING);
        List mobEntities = world.func_175647_a(MobEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 20.0, player.func_226278_cu_() - 20.0, player.func_226281_cx_() - 20.0, player.func_226277_ct_() + 20.0, player.func_226278_cu_() + 20.0, player.func_226281_cx_() + 20.0), null).stream().sorted(SpellActions.getEntityComparator(player)).collect(Collectors.toList());
        for (MobEntity mob : mobEntities) {
            List blacklistedMobs = (List)HLSpells.CONFIG.sapientMobsList.get();
            boolean predicate = false;
            for (String id : blacklistedMobs) {
                if (!id.equals(mob.func_200600_R().getRegistryName().toString())) continue;
                predicate = true;
            }
            if (predicate || !mob.field_70714_bg.func_220888_c().noneMatch(p -> p.func_220772_j() instanceof SpellBookLureGoal)) continue;
            mob.field_70714_bg.func_75776_a(0, (Goal)new SpellBookLureGoal(mob, 1.0));
        }
        return true;
    }

    public static boolean doRepel(PlayerEntity player, World world) {
        List mobEntities = world.func_175647_a(MobEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 15.0, player.func_226278_cu_() - 15.0, player.func_226281_cx_() - 15.0, player.func_226277_ct_() + 15.0, player.func_226278_cu_() + 15.0, player.func_226281_cx_() + 15.0), null).stream().sorted(SpellActions.getEntityComparator(player)).collect(Collectors.toList());
        for (MobEntity mob : mobEntities) {
            List blacklistedMobs = (List)HLSpells.CONFIG.sapientMobsList.get();
            boolean predicate = false;
            for (String id : blacklistedMobs) {
                if (!id.equals(mob.func_200600_R().getRegistryName().toString())) continue;
                predicate = true;
            }
            if (predicate || !mob.field_70714_bg.func_220888_c().noneMatch(p -> p.func_220772_j() instanceof SpellBookRepelGoal)) continue;
            mob.field_70714_bg.func_75776_a(0, (Goal)new SpellBookRepelGoal(mob, 1.2));
        }
        return true;
    }

    public static boolean doFlamingCircle(PlayerEntity player, World world) {
        List livingEntities = world.func_175647_a(LivingEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 6.0, player.func_226278_cu_() + 1.0, player.func_226281_cx_() - 6.0, player.func_226277_ct_() + 6.0, player.func_226278_cu_() - 1.0, player.func_226281_cx_() + 6.0), null).stream().sorted(SpellActions.getEntityComparator(player)).collect(Collectors.toList());
        if (++flameTimer % 10 == 0) {
            SpellActions.doEnchantParticleInterior(player, world);
            SpellActions.doOuterRingParticles(ParticleTypes.field_197631_x, player, world);
            flameTimer = 0;
        }
        for (LivingEntity entity : livingEntities) {
            if (entity == null || entity == player) continue;
            entity.func_230246_e_(player);
            entity.func_70015_d(1);
        }
        return true;
    }

    private static void doEnchantParticleInterior(PlayerEntity player, World world) {
        for (int x = -6; x <= 6; ++x) {
            for (int z = -6; z <= 6; ++z) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, player.func_226277_ct_() + (double)x + (double)world.field_73012_v.nextFloat(), player.func_226278_cu_() + 0.2, player.func_226281_cx_() + (double)z + (double)world.field_73012_v.nextFloat(), 0.0, 0.0, 0.0);
            }
        }
    }

    private static void doOuterRingParticles(BasicParticleType type, PlayerEntity player, World world) {
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 1.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 6.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_(), player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 6.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 1.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 6.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 1.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 5.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 2.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 5.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 2.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 4.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 3.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 4.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 3.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 3.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 4.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 3.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 4.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 2.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 5.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 2.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 5.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 1.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 6.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 1.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 6.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_(), 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 6.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 1.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 5.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 1.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 5.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 2.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 4.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 2.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 4.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 3.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 3.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 3.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 3.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 4.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 2.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 4.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 2.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 5.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 1.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 5.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() + 1.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 6.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_(), player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 6.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 1.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 6.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 1.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 5.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 2.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 5.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 2.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 4.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 3.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 4.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 3.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 3.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 4.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 3.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 4.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 2.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 5.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 2.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 5.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 1.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 6.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() + 1.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 6.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_(), 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 6.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 1.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 5.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 1.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 5.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 2.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 4.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 2.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 4.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 3.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 3.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 3.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 3.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 4.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 2.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 4.5, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 2.0, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 5.0, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)type, player.func_226277_ct_() - 1.5, player.func_226278_cu_() + 1.2, player.func_226281_cx_() - 5.5, 0.0, 0.0, 0.0);
    }

    public static boolean doProtectionCircle(PlayerEntity player, World world) {
        List entities = world.func_175647_a(Entity.class, new AxisAlignedBB(player.func_226277_ct_() - 6.0, player.func_226278_cu_() - 6.0, player.func_226281_cx_() - 6.0, player.func_226277_ct_() + 6.0, player.func_226278_cu_() + 6.0, player.func_226281_cx_() + 6.0), null).stream().sorted(SpellActions.getEntityComparator(player)).collect(Collectors.toList());
        for (Entity entity : entities) {
            if (entity instanceof PlayerEntity) continue;
            entity.func_213317_d(entity.func_70040_Z().func_216371_e().func_216372_d(0.3, 0.0, 0.3));
        }
        if (++protectionCircleTimer % 10 == 0) {
            SpellActions.doOuterRingParticles(ParticleTypes.field_197632_y, player, world);
        }
        return true;
    }

    public static boolean doLevitation(PlayerEntity player, World world) {
        if (player.func_213322_ci().field_72448_b >= 0.0) {
            EffectInstance effect = player.func_70660_b(Effects.field_188424_y);
            if (effect != null && effect.func_188418_e()) {
                player.getCapability(PlayerCapProvider.PLAYER_CAP).ifPresent(cap -> {
                    if (cap.getEffect() == null) {
                        cap.setEffect(effect.func_188419_a());
                        cap.setEffectDuration(effect.func_76459_b());
                        cap.setEffectAmplifier(effect.func_76458_c());
                    }
                });
            }
            player.func_195064_c(LEVITATION);
            for (int a = 0; a < 1; ++a) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, player.func_226277_ct_(), player.func_226278_cu_() - 1.0, player.func_226281_cx_(), 0.0, player.func_213322_ci().field_72448_b, 0.0);
            }
            return true;
        }
        return false;
    }

    public static boolean doArrowRain(PlayerEntity player, World world) {
        if (world.func_201670_d()) {
            if (arrowRainCloudSpawnBoolean) {
                SpellActions.doCloudParticles(player, world);
            }
            arrowRainCloudSpawnBoolean = false;
            if (++arrowRainCloudSpawnTimer % 15 == 0) {
                arrowRainCloudSpawnBoolean = true;
                arrowRainCloudSpawnTimer = 0;
            }
        } else if (++arrowRainArrowSpawnTimer % 15 == 0) {
            for (int i = 0; i < 5; ++i) {
                SpellActions.doArrowSpawn(player, world);
            }
            arrowRainArrowSpawnTimer = 0;
        }
        return true;
    }

    public static boolean doArrowSpawn(PlayerEntity player, World world) {
        ArrowEntity arrowEntity = new ArrowEntity(world, player.func_226277_ct_() + (world.field_73012_v.nextDouble() - 0.5) * (double)player.func_213311_cf(), player.func_226278_cu_() + 4.0, player.func_226281_cx_() + (world.field_73012_v.nextDouble() - 0.5) * (double)player.func_213311_cf());
        arrowEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 1.0f, 1.0f, 1.0f);
        arrowEntity.func_213293_j((double)(MathHelper.func_76134_b((float)((float)Math.toRadians(player.field_70177_z + 90.0f))) + (world.field_73012_v.nextFloat() - 0.5f) * player.func_213311_cf()), -0.6, (double)(MathHelper.func_76126_a((float)((float)Math.toRadians(player.field_70177_z + 90.0f))) + (world.field_73012_v.nextFloat() - 0.5f) * player.func_213311_cf()));
        world.func_217376_c((Entity)arrowEntity);
        return true;
    }

    public static void doCloudParticles(PlayerEntity player, World world) {
        for (int i = 0; i < 5; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_(), player.func_226278_cu_() + 5.0, player.func_226281_cx_(), 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_() + 0.45, player.func_226278_cu_() + 5.0, player.func_226281_cx_(), 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_() - 0.45, player.func_226278_cu_() + 5.0, player.func_226281_cx_(), 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_(), player.func_226278_cu_() + 5.0, player.func_226281_cx_() + 0.45, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_(), player.func_226278_cu_() + 5.0, player.func_226281_cx_() - 0.45, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_() + 0.45, player.func_226278_cu_() + 5.0, player.func_226281_cx_() + 0.45, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_() - 0.45, player.func_226278_cu_() + 5.0, player.func_226281_cx_() - 0.45, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_() + 0.45, player.func_226278_cu_() + 5.0, player.func_226281_cx_() - 0.45, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_() - 0.45, player.func_226278_cu_() + 5.0, player.func_226281_cx_() + 0.45, 0.0, 0.0, 0.0);
        }
    }

    public static boolean doHealingCircle(PlayerEntity player, World world) {
        List livingEntities = world.func_175647_a(LivingEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 6.0, player.func_226278_cu_() - 6.0, player.func_226281_cx_() - 6.0, player.func_226277_ct_() + 6.0, player.func_226278_cu_() + 6.0, player.func_226281_cx_() + 6.0), null).stream().sorted(SpellActions.getEntityComparator(player)).collect(Collectors.toList());
        if (++healingTimer % 10 == 0) {
            SpellActions.doEnchantParticleInterior(player, world);
            SpellActions.doOuterRingParticles(ParticleTypes.field_197632_y, player, world);
        }
        if (healingTimer % 20 == 0) {
            for (LivingEntity livingEntity : livingEntities) {
                SpellActions.doHealingCircleEntityParticle(livingEntity, world);
                if (livingEntity.func_70662_br()) {
                    livingEntity.func_230246_e_(player);
                    livingEntity.func_70097_a(DamageSource.field_76376_m, 1.0f);
                    continue;
                }
                if (!(livingEntity.func_110143_aJ() < livingEntity.func_110138_aP())) continue;
                livingEntity.func_70691_i(1.0f);
            }
            healingTimer = 0;
        }
        return true;
    }

    public static void doHealingCircleEntityParticle(LivingEntity livingEntity, World world) {
        double d0 = livingEntity.func_226277_ct_() + (double)world.field_73012_v.nextFloat();
        double d1 = livingEntity.func_226278_cu_() + (double)world.field_73012_v.nextFloat();
        double d2 = livingEntity.func_226281_cx_() + (double)world.field_73012_v.nextFloat();
        double d3 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
        double d4 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
        double d5 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
        if (livingEntity.func_70662_br()) {
            for (int i = 0; i < 5; ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, d3, d4, d5);
            }
        } else if (livingEntity.func_110143_aJ() < livingEntity.func_110138_aP()) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197633_z, d0 -= 0.5, d1 -= 0.3, d2 -= 0.5, d3, d4, d5);
        }
    }

    public static boolean doSpeed(PlayerEntity player, World world) {
        ModifiableAttributeInstance speedAttribute = player.func_110148_a(Attributes.field_233821_d_);
        if (speedAttribute != null && speedAttribute.func_111127_a(speedUUID) == null) {
            speedAttribute.func_233769_c_(speedModifier);
        }
        return true;
    }

    public static boolean doRespiration(PlayerEntity player, World world) {
        List players = world.func_175647_a(PlayerEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 10.0, player.func_226278_cu_() - 4.0, player.func_226281_cx_() - 10.0, player.func_226277_ct_() + 10.0, player.func_226278_cu_() + 4.0, player.func_226281_cx_() + 10.0), null).stream().sorted(SpellActions.getEntityComparator(player)).collect(Collectors.toList());
        ++airTimer;
        for (PlayerEntity p : players) {
            if (!p.func_204231_K() || airTimer != 10) continue;
            p.func_70050_g(p.func_70086_ai() + 15);
            if (p.func_70086_ai() > p.func_205010_bg()) {
                p.func_70050_g(p.func_205010_bg());
            }
            airTimer = 0;
        }
        return true;
    }

    public static void createFangsEntity(LivingEntity entity, World world, double x, double z, double y, float yaw, int warmup) {
        BlockPos blockpos = new BlockPos(x, y, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState state;
            VoxelShape voxelshape;
            BlockPos below;
            BlockState blockstate;
            if (!(blockstate = world.func_180495_p(below = blockpos.func_177977_b())).func_224755_d((IBlockReader)world, below, Direction.UP)) continue;
            if (!world.func_175623_d(blockpos) && !(voxelshape = (state = world.func_180495_p(blockpos)).func_196952_d((IBlockReader)world, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)(y + 1.0)) - 1);
        if (flag) {
            world.func_217376_c((Entity)new EvokerFangsEntity(world, x, (double)blockpos.func_177956_o() + d0, z, yaw, warmup, entity));
        }
    }

    public static void resetEffects(PlayerEntity playerEntity) {
        arrowRainArrowSpawnTimer = 0;
        arrowRainCloudSpawnTimer = 0;
        healingTimer = 0;
        protectionCircleTimer = 0;
        airTimer = 0;
        ModifiableAttributeInstance speedAttribute = playerEntity.func_110148_a(Attributes.field_233821_d_);
        if (speedAttribute != null && speedAttribute.func_111127_a(speedUUID) != null) {
            speedAttribute.func_111124_b(speedModifier);
        }
        EffectInstance instance = playerEntity.func_70660_b(Effects.field_188423_x);
        EffectInstance instance2 = playerEntity.func_70660_b(Effects.field_188424_y);
        EffectInstance instance3 = playerEntity.func_70660_b(Effects.field_204839_B);
        if (instance != null && !instance.func_188418_e() && instance.func_76458_c() >= 5) {
            playerEntity.func_195063_d(instance.func_188419_a());
        }
        if (instance2 != null && !instance2.func_188418_e() && instance2.func_76458_c() >= 5) {
            playerEntity.func_195063_d(instance2.func_188419_a());
        }
        if (instance3 != null && !instance3.func_188418_e() && instance3.func_76458_c() >= 5) {
            playerEntity.func_195063_d(instance3.func_188419_a());
        }
        playerEntity.getCapability(PlayerCapProvider.PLAYER_CAP).ifPresent(c -> {
            Effect effect = c.getEffect();
            if (effect != null) {
                playerEntity.func_195064_c(new EffectInstance(effect, c.getEffectDuration(), c.getEffectAmplifier()));
                c.resetEffect();
            }
        });
    }
}

