/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.util;

import com.divinity.hlspells.HLSpells;
import com.divinity.hlspells.init.ItemInit;
import com.divinity.hlspells.init.SpellInit;
import com.divinity.hlspells.items.capabilities.spellholdercap.ISpellHolder;
import com.divinity.hlspells.items.capabilities.spellholdercap.SpellHolderProvider;
import com.divinity.hlspells.spell.Spell;
import com.divinity.hlspells.spell.SpellType;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SpellUtils {
    public static Spell getSpell(ItemStack stack) {
        String id = stack.getCapability(SpellHolderProvider.SPELL_HOLDER_CAP).map(ISpellHolder::getCurrentSpell).orElse(null);
        if (id != null) {
            return SpellUtils.getSpellByID(id);
        }
        return (Spell)SpellInit.EMPTY.get();
    }

    public static Spell getSpellByID(@Nonnull String id) {
        Spell spell = (Spell)SpellInit.SPELLS_REGISTRY.get().getValue(new ResourceLocation(id));
        if (spell != null) {
            return spell;
        }
        return (Spell)SpellInit.EMPTY.get();
    }

    public static boolean canAddSpell(Item item, List<String> existingSpells) {
        if (item == ItemInit.SPELL_BOOK.get() && existingSpells.isEmpty()) {
            return true;
        }
        if (item == ItemInit.WAND.get() && existingSpells.size() < 3) {
            return true;
        }
        return item == ItemInit.STAFF.get() && existingSpells.size() < 6;
    }

    public static boolean checkXpReq(PlayerEntity player, Spell spell) {
        return player.func_184812_l_() || (Boolean)HLSpells.CONFIG.spellsUseXP.get() == false || player.field_71067_cb >= SpellUtils.getXpReq(player, spell);
    }

    public static int getTickDelay(PlayerEntity player, Spell spell) {
        int tickDelay = spell.getTickDelay();
        if (player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ItemInit.WIZARD_HAT.get()) {
            tickDelay += 4;
        }
        return tickDelay;
    }

    public static int getXpReq(PlayerEntity player, Spell spell) {
        int xpToRemove = spell.getXpCost();
        if (spell.getType() == SpellType.CAST && player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ItemInit.WIZARD_HAT.get()) {
            xpToRemove = (int)((double)xpToRemove * 0.7);
        }
        return xpToRemove;
    }
}

