/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.util;

import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class Util {
    public static void teleport(World world, BlockPos pos, BlockPos teleportPos, Entity entity) {
        double teleportXCo = teleportPos.func_177958_n();
        double teleportYCo = teleportPos.func_177956_o();
        double teleportZCo = teleportPos.func_177952_p();
        entity.func_70634_a(teleportXCo, teleportYCo, teleportZCo);
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_175089_a(teleportXCo, teleportYCo, teleportZCo, entity.field_70177_z, entity.field_70125_A, Collections.emptySet());
        }
        Util.teleportParticles(world, pos, 300);
        Util.teleportParticles(world, teleportPos, 300);
        world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.6f, 1.0f);
        world.func_184133_a(null, teleportPos, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.6f, 1.0f);
    }

    public static void teleportParticles(World world, BlockPos pos, int number) {
        for (int l = 0; l < number; ++l) {
            double d0 = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            double d1 = (float)pos.func_177956_o() + world.field_73012_v.nextFloat();
            double d2 = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            double d3 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
            double d4 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
            double d5 = ((double)world.field_73012_v.nextFloat() - 0.2) * 0.5;
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    public static RayTraceResult lookAt(Entity entity, double range, float height, boolean includeFluids) {
        Vector3d vector3d = entity.func_174824_e(height);
        Vector3d vector3d1 = entity.func_70676_i(height);
        Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * range, vector3d1.field_72448_b * range, vector3d1.field_72449_c * range);
        return entity.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d2, RayTraceContext.BlockMode.OUTLINE, includeFluids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, entity));
    }

    public static Entity rayTrace(World world, PlayerEntity player, double range) {
        AxisAlignedBB aabb;
        Vector3d cam1;
        Vector3d cam2;
        Vector3d pos = player.func_242282_l(0.0f);
        EntityRayTraceResult ray = Util.findEntity(world, player, pos, cam2 = (cam1 = player.func_70040_Z()).func_72441_c(cam1.field_72450_a * range, cam1.field_72448_b * range, cam1.field_72449_c * range), aabb = player.func_174813_aQ().func_216361_a(cam1.func_186678_a(range)).func_72314_b(1.0, 1.0, 1.0), null, range);
        if (ray != null && ray.func_216346_c() == RayTraceResult.Type.ENTITY) {
            return ray.func_216348_a() instanceof LivingEntity && !(ray.func_216348_a() instanceof PlayerEntity) ? ray.func_216348_a() : null;
        }
        return null;
    }

    private static EntityRayTraceResult findEntity(World world, PlayerEntity player, Vector3d pos, Vector3d look, AxisAlignedBB aabb, Predicate<Entity> filter, double range) {
        for (Entity entity1 : world.func_175674_a((Entity)player, aabb, filter)) {
            AxisAlignedBB mob = entity1.func_174813_aQ().func_186662_g(1.0);
            if (!Util.intersect(pos, look, mob, range)) continue;
            return new EntityRayTraceResult(entity1);
        }
        return null;
    }

    private static boolean intersect(Vector3d pos, Vector3d look, AxisAlignedBB mob, double range) {
        Vector3d invDir = new Vector3d(1.0 / look.field_72450_a, 1.0 / look.field_72448_b, 1.0 / look.field_72449_c);
        boolean signDirX = invDir.field_72450_a < 0.0;
        boolean signDirY = invDir.field_72448_b < 0.0;
        boolean signDirZ = invDir.field_72449_c < 0.0;
        Vector3d max = new Vector3d(mob.field_72336_d, mob.field_72337_e, mob.field_72334_f);
        Vector3d min = new Vector3d(mob.field_72340_a, mob.field_72338_b, mob.field_72339_c);
        Vector3d bbox = signDirX ? max : min;
        double tmin = (bbox.field_72450_a - pos.field_72450_a) * invDir.field_72450_a;
        bbox = signDirX ? min : max;
        double tmax = (bbox.field_72450_a - pos.field_72450_a) * invDir.field_72450_a;
        bbox = signDirY ? max : min;
        double tymin = (bbox.field_72448_b - pos.field_72448_b) * invDir.field_72448_b;
        bbox = signDirY ? min : max;
        double tymax = (bbox.field_72448_b - pos.field_72448_b) * invDir.field_72448_b;
        if (tmin > tymax || tymin > tmax) {
            return false;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        bbox = signDirZ ? max : min;
        double tzmin = (bbox.field_72449_c - pos.field_72449_c) * invDir.field_72449_c;
        bbox = signDirZ ? min : max;
        double tzmax = (bbox.field_72449_c - pos.field_72449_c) * invDir.field_72449_c;
        if (tmin > tzmax || tzmin > tmax) {
            return false;
        }
        if (tzmin > tmin) {
            tmin = tzmin;
        }
        if (tzmax < tmax) {
            tmax = tzmax;
        }
        return tmin < range && tmax > 0.0;
    }
}

