/*
 * Decompiled with CFR 0.152.
 */
package com.divinity.hlspells.villages;

import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hlspells")
public class StructureGen {
    private static final ResourceLocation mainMageHouse = new ResourceLocation("hlspells", "villages/mage_house_plains");

    public static void setupVillageWorldGen(DynamicRegistries dynamicRegistries) {
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "village/plains/houses", mainMageHouse, 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "village/savanna/houses", new ResourceLocation("hlspells", "villages/mage_house_savanna"), 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "village/desert/houses", new ResourceLocation("hlspells", "villages/mage_house_desert"), 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "village/taiga/houses", new ResourceLocation("hlspells", "villages/mage_house_taiga"), 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "village/snowy/houses", new ResourceLocation("hlspells", "villages/mage_house_snowy"), 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "repurposed_structures:village/badlands/houses", mainMageHouse, 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "repurposed_structures:village/birch/houses", mainMageHouse, 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "repurposed_structures:village/dark_forest/houses", mainMageHouse, 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "repurposed_structures:village/jungle/houses", mainMageHouse, 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "repurposed_structures:village/mountains/houses", mainMageHouse, 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "repurposed_structures:village/oak/houses", mainMageHouse, 4);
        StructureGen.addMageHouseToVillageConfig(dynamicRegistries, "repurposed_structures:village/swamp/houses", mainMageHouse, 4);
    }

    private static void addMageHouseToVillageConfig(DynamicRegistries dynamicRegistries, String villagePiece, ResourceLocation newHouseRL, int weight) {
        LegacySingleJigsawPiece piece = (LegacySingleJigsawPiece)JigsawPiece.func_242849_a((String)newHouseRL.toString()).apply(JigsawPattern.PlacementBehaviour.RIGID);
        JigsawPattern pool = dynamicRegistries.func_243612_b(Registry.field_243555_ax).func_241873_b(new ResourceLocation(villagePiece)).orElse(null);
        if (pool != null) {
            ArrayList<LegacySingleJigsawPiece> listOfPieces = new ArrayList<LegacySingleJigsawPiece>(pool.field_214953_e);
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add(piece);
            }
            pool.field_214953_e = listOfPieces;
        }
    }
}

