/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.registry;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AutoRegistry {
    protected static String MODID = null;
    private static boolean entityCreationRegistered = false;
    private static Map<EntityType<?>, Supplier<AttributeModifierMap.MutableAttribute>> entityAttributes = new HashMap();

    public static void init(String ModID) {
        MODID = ModID;
    }

    protected AutoRegistry() {
        try {
            for (Field field : ForgeRegistries.class.getDeclaredFields()) {
                Object fieldObj = field.get(null);
                if (!(fieldObj instanceof IForgeRegistry)) continue;
                Class clazz = ((IForgeRegistry)fieldObj).getRegistrySuperType();
                FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(clazz, e -> this.registerAllOfType(clazz, (RegistryEvent.Register)e));
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private final <T extends IForgeRegistryEntry<T>> void registerAllOfType(Class<IForgeRegistryEntry<?>> type, RegistryEvent.Register<T> event) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                IForgeRegistryEntry entry;
                Object obj = field.get(this);
                if (!type.isAssignableFrom(obj.getClass())) continue;
                if (obj instanceof EntityType && !entityCreationRegistered) {
                    FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEntityCreation);
                    entityCreationRegistered = true;
                }
                if ((entry = (IForgeRegistryEntry)obj) == null || entry.getRegistryName() == null) continue;
                event.getRegistry().register(entry);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder, IRenderFactory<? super T> renderFactory) {
        return AutoRegistry.registerEntity(name, builder, renderFactory, null);
    }

    protected static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder, IRenderFactory<? super T> renderFactory, Supplier<AttributeModifierMap.MutableAttribute> attributes) {
        if (MODID == null) {
            throw new RuntimeException("AutoRegistry was not initialized with mod id!");
        }
        ResourceLocation resourceLocation = new ResourceLocation(MODID, name);
        EntityType entityType = (EntityType)builder.func_206830_a(name).setRegistryName(resourceLocation);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)entityType, renderFactory);
        if (attributes != null) {
            entityAttributes.put(entityType, attributes);
        }
        return entityType;
    }

    protected static SoundEvent registerSound(String name) {
        if (MODID == null) {
            throw new RuntimeException("AutoRegistry was not initialized with mod id!");
        }
        return new SoundEvent(new ResourceLocation(MODID, name));
    }

    private void onEntityCreation(EntityAttributeCreationEvent event) {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                EntityType entityType;
                Object obj = field.get(this);
                if (!EntityType.class.isAssignableFrom(obj.getClass()) || !entityAttributes.containsKey(obj) || (entityType = (EntityType)obj) == null) continue;
                event.put(entityType, entityAttributes.get(obj).get().func_233813_a_());
            }
            catch (ClassCastException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

