/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

public final class Easing {
    public static float Ease(float a, float b, float t) {
        return Easing.Ease(a, b, t, EasingType.Quad);
    }

    public static float Ease(float a, float b, float t, EasingType type) {
        return Easing.Ease(a, b, t, type, EasingDirection.InOut);
    }

    public static float Ease(float a, float b, float t, EasingType type, EasingDirection direction) {
        switch (type) {
            default: {
                return Easing.None(a, b, t);
            }
            case Quad: {
                return Easing.Quad(a, b, t, direction);
            }
            case Cubic: 
        }
        return Easing.Cubic(a, b, t, direction);
    }

    private static float None(float a, float b, float t) {
        if (t < 0.5f) {
            return a;
        }
        return b;
    }

    private static float Quad(float a, float b, float t, EasingDirection direction) {
        switch (direction) {
            case In: {
                return a + (b - a) * t * t;
            }
            case Out: {
                return a + (b - a) * (1.0f - (1.0f - t) * (1.0f - t));
            }
        }
        t *= 2.0f;
        if (t < 1.0f) {
            return a + (b - a) * 0.5f * t * t;
        }
        return a + (a - b) * 0.5f * ((t -= 2.0f) * t - 2.0f);
    }

    private static float Cubic(float a, float b, float t, EasingDirection direction) {
        switch (direction) {
            case In: {
                return a + (b - a) * t * t * t;
            }
            case Out: {
                return a + (b - a) * (1.0f - (1.0f - t) * (1.0f - t) * (1.0f - t));
            }
        }
        t *= 2.0f;
        if (t < 1.0f) {
            return a + (b - a) * 0.5f * t * t * t;
        }
        return a + (b - a) * 0.5f * ((t -= 2.0f) * t * t + 2.0f);
    }

    public static enum EasingDirection {
        In,
        Out,
        InOut;

    }

    public static enum EasingType {
        None,
        Quad,
        Cubic;

    }
}

