/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.mixins;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tallestegg.illagersweararmor.IWAConfig;
import tallestegg.illagersweararmor.loot_tables.IWALootTables;

@Mixin(value={Vex.class})
public abstract class VexMixin
extends Monster {
    private static final Map<EquipmentSlot, ResourceLocation> NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS = (Map)Util.m_137469_((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.VEX_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.VEX_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.VEX_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.VEX_FEET);
    });

    protected VexMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="HEAD")}, method={"populateDefaultEquipmentSlots"})
    public void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty, CallbackInfo ci) {
        if (!IWAConfig.ArmorBlackList.contains(this.m_20078_())) {
            this.giveArmorNaturally(pRandom, pDifficulty);
        }
    }

    public List<ItemStack> getNaturalSpawnItemsFromLootTable(EquipmentSlot slot) {
        if (NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = this.f_19853_.m_7654_().m_129898_().m_79217_(NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.get(slot));
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)this).m_230911_(this.m_217043_());
            return loot.m_230922_(lootcontext$builder.m_78975_(IWALootTables.SLOT));
        }
        return null;
    }

    protected void giveArmorNaturally(RandomSource random, DifficultyInstance instance) {
        if (random.m_188501_() < 0.15f * instance.m_19057_()) {
            float difficultyChance = this.f_19853_.m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
            boolean flag = true;
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                if (equipmentslottype.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                if (!flag && random.m_188501_() < difficultyChance) break;
                flag = false;
                for (ItemStack stack : this.getNaturalSpawnItemsFromLootTable(equipmentslottype)) {
                    this.m_8061_(equipmentslottype, stack);
                }
            }
        }
    }
}

