/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.mixins;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import tallestegg.illagersweararmor.IWAConfig;
import tallestegg.illagersweararmor.IWAHelper;
import tallestegg.illagersweararmor.loot_tables.IWALootTables;

@Mixin(value={AbstractIllager.class})
public abstract class AbstractIllagerMixin
extends Raider {
    private static final Map<EquipmentSlot, ResourceLocation> EQUIPMENT_SLOT_ITEMS = (Map)Util.m_137469_((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.ILLAGER_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.ILLAGER_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.ILLAGER_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.ILLAGER_FEET);
    });

    protected AbstractIllagerMixin(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_34297_, DifficultyInstance p_34298_, MobSpawnType p_34299_, @Nullable SpawnGroupData p_34300_, @Nullable CompoundTag p_34301_) {
        if (!IWAConfig.ArmorBlackList.contains(this.m_20149_()) && IWAConfig.IllagerArmor) {
            if (this.m_37885_() != null && p_34299_ == MobSpawnType.EVENT) {
                this.giveArmorOnRaids();
            } else {
                this.giveArmorNaturally(p_34298_);
            }
        }
        return super.m_6518_(p_34297_, p_34298_, p_34299_, p_34300_, p_34301_);
    }

    public void giveArmorOnRaids() {
        float difficultyChance = this.f_19853_.m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
        int illagerWaves = this.m_37885_().m_37771_();
        float waveChances = IWAHelper.getWaveArmorChances(illagerWaves);
        if (this.m_217043_().m_188501_() < waveChances) {
            boolean flag = true;
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                if (equipmentslottype.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                if (!flag && this.f_19796_.m_188501_() < difficultyChance) break;
                flag = false;
                for (ItemStack stack : this.getItemsFromLootTable(equipmentslottype)) {
                    this.m_8061_(equipmentslottype, stack);
                }
            }
        }
    }

    public List<ItemStack> getItemsFromLootTable(EquipmentSlot slot) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = this.f_19853_.m_7654_().m_129898_().m_79217_(EQUIPMENT_SLOT_ITEMS.get(slot));
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)this).m_230911_(this.m_217043_());
            return loot.m_230922_(lootcontext$builder.m_78975_(IWALootTables.SLOT));
        }
        return null;
    }

    protected void giveArmorNaturally(DifficultyInstance p_21383_) {
        if (this.f_19796_.m_188501_() < 0.15f * p_21383_.m_19057_()) {
            float f;
            int i = this.f_19796_.m_188503_(2);
            float f2 = f = this.f_19853_.m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
            if (this.f_19796_.m_188501_() < 0.095f) {
                ++i;
            }
            if (this.f_19796_.m_188501_() < 0.095f) {
                ++i;
            }
            if (this.f_19796_.m_188501_() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                Item item;
                if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.m_6844_(equipmentslot);
                if (!flag && this.f_19796_.m_188501_() < f) break;
                flag = false;
                if (!itemstack.m_41619_() || (item = AbstractIllagerMixin.m_21412_((EquipmentSlot)equipmentslot, (int)i)) == null) continue;
                this.m_8061_(equipmentslot, new ItemStack((ItemLike)item));
            }
        }
    }
}

