/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tallestegg.illagersweararmor.IWAConfig;
import tallestegg.illagersweararmor.IWAHelper;
import tallestegg.illagersweararmor.loot_tables.IWALootTables;

@Mod.EventBusSubscriber(modid="zillagersweararmor")
public class IWASpawnEvents {
    private static final Map<EquipmentSlot, ResourceLocation> VEX_NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS = (Map)Util.m_137469_((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.VEX_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.VEX_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.VEX_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.VEX_FEET);
    });
    private static final Map<EquipmentSlot, ResourceLocation> EQUIPMENT_SLOT_ITEMS = (Map)Util.m_137469_((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.ILLAGER_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.ILLAGER_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.ILLAGER_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.ILLAGER_FEET);
    });
    private static final Map<EquipmentSlot, ResourceLocation> NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS = (Map)Util.m_137469_((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.NATURAL_SPAWN_ILLAGER_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.NATURAL_SPAWN_ILLAGER_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.NATURAL_SPAWN_ILLAGER_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.NATURAL_SPAWN_ILLAGER_FEET);
    });

    @SubscribeEvent
    public static void finalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        MobSpawnType spawnType = event.getSpawnType();
        RandomSource rSource = event.getLevel().m_213780_();
        Mob entity = event.getEntity();
        if (!IWAConfig.ArmorBlackList.contains(entity.m_20078_())) {
            Mob mob;
            if (entity instanceof Raider) {
                Raider raider = (Raider)entity;
                if ((entity instanceof AbstractIllager || entity instanceof Witch) && IWAConfig.IllagerArmor) {
                    if (raider.m_37885_() != null && spawnType == MobSpawnType.EVENT) {
                        IWASpawnEvents.giveArmorOnRaids(raider, rSource);
                    } else {
                        IWASpawnEvents.giveArmorNaturally(raider, rSource, event.getDifficulty());
                    }
                }
            }
            if ((mob = event.getEntity()) instanceof Vex) {
                Vex vex = (Vex)mob;
                IWASpawnEvents.giveArmorNaturally(vex, rSource, event.getDifficulty());
            }
        }
    }

    public static void giveArmorOnRaids(Raider raider, RandomSource pRandom) {
        float difficultyChance = raider.m_9236_().m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
        int illagerWaves = raider.m_37885_().m_37771_();
        float waveChances = IWAHelper.getWaveArmorChances(illagerWaves);
        if (pRandom.m_188501_() < waveChances) {
            boolean flag = true;
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                if (!flag && pRandom.m_188501_() < difficultyChance) break;
                flag = false;
                if (IWASpawnEvents.getItemsFromLootTable(raider, equipmentslottype) == null) continue;
                for (ItemStack stack : IWASpawnEvents.getItemsFromLootTable(raider, equipmentslottype)) {
                    raider.m_8061_(equipmentslottype, stack);
                }
            }
        }
    }

    public static List<ItemStack> getItemsFromLootTable(Raider raider, EquipmentSlot slot) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = raider.m_9236_().m_7654_().m_278653_().m_278676_(EQUIPMENT_SLOT_ITEMS.get(slot));
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)raider.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)raider);
            return loot.m_287195_(lootcontext$builder.m_287235_(IWALootTables.SLOT));
        }
        return null;
    }

    public static List<ItemStack> getNaturalSpawnItemsFromLootTable(Raider raider, EquipmentSlot slot) {
        if (NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = raider.m_9236_().m_7654_().m_278653_().m_278676_(NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.get(slot));
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)raider.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)raider);
            return loot.m_287195_(lootcontext$builder.m_287235_(IWALootTables.SLOT));
        }
        return null;
    }

    public static List<ItemStack> getVexNaturalSpawnItemsFromLootTable(Vex vex, EquipmentSlot slot) {
        if (NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = vex.m_9236_().m_7654_().m_278653_().m_278676_(VEX_NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.get(slot));
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)vex.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)vex);
            return loot.m_287195_(lootcontext$builder.m_287235_(IWALootTables.SLOT));
        }
        return null;
    }

    public static void giveArmorNaturally(Raider raider, RandomSource random, DifficultyInstance instance) {
        if (random.m_188501_() < 0.15f * instance.m_19057_()) {
            float difficultyChance = raider.m_9236_().m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
            boolean flag = true;
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                if (equipmentslottype.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                if (!flag && random.m_188501_() < difficultyChance) break;
                flag = false;
                for (ItemStack stack : IWASpawnEvents.getNaturalSpawnItemsFromLootTable(raider, equipmentslottype)) {
                    raider.m_8061_(equipmentslottype, stack);
                }
            }
        }
    }

    public static void giveArmorNaturally(Vex vex, RandomSource random, DifficultyInstance instance) {
        if (random.m_188501_() < 0.15f * instance.m_19057_()) {
            float difficultyChance = vex.m_9236_().m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
            boolean flag = true;
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                if (equipmentslottype.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                if (!flag && random.m_188501_() < difficultyChance) break;
                flag = false;
                for (ItemStack stack : IWASpawnEvents.getVexNaturalSpawnItemsFromLootTable(vex, equipmentslottype)) {
                    vex.m_8061_(equipmentslottype, stack);
                }
            }
        }
    }
}

