/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.client.renderer.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.VexModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class VexArmorLayer
extends RenderLayer<Vex, VexModel> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final HumanoidModel innerModel;
    private final HumanoidModel outerModel;

    public VexArmorLayer(RenderLayerParent<Vex, VexModel> pRenderer, EntityModelSet modelSets) {
        super(pRenderer);
        this.innerModel = new HumanoidModel(modelSets.m_171103_(ModelLayers.f_171208_));
        this.outerModel = new HumanoidModel(modelSets.m_171103_(ModelLayers.f_171261_));
    }

    public void copyPropertiesTo(HumanoidModel pModel) {
        pModel.f_102808_.m_104315_(((VexModel)this.m_117386_()).m_142109_().m_171324_("head"));
        pModel.f_102810_.m_104315_(((VexModel)this.m_117386_()).m_142109_().m_171324_("body"));
        pModel.f_102811_.m_104315_(((VexModel)this.m_117386_()).m_142109_().m_171324_("body").m_171324_("right_arm"));
        pModel.f_102812_.m_104315_(((VexModel)this.m_117386_()).m_142109_().m_171324_("body").m_171324_("left_arm"));
        pModel.f_102813_.m_104315_(((VexModel)this.m_117386_()).m_142109_().m_171324_("body"));
        pModel.f_102814_.m_104315_(((VexModel)this.m_117386_()).m_142109_().m_171324_("body"));
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, Vex pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.copyPropertiesTo(this.innerModel);
        this.copyPropertiesTo(this.outerModel);
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.CHEST, pPackedLight, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.LEGS, pPackedLight, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.FEET, pPackedLight, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.HEAD, pPackedLight, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack pPoseStack, MultiBufferSource pBuffer, Vex pLivingEntity, EquipmentSlot pSlot, int p_117123_, HumanoidModel pModel) {
        ItemStack itemstack = pLivingEntity.m_6844_(pSlot);
        if (itemstack.m_41720_() instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)itemstack.m_41720_();
            if (armoritem.m_40402_() == pSlot) {
                this.setPartVisibility(pModel, pSlot);
                Model model = this.getArmorModelHook(pLivingEntity, itemstack, pSlot, pModel);
                boolean flag = this.usesInnerModel(pSlot);
                boolean flag1 = itemstack.m_41790_();
                if (armoritem instanceof DyeableLeatherItem) {
                    int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, model, f, f1, f2, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, null));
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, "overlay"));
                } else {
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, null));
                }
            }
            if (armoritem.m_40402_() == EquipmentSlot.CHEST) {
                pPoseStack.m_85836_();
                pPoseStack.m_85849_();
            }
        }
    }

    protected void setPartVisibility(HumanoidModel pModel, EquipmentSlot pSlot) {
        pModel.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                pModel.f_102808_.f_104207_ = true;
                pModel.f_102809_.f_104207_ = true;
                pModel.f_102808_.f_233553_ = 0.8f;
                pModel.f_102808_.f_233554_ = 0.8f;
                pModel.f_102808_.f_233555_ = 0.8f;
                pModel.f_102808_.f_104201_ -= 13.0f;
                break;
            }
            case CHEST: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102811_.f_104207_ = true;
                pModel.f_102812_.f_104207_ = true;
                pModel.f_102811_.f_104201_ -= -11.5f;
                pModel.f_102811_.f_104202_ += 0.25f;
                pModel.f_102811_.f_104200_ -= 3.0f;
                pModel.f_102811_.f_233553_ = 0.8f;
                pModel.f_102811_.f_233554_ = 0.8f;
                pModel.f_102811_.f_233555_ = 0.8f;
                pModel.f_102812_.f_233553_ = 0.8f;
                pModel.f_102812_.f_233554_ = 0.8f;
                pModel.f_102812_.f_233555_ = 0.8f;
                pModel.f_102812_.f_104201_ -= -11.5f;
                pModel.f_102812_.f_104202_ += 0.25f;
                pModel.f_102812_.f_104200_ -= -3.0f;
                pModel.f_102810_.f_233553_ = 0.8f;
                pModel.f_102810_.f_233554_ = 0.8f;
                pModel.f_102810_.f_233555_ = 0.8f;
                pModel.f_102810_.f_104201_ -= 9.0f;
                break;
            }
            case LEGS: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
                pModel.f_102810_.f_104201_ -= 6.0f;
                pModel.f_102810_.f_104202_ -= -0.6f;
                pModel.f_102810_.f_233553_ = 0.6f;
                pModel.f_102810_.f_233554_ = 0.6f;
                pModel.f_102810_.f_233555_ = 0.75f;
                pModel.f_102813_.f_233553_ = 0.6f;
                pModel.f_102813_.f_233554_ = 0.6f;
                pModel.f_102813_.f_233555_ = 0.7f;
                pModel.f_102813_.f_104201_ = 20.0f;
                pModel.f_102813_.f_104200_ = -1.5f;
                pModel.f_102813_.f_104202_ = 1.5f;
                pModel.f_102814_.f_233553_ = 0.6f;
                pModel.f_102814_.f_233554_ = 0.6f;
                pModel.f_102814_.f_233555_ = 0.7f;
                pModel.f_102814_.f_104201_ = 20.0f;
                pModel.f_102814_.f_104200_ = 1.5f;
                pModel.f_102814_.f_104202_ = 1.5f;
                break;
            }
            case FEET: {
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
                pModel.f_102813_.f_104201_ = 20.0f;
                pModel.f_102813_.f_233553_ = 0.6f;
                pModel.f_102813_.f_233554_ = 0.6f;
                pModel.f_102813_.f_233555_ = 0.7f;
                pModel.f_102813_.f_104200_ = -1.5f;
                pModel.f_102813_.f_104202_ = 1.5f;
                pModel.f_102814_.f_233553_ = 0.6f;
                pModel.f_102814_.f_233554_ = 0.6f;
                pModel.f_102814_.f_233555_ = 0.7f;
                pModel.f_102814_.f_104201_ = 20.0f;
                pModel.f_102814_.f_104200_ = 1.5f;
                pModel.f_102814_.f_104202_ = 1.5f;
            }
        }
    }

    private void renderModel(PoseStack pPoseStack, MultiBufferSource pBuffer, int p_117109_, ArmorItem p_117110_, boolean p_117111_, HumanoidModel pModel, boolean p_117113_, float p_117114_, float p_117115_, float p_117116_, @Nullable String p_117117_) {
        this.renderModel(pPoseStack, pBuffer, p_117109_, p_117111_, (Model)pModel, p_117114_, p_117115_, p_117116_, this.getArmorLocation(p_117110_, p_117113_, p_117117_));
    }

    private void renderModel(PoseStack pPoseStack, MultiBufferSource pBuffer, int p_117109_, boolean p_117111_, Model pModel, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)pBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        pModel.m_7695_(pPoseStack, vertexconsumer, p_117109_, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    private HumanoidModel getArmorModel(EquipmentSlot pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.LEGS;
    }

    @Deprecated
    private ResourceLocation getArmorLocation(ArmorItem p_117081_, boolean p_117082_, @Nullable String p_117083_) {
        String s = "textures/models/armor/" + p_117081_.m_40401_().m_6082_() + "_layer_" + (p_117082_ ? 2 : 1) + (String)(p_117083_ == null ? "" : "_" + p_117083_) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(Vex entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

