/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Witch;
import tallestegg.illagersweararmor.IWAClientEvents;
import tallestegg.illagersweararmor.client.model.IllagerArmorModel;
import tallestegg.illagersweararmor.client.model.WitchBipedModel;
import tallestegg.illagersweararmor.client.renderer.layers.WitchBipedItemLayer;

public class WitchBipedRenderer<T extends Witch>
extends MobRenderer<T, WitchBipedModel<T>> {
    private static final ResourceLocation WITCH_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/witch.png");

    public WitchBipedRenderer(EntityRendererProvider.Context builder) {
        super(builder, new WitchBipedModel(builder.bakeLayer(IWAClientEvents.WITCH)), 0.5f);
        this.addLayer((RenderLayer)new WitchBipedItemLayer(this, builder.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, builder.getModelSet(), builder.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, builder.getModelSet()));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new IllagerArmorModel(builder.bakeLayer(IWAClientEvents.BIPEDILLAGER_ARMOR_INNER_LAYER)), new IllagerArmorModel(builder.bakeLayer(IWAClientEvents.BIPEDILLAGER_ARMOR_OUTER_LAYER)), builder.getModelManager()));
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        ((WitchBipedModel)this.model).setHoldingItem(!pEntity.getMainHandItem().isEmpty());
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return WITCH_LOCATION;
    }

    protected void scale(T pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        float f = 0.9375f;
        pMatrixStack.scale(0.9375f, 0.9375f, 0.9375f);
    }
}

