/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.inventoryspam;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gigaherz.inventoryspam.PlayerContainerHooks;
import gigaherz.inventoryspam.config.ConfigData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ScrollingOverlay
extends GuiComponent
implements IIngameOverlay {
    private static final ScrollingOverlay INSTANCE = new ScrollingOverlay();
    private static final int TTL = 240;
    private static final int FADE = 40;
    private int hard_limit;
    private ResourceKey<Level> dim;
    private int dimLoadTicks;
    private ItemStack[] previous;
    private Player playerEntity;
    private ItemStack previousInCursor = ItemStack.f_41583_;
    private final List<ChangeInfo> changeEntries = Lists.newArrayList();
    private final Minecraft mc = Minecraft.m_91087_();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.CHAT_PANEL_ELEMENT, (String)"inventoryspam.overlay", (IIngameOverlay)INSTANCE);
    }

    @SubscribeEvent
    public void clientLogOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.changeEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTicks, int width, int height) {
        int y;
        int x;
        int number;
        int rectWidth;
        int n;
        int rightMargin;
        if (!ConfigData.showItemAdditions && !ConfigData.showItemRemovals) {
            return;
        }
        width = (int)((float)width / ConfigData.drawScale);
        height = (int)((float)height / ConfigData.drawScale);
        Font fontRenderer = this.mc.f_91062_;
        ItemRenderer itemRenderer = this.mc.m_91291_();
        int iconSize = (int)(16.0f * ConfigData.iconScale);
        int n2 = rightMargin = ConfigData.drawIcon ? 2 + iconSize : 0;
        if (ConfigData.drawIcon) {
            Objects.requireNonNull(fontRenderer);
            n = Math.max(0, (iconSize - 9) / 2);
        } else {
            n = 0;
        }
        int topMargin1 = 2 + n;
        Objects.requireNonNull(fontRenderer);
        int topMargin2 = 1 + Math.max(0, -(iconSize - 9) / 2);
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9;
        if (ConfigData.drawIcon) {
            lineHeight = Math.max(2 + iconSize, lineHeight);
        }
        this.hard_limit = height / lineHeight;
        ArrayList computedStrings = Lists.newArrayList();
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            if (this.changeEntries.size() == 0) {
                return;
            }
            rectWidth = this.computeStrings(computedStrings, fontRenderer);
            number = computedStrings.size();
            if (number == 0) {
                return;
            }
        }
        matrixStack.m_85836_();
        matrixStack.m_85841_(ConfigData.drawScale, ConfigData.drawScale, 1.0f);
        rectWidth += rightMargin;
        int rectHeight = lineHeight * number;
        int align = switch (ConfigData.drawPosition) {
            default -> {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                yield 1;
            }
            case ConfigData.DrawPosition.Bottom -> {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                yield 0;
            }
            case ConfigData.DrawPosition.BottomLeft -> {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                yield -1;
            }
            case ConfigData.DrawPosition.Left -> {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                yield -1;
            }
            case ConfigData.DrawPosition.TopLeft -> {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                yield -1;
            }
            case ConfigData.DrawPosition.Top -> {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                yield 0;
            }
            case ConfigData.DrawPosition.TopRight -> {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                yield 1;
            }
            case ConfigData.DrawPosition.Right -> {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                yield 1;
            }
            case ConfigData.DrawPosition.Center -> {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                yield 0;
            }
        };
        ScrollingOverlay.m_93172_((PoseStack)matrixStack, (int)(x - 2), (int)(y - 2), (int)(x + rectWidth + 4), (int)(y + rectHeight + 4), (int)Integer.MIN_VALUE);
        for (Triple e : computedStrings) {
            ChangeInfo change = (ChangeInfo)e.getLeft();
            String[] strings = (String[])e.getMiddle();
            int fade = (Integer)e.getRight();
            int w = 0;
            int[] widths = new int[strings.length];
            for (int n3 = 0; n3 < strings.length; ++n3) {
                String str = strings[n3];
                int wn = widths[n3] = fontRenderer.m_92895_(str);
                w += wn;
            }
            int forcedFade = ConfigData.fadeLimit > 0 ? fade * 255 / (ConfigData.fadeLimit + 2) : 255;
            int ttlFade = change.ttl * 255 / 40;
            int alpha = Math.min(255, Math.min(forcedFade, ttlFade));
            int color = alpha << 24 | (change.mode == ChangeMode.Obtained ? 0x7FFF7F : 0xFF5F5F);
            int leftMargin = 0;
            switch (align) {
                case -1: {
                    leftMargin = 2;
                    break;
                }
                case 0: {
                    leftMargin = (rectWidth - w - rightMargin) / 2;
                    break;
                }
                case 1: {
                    leftMargin = rectWidth - w - rightMargin;
                }
            }
            RenderSystem.m_69478_();
            int wAcc = 0;
            for (int n4 = 0; n4 < strings.length; ++n4) {
                fontRenderer.m_92750_(matrixStack, strings[n4], (float)(x + leftMargin + wAcc), (float)(y + topMargin1), color);
                wAcc += widths[n4];
            }
            if (ConfigData.drawIcon) {
                PoseStack viewModelPose = RenderSystem.m_157191_();
                viewModelPose.m_85836_();
                viewModelPose.m_166854_(matrixStack.m_85850_().m_85861_());
                viewModelPose.m_85837_((double)(x + 2 + w + leftMargin), (double)(y + topMargin2), 0.0);
                viewModelPose.m_85841_(ConfigData.iconScale, ConfigData.iconScale, 1.0f);
                RenderSystem.m_157182_();
                itemRenderer.m_115203_(change.item.stack, 0, 0);
                itemRenderer.m_115174_(fontRenderer, change.item.stack, 0, 0, null);
                viewModelPose.m_85849_();
                RenderSystem.m_157182_();
            }
            y += lineHeight;
        }
        matrixStack.m_85849_();
    }

    private int computeStrings(List<Triple<ChangeInfo, String[], Integer>> computedStrings, Font font) {
        int rectWidth = 0;
        int itemsToShow = Math.min(Math.min(this.hard_limit, ConfigData.softLimit + ConfigData.fadeLimit), this.changeEntries.size());
        int offset = Math.max(0, this.changeEntries.size() - itemsToShow);
        int fadeOffset = this.changeEntries.size() - ConfigData.softLimit - ConfigData.fadeLimit;
        for (int i = offset; i < this.changeEntries.size(); ++i) {
            ChangeInfo change = this.changeEntries.get(i);
            String[] parts = this.getChangeStrings(change);
            int w = Arrays.stream(parts).mapToInt(arg_0 -> ((Font)font).m_92895_(arg_0)).sum();
            rectWidth = Math.max(rectWidth, w);
            computedStrings.add((Triple<ChangeInfo, String[], Integer>)Triple.of((Object)change, (Object)parts, (Object)Math.min(ConfigData.fadeLimit + 2, 1 + i - fadeOffset)));
        }
        return rectWidth;
    }

    private String[] getChangeStrings(ChangeInfo change) {
        String mode = change.mode == ChangeMode.Obtained ? "+" : "-";
        String s1 = String.format("%s%d", mode, change.count);
        if (ConfigData.drawName) {
            String name = change.item.stack.m_41786_().getString();
            Object italics = change.item.stack.m_41788_() ? "" + ChatFormatting.ITALIC : "";
            String s2 = String.format("%s%s", italics, name);
            return new String[]{s1, " ", s2};
        }
        return new String[]{s1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!ConfigData.showItemAdditions && !ConfigData.showItemRemovals) {
            return;
        }
        LocalPlayer player = this.mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player != this.playerEntity || player.f_36095_ != PlayerContainerHooks.getOriginalContainer()) {
            PlayerContainerHooks.setTarget((AbstractContainerMenu)player.f_36095_, () -> {
                this.previous = null;
                this.dimLoadTicks = 0;
            });
            this.playerEntity = player;
            this.previous = null;
        }
        if (player.f_19853_.m_46472_() != this.dim) {
            this.previous = null;
            this.dimLoadTicks = 50;
            this.dim = player.f_19853_.m_46472_();
        }
        if (this.dimLoadTicks > 0) {
            this.previous = null;
            --this.dimLoadTicks;
            return;
        }
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            this.changeEntries.forEach(e -> --e.ttl);
            while (this.changeEntries.size() > this.hard_limit) {
                this.changeEntries.remove(0);
            }
            this.changeEntries.removeIf(e -> e.ttl <= 0 || e.count == 0);
        }
        Inventory inventory = player.m_150109_();
        if (this.previous == null || this.previous.length != inventory.m_6643_()) {
            this.previous = new ItemStack[inventory.m_6643_()];
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                this.previous[i] = ScrollingOverlay.safeCopy(inventory.m_8020_(i));
            }
            AbstractContainerMenu currentMenu = player.f_36096_;
            this.previousInCursor = currentMenu.m_142621_();
            return;
        }
        ArrayList changes = Lists.newArrayList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack old = this.previous[i];
            ItemStack stack = inventory.m_8020_(i);
            if (this.isChangeMeaningful(old, stack)) {
                changes.add(Pair.of((Object)old, (Object)stack));
            }
            this.previous[i] = stack.m_41777_();
        }
        AbstractContainerMenu currentMenu = player.f_36096_;
        ItemStack stackInCursor = currentMenu.m_142621_();
        if (this.isChangeMeaningful(stackInCursor, this.previousInCursor)) {
            changes.add(Pair.of((Object)this.previousInCursor, (Object)stackInCursor));
        }
        this.previousInCursor = stackInCursor.m_41777_();
        if (changes.size() == 0) {
            return;
        }
        ArrayList changeList = Lists.newArrayList();
        changes.forEach(change -> {
            boolean rightEmpty;
            ItemStack left = (ItemStack)change.getLeft();
            boolean leftEmpty = left.m_41613_() <= 0;
            ItemStack right = (ItemStack)change.getRight();
            boolean bl = rightEmpty = right.m_41613_() <= 0;
            if (ScrollingOverlay.areSameishItem(left, right)) {
                if (!this.isBlacklisted(left)) {
                    int difference = right.m_41613_() - left.m_41613_();
                    if (difference > 0) {
                        this.obtainedItem(changeList, left, difference);
                    } else if (difference < 0) {
                        this.lostItem(changeList, left, -difference);
                    }
                }
            } else {
                if (!leftEmpty && !this.isBlacklisted(left)) {
                    this.lostItem(changeList, left, left.m_41613_());
                }
                if (!rightEmpty && !this.isBlacklisted(right)) {
                    this.obtainedItem(changeList, right, right.m_41613_());
                }
            }
        });
        changeList.removeIf(e -> e.count == 0);
        if (changeList.size() > 0) {
            List<ChangeInfo> list2 = this.changeEntries;
            synchronized (list2) {
                for (ChangeInfo info : changeList) {
                    if (info.count == 0) continue;
                    this.accumulate(this.changeEntries, info.item.stack, info.mode, info.count, false);
                }
            }
        }
    }

    private boolean isBlacklisted(ItemStack left) {
        return ConfigData.ignoreItems.contains(left.m_41720_().getRegistryName().toString());
    }

    private boolean isChangeMeaningful(ItemStack a, ItemStack b) {
        if (a.m_41613_() != b.m_41613_()) {
            return true;
        }
        if (a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b)) {
            return false;
        }
        if (a.m_41720_() == b.m_41720_() && ConfigData.ignoreSubitemChanges.contains(a.m_41720_().getRegistryName().toString())) {
            return false;
        }
        return !ItemStack.m_41758_((ItemStack)a, (ItemStack)b);
    }

    private static boolean areLooselyTheSame(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.m_41758_((ItemStack)a, (ItemStack)b);
    }

    private static boolean areSameishItem(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.m_41746_((ItemStack)a, (ItemStack)b) && ItemStack.m_41658_((ItemStack)a, (ItemStack)b);
    }

    private static boolean isStackEmpty(ItemStack stack) {
        return stack.m_41613_() <= 0;
    }

    private static ItemStack safeCopy(ItemStack stack) {
        return stack.m_41777_();
    }

    private void obtainedItem(List<ChangeInfo> changeList, ItemStack item, int added) {
        if (added <= 0 || !ConfigData.showItemAdditions) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Obtained, added, true);
    }

    private void lostItem(List<ChangeInfo> changeList, ItemStack item, int removed) {
        if (removed <= 0 || !ConfigData.showItemRemovals) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Lost, removed, true);
    }

    private void accumulate(List<ChangeInfo> changeList, ItemStack stack, ChangeMode mode, int count, boolean isLocal) {
        ChangeInfo info;
        if (stack.m_41613_() <= 0) {
            return;
        }
        ComparableItem name = new ComparableItem(stack);
        ChangeInfo changeInfo = info = isLocal ? (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name)).findFirst().orElse(null) : (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name) && e.mode == mode).findFirst().orElse(null);
        if (info == null) {
            info = new ChangeInfo(name, mode, count, 240);
            changeList.add(info);
            return;
        }
        if (info.mode != mode) {
            count = -count;
        }
        info.count += count;
        info.ttl = 240;
        if (info.count < 0) {
            info.count = -info.count;
            info.mode = info.mode == ChangeMode.Lost ? ChangeMode.Obtained : ChangeMode.Lost;
        }
    }

    private static class ChangeInfo {
        final ComparableItem item;
        ChangeMode mode;
        int count;
        int ttl;

        ChangeInfo(ComparableItem item, ChangeMode mode, int count, int ttl) {
            this.item = item;
            this.mode = mode;
            this.count = count;
            this.ttl = ttl;
        }
    }

    private static enum ChangeMode {
        Obtained,
        Lost;

    }

    private static class ComparableItem {
        ItemStack stack;

        ComparableItem(ItemStack stack) {
            this.stack = stack.m_41777_();
            this.stack.m_41764_(1);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComparableItem)) {
                return false;
            }
            ItemStack stack = ((ComparableItem)obj).stack;
            return ScrollingOverlay.areSameishItem(stack, this.stack);
        }

        public int hashCode() {
            return this.stack.m_41720_().hashCode();
        }
    }
}

