/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.inventoryspam;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gigaherz.inventoryspam.PlayerContainerHooks;
import gigaherz.inventoryspam.config.ConfigData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@EventBusSubscriber(value={Dist.CLIENT}, modid="inventoryspam", bus=EventBusSubscriber.Bus.MOD)
public class ScrollingOverlay
implements LayeredDraw.Layer {
    private static final int TTL = 240;
    private static final int FADE = 40;
    private int hard_limit;
    private ResourceKey<Level> dim;
    private int dimLoadTicks;
    private ItemStack[] previous;
    private Player playerEntity;
    private ItemStack previousInCursor = ItemStack.EMPTY;
    private final List<ChangeInfo> changeEntries = Lists.newArrayList();
    private final Minecraft mc = Minecraft.getInstance();

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CHAT, new ResourceLocation("inventoryspam", "inventoryspam.overlay"), (LayeredDraw.Layer)new ScrollingOverlay());
    }

    public ScrollingOverlay() {
        NeoForge.EVENT_BUS.addListener(this::clientLogOut);
        NeoForge.EVENT_BUS.addListener(this::clientTick);
    }

    public void clientLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.changeEntries.clear();
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics graphics, float partialTicks) {
        int y;
        int x;
        int number;
        int rectWidth;
        int n;
        int rightMargin;
        if (!ConfigData.showItemAdditions && !ConfigData.showItemRemovals) {
            return;
        }
        int width = (int)((float)graphics.guiWidth() / ConfigData.drawScale);
        int height = (int)((float)graphics.guiHeight() / ConfigData.drawScale);
        Font font = this.mc.font;
        ItemRenderer itemRenderer = this.mc.getItemRenderer();
        int iconSize = (int)(16.0f * ConfigData.iconScale);
        int n2 = rightMargin = ConfigData.drawIcon ? 2 + iconSize : 0;
        if (ConfigData.drawIcon) {
            Objects.requireNonNull(font);
            n = Math.max(0, (iconSize - 9) / 2);
        } else {
            n = 0;
        }
        int topMargin1 = 2 + n;
        Objects.requireNonNull(font);
        int topMargin2 = 1 + Math.max(0, -(iconSize - 9) / 2);
        Objects.requireNonNull(font);
        int lineHeight = 9;
        if (ConfigData.drawIcon) {
            lineHeight = Math.max(2 + iconSize, lineHeight);
        }
        this.hard_limit = height / lineHeight;
        ArrayList labels = Lists.newArrayList();
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            if (this.changeEntries.size() == 0) {
                return;
            }
            rectWidth = this.computeLabel(labels, font);
            number = labels.size();
            if (number == 0) {
                return;
            }
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.scale(ConfigData.drawScale, ConfigData.drawScale, 1.0f);
        rectWidth += rightMargin;
        int rectHeight = lineHeight * number;
        int align = switch (ConfigData.drawPosition) {
            default -> {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                yield 1;
            }
            case ConfigData.DrawPosition.Bottom -> {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                yield 0;
            }
            case ConfigData.DrawPosition.BottomLeft -> {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                yield -1;
            }
            case ConfigData.DrawPosition.Left -> {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                yield -1;
            }
            case ConfigData.DrawPosition.TopLeft -> {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                yield -1;
            }
            case ConfigData.DrawPosition.Top -> {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                yield 0;
            }
            case ConfigData.DrawPosition.TopRight -> {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                yield 1;
            }
            case ConfigData.DrawPosition.Right -> {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                yield 1;
            }
            case ConfigData.DrawPosition.Center -> {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                yield 0;
            }
        };
        int backgroundColor = (int)Mth.clamp((double)((Double)this.mc.options.textBackgroundOpacity().get() * 255.0), (double)0.0, (double)255.0) << 24;
        graphics.fill(x - 2, y - 2, x + rectWidth + 4, y + rectHeight + 4, backgroundColor);
        for (Triple e : labels) {
            ChangeInfo change = (ChangeInfo)e.getLeft();
            Component label = (Component)e.getMiddle();
            int fade = (Integer)e.getRight();
            int w = font.width((FormattedText)label);
            int forcedFade = ConfigData.fadeLimit > 0 ? fade * 255 / (ConfigData.fadeLimit + 2) : 255;
            int ttlFade = change.ttl * 255 / 40;
            int alpha = Math.min(255, Math.min(forcedFade, ttlFade));
            int color = alpha << 24 | (change.mode == ChangeMode.Obtained ? 0x7FFF7F : 0xFF5F5F);
            int leftMargin = switch (align) {
                case -1 -> 2;
                case 0 -> (rectWidth - w - rightMargin) / 2;
                case 1 -> rectWidth - w - rightMargin;
                default -> 0;
            };
            RenderSystem.enableBlend();
            graphics.drawString(font, label, x + leftMargin, y + topMargin1, color);
            if (ConfigData.drawIcon) {
                poseStack.pushPose();
                poseStack.translate((float)(x + 2 + w + leftMargin), (float)(y + topMargin2), 0.0f);
                poseStack.scale(ConfigData.iconScale, ConfigData.iconScale, 1.0f);
                graphics.renderItem(change.item.stack, 0, 0);
                graphics.renderItemDecorations(font, change.item.stack, 0, 0, null);
                poseStack.popPose();
            }
            y += lineHeight;
        }
        poseStack.popPose();
    }

    private int computeLabel(List<Triple<ChangeInfo, Component, Integer>> computedStrings, Font font) {
        int rectWidth = 0;
        int itemsToShow = Math.min(Math.min(this.hard_limit, ConfigData.softLimit + ConfigData.fadeLimit), this.changeEntries.size());
        int offset = Math.max(0, this.changeEntries.size() - itemsToShow);
        int fadeOffset = this.changeEntries.size() - ConfigData.softLimit - ConfigData.fadeLimit;
        for (int i = offset; i < this.changeEntries.size(); ++i) {
            ChangeInfo change = this.changeEntries.get(i);
            Component label = this.getChangeLabel(change);
            int w = font.width((FormattedText)label);
            rectWidth = Math.max(rectWidth, w);
            computedStrings.add((Triple<ChangeInfo, Component, Integer>)Triple.of((Object)change, (Object)label, (Object)Math.min(ConfigData.fadeLimit + 2, 1 + i - fadeOffset)));
        }
        return rectWidth;
    }

    private Component getChangeLabel(ChangeInfo change) {
        String mode = change.mode == ChangeMode.Obtained ? "+" : "-";
        MutableComponent label = Component.literal((String)String.format("%s%d", mode, change.count));
        if (ConfigData.drawName) {
            label = label.append((Component)Component.literal((String)" "));
            Component name = change.item.stack.getHoverName();
            if (change.item.stack.has(DataComponents.CUSTOM_NAME)) {
                name = name.copy().withStyle(style -> style.withItalic(Boolean.valueOf(true)));
            }
            label = label.append(name);
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        if (!ConfigData.showItemAdditions && !ConfigData.showItemRemovals) {
            return;
        }
        LocalPlayer player = this.mc.player;
        if (player == null) {
            return;
        }
        if (player != this.playerEntity || player.inventoryMenu != PlayerContainerHooks.getOriginalContainer()) {
            PlayerContainerHooks.setTarget((AbstractContainerMenu)player.inventoryMenu, () -> {
                this.previous = null;
                this.dimLoadTicks = 0;
            });
            this.playerEntity = player;
            this.previous = null;
        }
        if (player.level().dimension() != this.dim) {
            this.previous = null;
            this.dimLoadTicks = 50;
            this.dim = player.level().dimension();
        }
        if (this.dimLoadTicks > 0) {
            this.previous = null;
            --this.dimLoadTicks;
            return;
        }
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            this.changeEntries.forEach(e -> --e.ttl);
            while (this.changeEntries.size() > this.hard_limit) {
                this.changeEntries.remove(0);
            }
            this.changeEntries.removeIf(e -> e.ttl <= 0 || e.count == 0);
        }
        Inventory inventory = player.getInventory();
        if (this.previous == null || this.previous.length != inventory.getContainerSize()) {
            this.previous = new ItemStack[inventory.getContainerSize()];
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                this.previous[i] = ScrollingOverlay.safeCopy(inventory.getItem(i));
            }
            AbstractContainerMenu currentMenu = player.containerMenu;
            this.previousInCursor = currentMenu.getCarried();
            return;
        }
        ArrayList changes = Lists.newArrayList();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack old = this.previous[i];
            ItemStack stack = inventory.getItem(i);
            if (this.isChangeMeaningful(old, stack)) {
                changes.add(Pair.of((Object)old, (Object)stack));
            }
            this.previous[i] = stack.copy();
        }
        AbstractContainerMenu currentMenu = player.containerMenu;
        ItemStack stackInCursor = currentMenu.getCarried();
        if (this.isChangeMeaningful(stackInCursor, this.previousInCursor)) {
            changes.add(Pair.of((Object)this.previousInCursor, (Object)stackInCursor));
        }
        this.previousInCursor = stackInCursor.copy();
        if (changes.size() == 0) {
            return;
        }
        ArrayList changeList = Lists.newArrayList();
        changes.forEach(change -> {
            boolean rightEmpty;
            ItemStack left = (ItemStack)change.getLeft();
            boolean leftEmpty = left.getCount() <= 0;
            ItemStack right = (ItemStack)change.getRight();
            boolean bl = rightEmpty = right.getCount() <= 0;
            if (ScrollingOverlay.areSameishItem(left, right)) {
                if (!this.isBlacklisted(left)) {
                    int difference = right.getCount() - left.getCount();
                    if (difference > 0) {
                        this.obtainedItem(changeList, left, difference);
                    } else if (difference < 0) {
                        this.lostItem(changeList, left, -difference);
                    }
                }
            } else {
                if (!leftEmpty && !this.isBlacklisted(left)) {
                    this.lostItem(changeList, left, left.getCount());
                }
                if (!rightEmpty && !this.isBlacklisted(right)) {
                    this.obtainedItem(changeList, right, right.getCount());
                }
            }
        });
        changeList.removeIf(e -> e.count == 0);
        if (changeList.size() > 0) {
            List<ChangeInfo> list2 = this.changeEntries;
            synchronized (list2) {
                for (ChangeInfo info : changeList) {
                    if (info.count == 0) continue;
                    this.accumulate(this.changeEntries, info.item.stack, info.mode, info.count, false);
                }
            }
        }
    }

    private boolean isBlacklisted(ItemStack left) {
        ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)left.getItem());
        if (name == null) {
            return true;
        }
        return ConfigData.ignoreItems.contains(name.toString());
    }

    private boolean isChangeMeaningful(ItemStack a, ItemStack b) {
        if (a.getCount() != b.getCount()) {
            return true;
        }
        if (a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b)) {
            return false;
        }
        ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)a.getItem());
        if (a.getItem() == b.getItem() && name != null && ConfigData.ignoreSubitemChanges.contains(name.toString())) {
            return false;
        }
        return !ItemStack.isSameItem((ItemStack)a, (ItemStack)b);
    }

    private static boolean areLooselyTheSame(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.isSameItem((ItemStack)a, (ItemStack)b);
    }

    private static boolean areSameishItem(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    private static boolean isStackEmpty(ItemStack stack) {
        return stack.getCount() <= 0;
    }

    private static ItemStack safeCopy(ItemStack stack) {
        return stack.copy();
    }

    private void obtainedItem(List<ChangeInfo> changeList, ItemStack item, int added) {
        if (added <= 0 || !ConfigData.showItemAdditions) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Obtained, added, true);
    }

    private void lostItem(List<ChangeInfo> changeList, ItemStack item, int removed) {
        if (removed <= 0 || !ConfigData.showItemRemovals) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Lost, removed, true);
    }

    private void accumulate(List<ChangeInfo> changeList, ItemStack stack, ChangeMode mode, int count, boolean isLocal) {
        ChangeInfo info;
        if (stack.getCount() <= 0) {
            return;
        }
        ComparableItem name = new ComparableItem(stack);
        ChangeInfo changeInfo = info = isLocal ? (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name)).findFirst().orElse(null) : (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name) && e.mode == mode).findFirst().orElse(null);
        if (info == null) {
            info = new ChangeInfo(name, mode, count, 240);
            changeList.add(info);
            return;
        }
        if (info.mode != mode) {
            count = -count;
        }
        info.count += count;
        info.ttl = 240;
        if (info.count < 0) {
            info.count = -info.count;
            info.mode = info.mode == ChangeMode.Lost ? ChangeMode.Obtained : ChangeMode.Lost;
        }
    }

    private static class ChangeInfo {
        final ComparableItem item;
        ChangeMode mode;
        int count;
        int ttl;

        ChangeInfo(ComparableItem item, ChangeMode mode, int count, int ttl) {
            this.item = item;
            this.mode = mode;
            this.count = count;
            this.ttl = ttl;
        }
    }

    private static enum ChangeMode {
        Obtained,
        Lost;

    }

    private record ComparableItem(ItemStack stack) {
        public ComparableItem(ItemStack stack) {
            this.stack = stack.copy();
            this.stack.setCount(1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ComparableItem)) return false;
            ComparableItem other = (ComparableItem)obj;
            if (!ScrollingOverlay.areSameishItem(other.stack, this.stack)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.stack.getItem().hashCode();
        }
    }
}

