/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.AdvancedButtonHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class AdvancedButton
extends Button {
    private boolean handleClick = false;
    private static boolean leftDown = false;
    private boolean leftDownThis = false;
    private boolean leftDownNotHovered = false;
    public boolean ignoreBlockedInput = false;
    public boolean ignoreLeftMouseDownClickBlock = false;
    public boolean enableRightclick = false;
    public float labelScale = 1.0f;
    private boolean useable = true;
    private boolean labelShadow = true;
    private Color idleColor;
    private Color hoveredColor;
    private Color idleBorderColor;
    private Color hoveredBorderColor;
    private float borderWidth = 2.0f;
    private ResourceLocation backgroundHover;
    private ResourceLocation backgroundNormal;
    String clicksound = null;
    String[] description = null;
    private Button.IPressable press;

    public AdvancedButton(int x, int y, int widthIn, int heightIn, String buttonText, Button.IPressable onPress) {
        super(x, y, widthIn, heightIn, buttonText, onPress);
        this.press = onPress;
    }

    public AdvancedButton(int x, int y, int widthIn, int heightIn, String buttonText, boolean handleClick, Button.IPressable onPress) {
        super(x, y, widthIn, heightIn, buttonText, onPress);
        this.handleClick = handleClick;
        this.press = onPress;
    }

    public void onPress() {
        this.press.onPress((Button)this);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft mc = Minecraft.func_71410_x();
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            RenderSystem.enableBlend();
            if (this.hasColorBackground()) {
                Color border;
                if (!this.isHovered) {
                    AdvancedButton.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(this.idleColor.getRGB() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24));
                    border = this.idleBorderColor;
                } else if (this.active) {
                    AdvancedButton.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(this.hoveredColor.getRGB() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24));
                    border = this.hoveredBorderColor;
                } else {
                    AdvancedButton.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(this.idleColor.getRGB() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24));
                    border = this.idleBorderColor;
                }
                if (this.hasBorder()) {
                    RenderUtils.fill(this.x, this.y, this.x + this.width, (float)this.y + this.borderWidth, border.getRGB(), this.alpha);
                    RenderUtils.fill(this.x, (float)(this.y + this.height) - this.borderWidth, this.x + this.width, this.y + this.height, border.getRGB(), this.alpha);
                    RenderUtils.fill(this.x, (float)this.y + this.borderWidth, (float)this.x + this.borderWidth, (float)(this.y + this.height) - this.borderWidth, border.getRGB(), this.alpha);
                    RenderUtils.fill((float)(this.x + this.width) - this.borderWidth, (float)this.y + this.borderWidth, this.x + this.width, (float)(this.y + this.height) - this.borderWidth, border.getRGB(), this.alpha);
                }
            } else if (this.hasCustomTextureBackground()) {
                if (this.isHovered()) {
                    if (this.active) {
                        mc.field_71446_o.func_110577_a(this.backgroundHover);
                    } else {
                        mc.field_71446_o.func_110577_a(this.backgroundNormal);
                    }
                } else {
                    mc.field_71446_o.func_110577_a(this.backgroundNormal);
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                AdvancedButton.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            } else {
                mc.func_110434_K().func_110577_a(WIDGETS_LOCATION);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                int i = this.getYImage(this.isHovered());
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                this.blit(this.x, this.y, 0, 46 + i * 20, this.width / 2, this.height);
                this.blit(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + i * 20, this.width / 2, this.height);
                RenderSystem.disableDepthTest();
            }
            this.renderBg(mc, mouseX, mouseY);
            this.renderLabel();
            if (this.isHovered()) {
                AdvancedButtonHandler.setActiveDescriptionButton(this);
            }
        }
        if (!this.isHovered() && MouseInput.isLeftMouseDown()) {
            this.leftDownNotHovered = true;
        }
        if (!MouseInput.isLeftMouseDown()) {
            this.leftDownNotHovered = false;
        }
        if (this.handleClick && this.useable) {
            if (this.isHovered() && (MouseInput.isLeftMouseDown() || this.enableRightclick && MouseInput.isRightMouseDown()) && (!leftDown || this.ignoreLeftMouseDownClickBlock) && !this.leftDownNotHovered && !this.isInputBlocked() && this.active && this.visible && !this.leftDownThis) {
                this.onClick(mouseX, mouseY);
                if (this.clicksound == null) {
                    this.playDownSound(Minecraft.func_71410_x().func_147118_V());
                } else {
                    SoundHandler.resetSound(this.clicksound);
                    SoundHandler.playSound(this.clicksound);
                }
                leftDown = true;
                this.leftDownThis = true;
            }
            if (!(MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown() && this.enableRightclick)) {
                leftDown = false;
                this.leftDownThis = false;
            }
        }
    }

    protected void renderLabel() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = font.func_78256_a(this.getMessage());
        int stringHeight = 8;
        int pX = (int)(((float)(this.x + this.width / 2) - (float)stringWidth * this.labelScale / 2.0f) / this.labelScale);
        int pY = (int)(((float)(this.y + this.height / 2) - (float)stringHeight * this.labelScale / 2.0f) / this.labelScale);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)this.labelScale, (float)this.labelScale, (float)this.labelScale);
        if (this.labelShadow) {
            font.func_175063_a(this.getMessage(), (float)pX, (float)pY, this.getFGColor() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        } else {
            font.func_211126_b(this.getMessage(), (float)pX, (float)pY, this.getFGColor() | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        }
        RenderSystem.popMatrix();
    }

    private boolean isInputBlocked() {
        if (this.ignoreBlockedInput) {
            return false;
        }
        return MouseInput.isVanillaInputBlocked();
    }

    public void setBackgroundColor(@Nullable Color idle, @Nullable Color hovered, @Nullable Color idleBorder, @Nullable Color hoveredBorder, float borderWidth) {
        this.idleColor = idle;
        this.hoveredColor = hovered;
        this.hoveredBorderColor = hoveredBorder;
        this.idleBorderColor = idleBorder;
        if (borderWidth >= 0.0f) {
            this.borderWidth = borderWidth;
        } else {
            borderWidth = 0.0f;
        }
    }

    public void setBackgroundColor(@Nullable Color idle, @Nullable Color hovered, @Nullable Color idleBorder, @Nullable Color hoveredBorder, int borderWidth) {
        this.setBackgroundColor(idle, hovered, idleBorder, hoveredBorder, (float)borderWidth);
    }

    public void setBackgroundTexture(ResourceLocation normal, ResourceLocation hovered) {
        this.backgroundNormal = normal;
        this.backgroundHover = hovered;
    }

    public void setBackgroundTexture(ExternalTextureResourceLocation normal, ExternalTextureResourceLocation hovered) {
        if (!normal.isReady()) {
            normal.loadTexture();
        }
        if (!hovered.isReady()) {
            hovered.loadTexture();
        }
        this.backgroundHover = hovered.getResourceLocation();
        this.backgroundNormal = normal.getResourceLocation();
    }

    public boolean hasBorder() {
        return this.hasColorBackground() && this.idleBorderColor != null && this.hoveredBorderColor != null;
    }

    public boolean hasColorBackground() {
        return this.idleColor != null && this.hoveredColor != null;
    }

    public boolean hasCustomTextureBackground() {
        return this.backgroundHover != null && this.backgroundNormal != null;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (!this.handleClick && this.useable) {
            if (this.active && this.visible) {
                boolean flag;
                if (this.isValidClickButton(p_mouseClicked_5_) && (flag = this.clicked(p_mouseClicked_1_, p_mouseClicked_3_))) {
                    if (this.clicksound == null) {
                        this.playDownSound(Minecraft.func_71410_x().func_147118_V());
                    } else {
                        SoundHandler.resetSound(this.clicksound);
                        SoundHandler.playSound(this.clicksound);
                    }
                    this.onClick(p_mouseClicked_1_, p_mouseClicked_3_);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.handleClick) {
            return false;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void setUseable(boolean b) {
        this.useable = b;
    }

    public boolean isUseable() {
        return this.useable;
    }

    public void setHandleClick(boolean b) {
        this.handleClick = b;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setHovered(boolean b) {
        this.isHovered = b;
    }

    public void setPressAction(Button.IPressable press) {
        this.press = press;
    }

    public void setClickSound(@Nullable String key) {
        this.clicksound = key;
    }

    public void setDescription(String ... desc) {
        this.description = desc;
    }

    public String[] getDescription() {
        return this.description;
    }

    public void setLabelShadow(boolean shadow) {
        this.labelShadow = shadow;
    }

    public static boolean isAnyButtonLeftClicked() {
        return leftDown;
    }
}

