/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import de.keksuccino.konkrete.input.CharData;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.reflection.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;

public class AdvancedTextField
extends TextFieldWidget {
    private int tick = 0;
    private boolean handle;
    private CharacterFilter filter;
    private boolean leftDown = false;

    public AdvancedTextField(FontRenderer fontrenderer, int x, int y, int width, int height, boolean handleTextField, @Nullable CharacterFilter filter) {
        super(fontrenderer, x, y, width, height, "");
        this.handle = handleTextField;
        this.filter = filter;
        if (this.handle) {
            KeyboardHandler.addKeyPressedListener(this::onKeyPress);
            KeyboardHandler.addKeyReleasedListener(this::onKeyReleased);
            KeyboardHandler.addCharTypedListener(this::onCharTyped);
        }
    }

    public boolean isHovered() {
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.func_146176_q() && this.isFocused()) {
            if (this.filter == null || this.filter.isAllowed(p_charTyped_1_)) {
                if (this.func_212953_l()) {
                    this.func_146191_b(Character.toString(p_charTyped_1_));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_146191_b(String textToWrite) {
        int l;
        String s = "";
        String s1 = textToWrite;
        if (this.filter != null) {
            s1 = this.filter.filterForAllowedChars(textToWrite);
        }
        int i = this.func_146198_h() < this.getSelectionEnd() ? this.func_146198_h() : this.getSelectionEnd();
        int j = this.func_146198_h() < this.getSelectionEnd() ? this.getSelectionEnd() : this.func_146198_h();
        int k = this.func_146208_g() - this.func_146179_b().length() - (i - j);
        if (!this.func_146179_b().isEmpty()) {
            s = s + this.func_146179_b().substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.func_146179_b().isEmpty() && j < this.func_146179_b().length()) {
            s = s + this.func_146179_b().substring(j);
        }
        this.func_146180_a(s);
        this.func_212422_f(i + l);
        this.func_146199_i(this.func_146198_h());
        this.setResponderEntryValue(this.func_146179_b());
    }

    protected void setResponderEntryValue(String text) {
        try {
            Method m = ReflectionHelper.findMethod(TextFieldWidget.class, "func_212951_d", String.class);
            m.invoke((Object)this, text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int func_146208_g() {
        try {
            Field f = ReflectionHelper.findField(TextFieldWidget.class, "field_146217_k");
            return f.getInt((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getSelectionEnd() {
        try {
            Field f = ReflectionHelper.findField(TextFieldWidget.class, "field_146223_s");
            return f.getInt((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean func_212953_l() {
        try {
            Field f = ReflectionHelper.findField(TextFieldWidget.class, "field_146226_p");
            return f.getBoolean((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isLeftClicked() {
        return this.isHovered() && MouseInput.isLeftMouseDown();
    }

    public void renderButton(int mouseX, int mouseY, float p_renderButton_3_) {
        super.renderButton(mouseX, mouseY, p_renderButton_3_);
        if (this.handle) {
            if (this.tick > 7) {
                this.func_146178_a();
                this.tick = 0;
            } else {
                ++this.tick;
            }
            if (MouseInput.isLeftMouseDown() && !this.leftDown) {
                super.mouseClicked((double)mouseX, (double)mouseY, 0);
                this.leftDown = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.leftDown = false;
            }
        }
    }

    public void onKeyPress(KeyboardData d) {
        super.keyPressed(d.keycode, d.scancode, d.modfiers);
    }

    public void onKeyReleased(KeyboardData d) {
        super.func_223281_a_(d.keycode, d.scancode, d.modfiers);
    }

    public void onCharTyped(CharData d) {
        this.charTyped(d.typedChar, d.modfiers);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public void func_212952_l(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setFocused(boolean b) {
        this.setFocused(b);
    }
}

