/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content.scrollarea;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ScrollArea
extends AbstractGui {
    public Color backgroundColor = new Color(0, 0, 0, 240);
    public int x;
    public int y;
    public int width;
    public int height;
    public int grabberheight = 20;
    public int grabberwidth = 10;
    private List<ScrollAreaEntry> entries = new ArrayList<ScrollAreaEntry>();
    private boolean grabberHovered = false;
    private boolean grabberPressed = false;
    private int scrollpos = 0;
    private int entryheight = 0;
    private int startY = 0;
    private int startPos = 0;

    public ScrollArea(int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void render() {
        RenderSystem.enableBlend();
        this.renderBackground();
        this.renderScrollbar();
        int i = 0;
        for (ScrollAreaEntry e : this.entries) {
            int scroll = this.scrollpos * (this.entryheight / (this.height - this.grabberheight));
            e.x = this.x;
            e.y = this.y + i - scroll;
            e.render();
            i += e.getHeight();
        }
    }

    protected void renderScrollbar() {
        if (this.height < this.entryheight) {
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            this.grabberHovered = this.x + this.width <= mouseX && this.x + this.width + this.grabberwidth >= mouseX && this.y + this.scrollpos <= mouseY && this.y + this.scrollpos + this.grabberheight >= mouseY;
            if (this.isGrabberHovered() && MouseInput.isLeftMouseDown()) {
                this.grabberPressed = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.grabberPressed = false;
            }
            if (!this.isGrabberHovered()) {
                ScrollArea.fill((int)(this.x + this.width), (int)(this.y + this.scrollpos), (int)(this.x + this.width + this.grabberwidth), (int)(this.y + this.scrollpos + this.grabberheight), (int)Color.GRAY.getRGB());
            } else {
                ScrollArea.fill((int)(this.x + this.width), (int)(this.y + this.scrollpos), (int)(this.x + this.width + this.grabberwidth), (int)(this.y + this.scrollpos + this.grabberheight), (int)Color.LIGHT_GRAY.getRGB());
            }
            if (this.isGrabberPressed()) {
                this.handleGrabberScrolling();
            } else {
                this.startY = MouseInput.getMouseY();
                this.startPos = this.scrollpos;
            }
        }
    }

    public boolean isAreaHovered() {
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return this.x <= mouseX && this.x + this.width + this.grabberwidth >= mouseX && this.y <= mouseY && this.y + this.height >= mouseY;
    }

    protected void handleGrabberScrolling() {
        int i = this.startY - MouseInput.getMouseY();
        int scroll = this.startPos - i;
        this.scrollpos = scroll < 0 ? 0 : (scroll > this.height - this.grabberheight ? this.height - this.grabberheight : scroll);
    }

    protected void renderBackground() {
        RenderSystem.pushMatrix();
        RenderSystem.disableAlphaTest();
        ScrollArea.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.backgroundColor.getRGB());
        RenderSystem.popMatrix();
    }

    public void addEntry(ScrollAreaEntry e) {
        this.entries.add(e);
        this.scrollpos = 0;
        this.entryheight += e.getHeight();
    }

    public void removeEntry(ScrollAreaEntry e) {
        if (this.entries.contains((Object)e)) {
            this.entries.remove((Object)e);
            this.scrollpos = 0;
            this.entryheight -= e.getHeight();
        }
    }

    public List<ScrollAreaEntry> getEntries() {
        return this.entries;
    }

    public int getStackedEntryHeight() {
        return this.entryheight;
    }

    public boolean isGrabberHovered() {
        return this.grabberHovered;
    }

    public boolean isGrabberPressed() {
        return this.grabberPressed;
    }

    @SubscribeEvent
    public void onMouseScrollPre(GuiScreenEvent.MouseScrollEvent.Pre e) {
        if (this.isAreaHovered()) {
            int scroll = this.scrollpos - (int)e.getScrollDelta() * 7;
            this.scrollpos = scroll < 0 ? 0 : (scroll > this.height - this.grabberheight ? this.height - this.grabberheight : scroll);
        }
    }
}

