/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.AnimationRenderer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleLoadingScreen
extends Screen {
    private static ResourceLocation MOJANG_LOGO_TEXTURE = new ResourceLocation("textures/gui/title/mojang.png");
    private static ResourceLocation MOJANG_LOGO_TEXTURE_DARK = new ResourceLocation("keksuccino", "mojang_dark.png");
    private final Minecraft mc;
    private LoadingAnimationRenderer loading = new LoadingAnimationRenderer("keksuccino/animations/loading", 15, true, 0, 0, 16, 16, "konkrete", null);
    private String status = "";
    private boolean darkmode = false;

    public SimpleLoadingScreen(Minecraft mc) {
        super((ITextComponent)new StringTextComponent(""));
        this.mc = mc;
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        int color = Color.WHITE.getRGB();
        if (this.darkmode) {
            color = new Color(26, 26, 26).getRGB();
        }
        SimpleLoadingScreen.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)color);
        int k1 = (this.width - 256) / 2;
        int i1 = (this.height - 256) / 2;
        if (this.darkmode) {
            this.mc.func_110434_K().func_110577_a(MOJANG_LOGO_TEXTURE_DARK);
        } else {
            this.mc.func_110434_K().func_110577_a(MOJANG_LOGO_TEXTURE);
        }
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(k1, i1, 0, 0, 256, 256);
        this.loading.setPosX(this.width / 2 - this.loading.getWidth() / 2);
        this.loading.setPosY(this.height - 80);
        RenderSystem.color4f((float)0.0f, (float)0.733f, (float)1.0f, (float)1.0f);
        this.loading.render();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawStatus(this.status, this.width / 2, this.loading.getPosY() + this.loading.getHeight() + 20);
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void setStatusText(String status) {
        this.status = status;
    }

    public void drawStatus(String text, int width, int height) {
        this.mc.field_71466_p.func_211126_b(text, (float)(width - Minecraft.func_71410_x().field_71466_p.func_78256_a(text) / 2), (float)height, 14821431);
    }

    public void setDarkmode(boolean b) {
        this.darkmode = b;
    }

    public void setLoadingAnimationColor(String hex) {
        this.loading.setHexColor(hex);
    }

    private static class LoadingAnimationRenderer
    extends AnimationRenderer {
        private String hex = "#E22837";

        public LoadingAnimationRenderer(String resourceDir, int fps, boolean loop, int posX, int posY, int width, int height, String modid, String hex) {
            super(resourceDir, fps, loop, posX, posY, width, height, modid);
            if (hex != null) {
                this.hex = hex;
            }
        }

        @Override
        protected void renderFrame() {
            int h = this.getHeight();
            int w = this.getWidth();
            int x2 = this.getPosX();
            int y2 = this.getPosY();
            if (this.isStretchedToStreensize()) {
                h = Minecraft.func_71410_x().field_71462_r.height;
                w = Minecraft.func_71410_x().field_71462_r.width;
                x2 = 0;
                y2 = 0;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)this.resources.get(this.currentFrame()));
            RenderSystem.enableBlend();
            float[] colorf = RenderUtils.getColorFromHexString(this.hex).getComponents(new float[4]);
            if (colorf != null) {
                RenderSystem.color4f((float)colorf[0], (float)colorf[1], (float)colorf[2], (float)colorf[3]);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            }
            IngameGui.blit((int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }

        public void setHexColor(String hex) {
            this.hex = hex == null ? "#E22837" : hex;
        }
    }
}

