/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class RenderUtils {
    private static ResourceLocation WHITE = null;
    private static ResourceLocation BLANK = null;

    public static ResourceLocation getWhiteImageResource() {
        ResourceLocation r;
        if (WHITE != null) {
            return WHITE;
        }
        if (Minecraft.func_71410_x().func_110434_K() == null) {
            return null;
        }
        NativeImage i = new NativeImage(1, 1, true);
        i.func_195700_a(0, 0, Color.WHITE.getRGB());
        WHITE = r = Minecraft.func_71410_x().func_110434_K().func_110578_a("whiteback", new DynamicTexture(i));
        return r;
    }

    public static ResourceLocation getBlankImageResource() {
        ResourceLocation r;
        if (BLANK != null) {
            return BLANK;
        }
        if (Minecraft.func_71410_x().func_110434_K() == null) {
            return null;
        }
        NativeImage i = new NativeImage(1, 1, true);
        i.func_195700_a(0, 0, new Color(255, 255, 255, 0).getRGB());
        BLANK = r = Minecraft.func_71410_x().func_110434_K().func_110578_a("blankback", new DynamicTexture(i));
        return r;
    }

    public static void setScale(float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
    }

    public static void postScale() {
        RenderSystem.popMatrix();
    }

    public static void doubleBlit(double x, double y, float f1, float f2, int w, int h) {
        RenderUtils.innerDoubleBlit(x, x + (double)w, y, y + (double)h, 0, (f1 + 0.0f) / (float)w, (f1 + (float)w) / (float)w, (f2 + 0.0f) / (float)h, (f2 + (float)h) / (float)h);
    }

    public static void innerDoubleBlit(double x, double xEnd, double y, double yEnd, int z, float f1, float f2, float f3, float f4) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x, yEnd, (double)z).func_225583_a_(f1, f4).func_181675_d();
        bufferbuilder.func_225582_a_(xEnd, yEnd, (double)z).func_225583_a_(f2, f4).func_181675_d();
        bufferbuilder.func_225582_a_(xEnd, y, (double)z).func_225583_a_(f2, f3).func_181675_d();
        bufferbuilder.func_225582_a_(x, y, (double)z).func_225583_a_(f1, f3).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static Color getColorFromHexString(String hex) {
        try {
            hex = hex.replace("#", "");
            if (hex.length() == 6) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            if (hex.length() == 8) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setZLevelPre(int zLevel) {
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)zLevel);
    }

    public static void setZLevelPost() {
        RenderSystem.popMatrix();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
    }

    public static void fill(float minX, float minY, float maxX, float maxY, int color, float opacity) {
        Matrix4f matrix4f = TransformationMatrix.func_227983_a_().func_227988_c_();
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        a *= opacity;
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bb.func_227888_a_(matrix4f, minX, maxY, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bb.func_227888_a_(matrix4f, maxX, maxY, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bb.func_227888_a_(matrix4f, maxX, minY, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bb.func_227888_a_(matrix4f, minX, minY, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bb.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bb);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

