/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens.popup;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class NotificationPopup
extends Popup {
    protected List<String> text;
    protected AdvancedButton accept;
    protected int width;
    protected Color color = new Color(76, 0, 128);
    protected Runnable callback;

    public NotificationPopup(int width, @Nullable Color color, int backgroundAlpha, @Nullable Runnable callback, String ... text) {
        super(backgroundAlpha);
        this.setNotificationText(text);
        this.width = width;
        this.accept = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.notification.accept", new String[0]), true, press -> {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.run();
            }
        });
        this.addButton(this.accept);
        if (color != null) {
            this.color = color;
        }
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEnterOrEscapePressed);
    }

    @Override
    public void render(MatrixStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        if (this.isDisplayed()) {
            int i;
            int height = 50;
            for (i = 0; i < this.text.size(); ++i) {
                height += 10;
            }
            RenderSystem.enableBlend();
            IngameGui.func_238467_a_((MatrixStack)matrix, (int)(renderIn.field_230708_k_ / 2 - this.width / 2), (int)(renderIn.field_230709_l_ / 2 - height / 2), (int)(renderIn.field_230708_k_ / 2 + this.width / 2), (int)(renderIn.field_230709_l_ / 2 + height / 2), (int)this.color.getRGB());
            RenderSystem.disableBlend();
            i = 0;
            for (String s : this.text) {
                AbstractGui.func_238472_a_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)new StringTextComponent(s), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 - height / 2 + 10 + i), (int)Color.WHITE.getRGB());
                i += 10;
            }
            this.accept.setX(renderIn.field_230708_k_ / 2 - this.accept.func_230998_h_() / 2);
            this.accept.setY(renderIn.field_230709_l_ / 2 + height / 2 - this.accept.func_238483_d_() - 5);
            this.renderButtons(matrix, mouseX, mouseY);
        }
    }

    public void setNotificationText(String ... text) {
        if (text != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String s : text) {
                if (s.contains("%n%")) {
                    for (String s2 : s.split("%n%")) {
                        l.add(s2);
                    }
                    continue;
                }
                l.add(s);
            }
            this.text = l;
        }
    }

    public void onEnterOrEscapePressed(KeyboardData d) {
        if ((d.keycode == 257 || d.keycode == 256) && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }
}

