/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.resources;

import de.keksuccino.konkrete.resources.ITextureResourceLocation;
import de.keksuccino.konkrete.resources.SelfcleaningDynamicTexture;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;

public class ExternalTextureResourceLocation
implements ITextureResourceLocation {
    private InputStream in;
    private String path;
    private ResourceLocation location;
    private boolean loaded = false;
    private int width = 0;
    private int height = 0;

    public ExternalTextureResourceLocation(String path) {
        this.path = path;
    }

    public ExternalTextureResourceLocation(InputStream in) {
        this.in = in;
    }

    @Override
    public void loadTexture() {
        if (this.loaded) {
            return;
        }
        try {
            if (Minecraft.func_71410_x().func_110434_K() == null) {
                System.out.println("################################ WARNING ################################");
                System.out.println("Can't load texture '" + this.path + "'! Minecraft TextureManager instance not ready yet!");
                return;
            }
            if (this.in == null) {
                File f = new File(this.path);
                this.in = new FileInputStream(f);
            }
            NativeImage i = NativeImage.func_195713_a((InputStream)this.in);
            this.width = i.func_195702_a();
            this.height = i.func_195714_b();
            this.location = Minecraft.func_71410_x().func_110434_K().func_110578_a("externaltexture", (DynamicTexture)new SelfcleaningDynamicTexture(i));
            this.in.close();
            this.loaded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isReady() {
        return this.loaded;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }
}

