/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.input;

import de.keksuccino.konkrete.reflection.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MouseInput {
    private static boolean leftClicked = false;
    private static boolean rightClicked = false;
    private static Map<String, Boolean> vanillainput = new HashMap<String, Boolean>();
    private static boolean ignoreBlocked = false;
    private static boolean useRenderScale = false;
    private static float renderScale = 1.0f;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MouseInput());
    }

    public static int getActiveMouseButton() {
        int b = -1;
        Field f = ReflectionHelper.findField(MouseHandler.class, "f_91510_");
        try {
            b = (Integer)f.get(Minecraft.m_91087_().f_91067_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static boolean isLeftMouseDown() {
        return leftClicked;
    }

    public static boolean isRightMouseDown() {
        return rightClicked;
    }

    public static int getMouseX() {
        int x = (int)(Minecraft.m_91087_().f_91067_.m_91589_() * (double)Minecraft.m_91087_().m_91268_().m_85445_() / (double)Minecraft.m_91087_().m_91268_().m_85443_());
        if (useRenderScale) {
            return (int)((float)x / renderScale);
        }
        return x;
    }

    public static int getMouseY() {
        int y = (int)(Minecraft.m_91087_().f_91067_.m_91594_() * (double)Minecraft.m_91087_().m_91268_().m_85446_() / (double)Minecraft.m_91087_().m_91268_().m_85444_());
        if (useRenderScale) {
            return (int)((float)y / renderScale);
        }
        return y;
    }

    public static void setRenderScale(float scale) {
        renderScale = scale;
        useRenderScale = true;
    }

    public static void resetRenderScale() {
        useRenderScale = false;
    }

    public static void blockVanillaInput(String category) {
        vanillainput.put(category, true);
    }

    public static void unblockVanillaInput(String category) {
        vanillainput.put(category, false);
    }

    public static boolean isVanillaInputBlocked() {
        if (ignoreBlocked) {
            return false;
        }
        return vanillainput.containsValue(true);
    }

    public static void ignoreBlockedVanillaInput(boolean ignore) {
        ignoreBlocked = ignore;
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre e) {
        int i = e.getButton();
        if (i == 0) {
            leftClicked = true;
        }
        if (i == 1) {
            rightClicked = true;
        }
        if (MouseInput.isVanillaInputBlocked()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMouseReleased(GuiScreenEvent.MouseReleasedEvent.Pre e) {
        int i = e.getButton();
        if (i == 0) {
            leftClicked = false;
        }
        if (i == 1) {
            rightClicked = false;
        }
    }

    @SubscribeEvent
    public void onScreenInit(GuiScreenEvent.InitGuiEvent.Pre e) {
        leftClicked = false;
        rightClicked = false;
        vanillainput.clear();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91080_ == null) {
            vanillainput.clear();
        }
    }
}

