/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content.scrollarea;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.events.client.GuiScreenEvent;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class ScrollArea
extends class_332 {
    public Color backgroundColor = new Color(0, 0, 0, 240);
    public int x;
    public int y;
    public int width;
    public int height;
    public int grabberheight = 20;
    public int grabberwidth = 10;
    private List<ScrollAreaEntry> entries = new ArrayList<ScrollAreaEntry>();
    private boolean grabberHovered = false;
    private boolean grabberPressed = false;
    private int scrollpos = 0;
    private int entryheight = 0;
    private int startY = 0;
    private int startPos = 0;

    public ScrollArea(int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        Konkrete.getEventHandler().registerEventsFrom((Object)this);
    }

    public void render(class_4587 matrix) {
        RenderSystem.enableBlend();
        this.renderBackground(matrix);
        this.renderScrollbar(matrix);
        int i = 0;
        for (ScrollAreaEntry e : this.entries) {
            int scroll = this.scrollpos * (this.entryheight / (this.height - this.grabberheight));
            e.x = this.x;
            e.y = this.y + i - scroll;
            e.render(matrix);
            i += e.getHeight();
        }
    }

    protected void renderScrollbar(class_4587 matrix) {
        if (this.height < this.entryheight) {
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            this.grabberHovered = this.x + this.width <= mouseX && this.x + this.width + this.grabberwidth >= mouseX && this.y + this.scrollpos <= mouseY && this.y + this.scrollpos + this.grabberheight >= mouseY;
            if (this.isGrabberHovered() && MouseInput.isLeftMouseDown()) {
                this.grabberPressed = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.grabberPressed = false;
            }
            if (!this.isGrabberHovered()) {
                ScrollArea.method_25294((class_4587)matrix, (int)(this.x + this.width), (int)(this.y + this.scrollpos), (int)(this.x + this.width + this.grabberwidth), (int)(this.y + this.scrollpos + this.grabberheight), (int)Color.GRAY.getRGB());
            } else {
                ScrollArea.method_25294((class_4587)matrix, (int)(this.x + this.width), (int)(this.y + this.scrollpos), (int)(this.x + this.width + this.grabberwidth), (int)(this.y + this.scrollpos + this.grabberheight), (int)Color.LIGHT_GRAY.getRGB());
            }
            if (this.isGrabberPressed()) {
                this.handleGrabberScrolling();
            } else {
                this.startY = MouseInput.getMouseY();
                this.startPos = this.scrollpos;
            }
        }
    }

    public boolean isAreaHovered() {
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return this.x <= mouseX && this.x + this.width + this.grabberwidth >= mouseX && this.y <= mouseY && this.y + this.height >= mouseY;
    }

    protected void handleGrabberScrolling() {
        int i = this.startY - MouseInput.getMouseY();
        int scroll = this.startPos - i;
        this.scrollpos = scroll < 0 ? 0 : (scroll > this.height - this.grabberheight ? this.height - this.grabberheight : scroll);
    }

    protected void renderBackground(class_4587 matrix) {
        matrix.method_22903();
        RenderSystem.disableAlphaTest();
        ScrollArea.method_25294((class_4587)matrix, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.backgroundColor.getRGB());
        matrix.method_22909();
    }

    public void addEntry(ScrollAreaEntry e) {
        this.entries.add(e);
        this.scrollpos = 0;
        this.entryheight += e.getHeight();
    }

    public void removeEntry(ScrollAreaEntry e) {
        if (this.entries.contains((Object)e)) {
            this.entries.remove((Object)e);
            this.scrollpos = 0;
            this.entryheight -= e.getHeight();
        }
    }

    public List<ScrollAreaEntry> getEntries() {
        return this.entries;
    }

    public int getStackedEntryHeight() {
        return this.entryheight;
    }

    public boolean isGrabberHovered() {
        return this.grabberHovered;
    }

    public boolean isGrabberPressed() {
        return this.grabberPressed;
    }

    @SubscribeEvent
    public void onMouseScrollPre(GuiScreenEvent.MouseScrollEvent.Pre e) {
        if (this.isAreaHovered()) {
            int scroll = this.scrollpos - (int)e.getScrollDelta() * 7;
            this.scrollpos = scroll < 0 ? 0 : (scroll > this.height - this.grabberheight ? this.height - this.grabberheight : scroll);
        }
    }
}

