/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens.popup;

import com.google.common.io.Files;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class FilePickerPopup
extends Popup {
    private static class_2960 fileIcon = new class_2960("keksuccino", "filechooser/file_icon.png");
    private static class_2960 folderIcon = new class_2960("keksuccino", "filechooser/folder_icon.png");
    private static class_2960 backIcon = new class_2960("keksuccino", "filechooser/back_icon.png");
    private static String lastpath;
    private boolean checklastpath;
    public Color overlayColor = new Color(26, 26, 26);
    private ScrollArea scroll;
    public File home;
    public File directory;
    private Popup fallback;
    private List<String> filetypes = new ArrayList<String>();
    private String filetypesString;
    private Consumer<File> callback;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private AdvancedButton chooseButton;
    private AdvancedButton closeButton;
    private FileChooserEntry focused;

    public FilePickerPopup(String directory, @Nullable String home, @Nullable Popup fallback, boolean checkForLastPath, Consumer<File> callback, String ... filetypes) {
        super(240);
        this.fallback = fallback;
        if (home != null) {
            this.home = new File(home);
        }
        this.directory = new File(directory);
        this.callback = callback;
        this.checklastpath = checkForLastPath;
        if (this.checklastpath && lastpath != null) {
            File f = new File(lastpath);
            if (f.exists() && f.isDirectory()) {
                if (this.home != null) {
                    if (f.getAbsolutePath().replace("\\", "/").startsWith(this.home.getAbsolutePath().replace("\\", "/"))) {
                        this.directory = f;
                    }
                } else {
                    this.directory = f;
                }
            }
        } else {
            lastpath = directory;
        }
        if (filetypes != null) {
            for (String s : filetypes) {
                this.filetypes.add(s.toLowerCase());
                this.filetypesString = this.filetypesString == null ? s.toUpperCase() : this.filetypesString + ", " + s.toUpperCase();
            }
        }
        if (this.filetypesString == null) {
            this.filetypesString = "ALL";
        }
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
        this.updateFileList();
        this.chooseButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.choosefile.choose", new String[0]), true, press -> {
            if (this.focused != null) {
                this.focused.onClick();
            }
        });
        this.addButton(this.chooseButton);
        this.colorizePopupButton(this.chooseButton);
        this.closeButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.yesno.cancel", new String[0]), true, press -> {
            if (this.callback != null) {
                this.callback.accept(null);
            }
            this.setDisplayed(false);
            if (this.fallback != null) {
                PopupHandler.displayPopup(this.fallback);
            }
        });
        this.addButton(this.closeButton);
        this.colorizePopupButton(this.closeButton);
    }

    public FilePickerPopup(String directory, @Nullable String home, @Nullable Popup fallback, boolean checkForLastPath, Consumer<File> callback) {
        this(directory, home, fallback, checkForLastPath, callback, null);
    }

    @Override
    public void render(class_4587 matrix, int mouseX, int mouseY, class_437 renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        if (this.lastWidth != renderIn.field_22789 || this.lastHeight != renderIn.field_22790) {
            this.updateFileList();
            this.focused = null;
        }
        this.lastWidth = renderIn.field_22789;
        this.lastHeight = renderIn.field_22790;
        this.scroll.height = renderIn.field_22790 - 100;
        this.scroll.y = 40;
        this.scroll.x = renderIn.field_22789 / 2 - this.scroll.width / 2;
        this.scroll.render(matrix);
        FilePickerPopup.method_25294((class_4587)matrix, (int)0, (int)0, (int)renderIn.field_22789, (int)40, (int)this.overlayColor.getRGB());
        FilePickerPopup.method_25294((class_4587)matrix, (int)0, (int)(renderIn.field_22790 - 60), (int)renderIn.field_22789, (int)renderIn.field_22790, (int)this.overlayColor.getRGB());
        FilePickerPopup.method_25300((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)("\u00a7l" + Locals.localize("popup.choosefile.title", new String[0])), (int)(renderIn.field_22789 / 2), (int)17, (int)Color.WHITE.getRGB());
        if (this.filetypesString != null) {
            FilePickerPopup.method_25300((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)(Locals.localize("popup.choosefile.supported", new String[0]) + " " + this.filetypesString), (int)(renderIn.field_22789 / 2), (int)(renderIn.field_22790 - 50), (int)Color.WHITE.getRGB());
            this.chooseButton.field_22760 = renderIn.field_22789 / 2 - this.chooseButton.method_25368() - 5;
            this.chooseButton.field_22761 = renderIn.field_22790 - 30;
            this.closeButton.field_22760 = renderIn.field_22789 / 2 + 5;
            this.closeButton.field_22761 = renderIn.field_22790 - 30;
        } else {
            this.chooseButton.field_22760 = renderIn.field_22789 / 2 - this.chooseButton.method_25368() - 5;
            this.chooseButton.field_22761 = renderIn.field_22790 - 40;
            this.closeButton.field_22760 = renderIn.field_22789 / 2 + 5;
            this.closeButton.field_22761 = renderIn.field_22790 - 40;
        }
        this.renderButtons(matrix, mouseX, mouseY);
        if (this.focused != null && !this.focused.focused) {
            this.focused = null;
        }
    }

    public void updateFileList() {
        this.scroll = new ScrollArea(0, 0, 200, 0);
        this.scroll.backgroundColor = new Color(255, 255, 255, 20);
        if (this.directory.exists() && this.directory.isDirectory()) {
            File parent = this.directory.getAbsoluteFile().getParentFile();
            if (this.home != null) {
                if (parent != null && parent.getAbsolutePath().replace("\\", "/").startsWith(this.home.getAbsolutePath().replace("\\", "/")) && parent.exists() && parent.isDirectory()) {
                    this.scroll.addEntry(new FileChooserEntry(null, this, FileChooserEntry.Type.BACK));
                }
            } else if (parent != null && parent.exists() && parent.isDirectory()) {
                this.scroll.addEntry(new FileChooserEntry(null, this, FileChooserEntry.Type.BACK));
            }
            ArrayList<String> folders = new ArrayList<String>();
            ArrayList<String> files = new ArrayList<String>();
            for (File f : this.directory.listFiles()) {
                if (f.isDirectory()) {
                    folders.add(f.getPath());
                    continue;
                }
                if (!this.filetypes.isEmpty()) {
                    if (!this.filetypes.contains(Files.getFileExtension((String)f.getName().toLowerCase()))) continue;
                    files.add(f.getPath());
                    continue;
                }
                files.add(f.getPath());
            }
            Collections.sort(folders, String.CASE_INSENSITIVE_ORDER);
            Collections.sort(files, String.CASE_INSENSITIVE_ORDER);
            for (String s : folders) {
                File f = new File(s);
                this.scroll.addEntry(new FileChooserEntry(f, this, FileChooserEntry.Type.FOLDER));
            }
            for (String s : files) {
                File f = new File(s);
                this.scroll.addEntry(new FileChooserEntry(f, this, FileChooserEntry.Type.FILE));
            }
        }
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 257 && this.isDisplayed() && this.focused != null) {
            this.focused.onClick();
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            if (this.callback != null) {
                this.callback.accept(null);
            }
            this.setDisplayed(false);
            if (this.fallback != null) {
                PopupHandler.displayPopup(this.fallback);
            }
        }
    }

    public static class FileChooserEntry
    extends ScrollAreaEntry {
        public File file;
        public Type type;
        public FilePickerPopup filechooser;
        private int clickTick = 0;
        private boolean clickPre = false;
        private boolean click = false;
        private boolean focused = false;

        public FileChooserEntry(File file, FilePickerPopup filechooser, Type type) {
            super(filechooser.scroll);
            this.file = file;
            this.type = type;
            this.filechooser = filechooser;
        }

        @Override
        public void render(class_4587 matrix) {
            if (this.isHovered() && this.isVisible() && MouseInput.isLeftMouseDown()) {
                this.focused = true;
                this.filechooser.focused = this;
                if (!this.click) {
                    this.clickPre = true;
                    this.clickTick = 0;
                }
            }
            if (!this.isHovered() && MouseInput.isLeftMouseDown()) {
                this.focused = false;
            }
            super.render(matrix);
        }

        @Override
        public void renderEntry(class_4587 matrix) {
            RenderSystem.enableBlend();
            if (this.type == Type.FILE) {
                class_310.method_1551().method_1531().method_22813(fileIcon);
            }
            if (this.type == Type.FOLDER) {
                class_310.method_1551().method_1531().method_22813(folderIcon);
            }
            if (this.type == Type.BACK) {
                class_310.method_1551().method_1531().method_22813(backIcon);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FileChooserEntry.method_25290((class_4587)matrix, (int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
            if (this.type == Type.BACK) {
                class_310.method_1551().field_1772.method_1720(matrix, Locals.localize("popup.choosefile.back", new String[0]), (float)(this.x + 30), (float)(this.y + 7), Color.WHITE.getRGB());
            } else {
                class_310.method_1551().field_1772.method_1720(matrix, this.file.getName(), (float)(this.x + 30), (float)(this.y + 7), Color.WHITE.getRGB());
            }
            if (!MouseInput.isLeftMouseDown() && this.clickPre) {
                this.click = true;
                this.clickPre = false;
                this.clickTick = 0;
            }
            if (this.click) {
                if (this.clickTick < 15) {
                    ++this.clickTick;
                } else {
                    this.click = false;
                    this.clickTick = 0;
                }
                if (MouseInput.isLeftMouseDown() && this.isHovered()) {
                    this.onClick();
                    this.click = false;
                    this.clickTick = 0;
                }
            }
            if (this.focused) {
                this.renderBorder(matrix);
            }
        }

        private void renderBorder(class_4587 matrix) {
            FileChooserEntry.method_25294((class_4587)matrix, (int)this.x, (int)this.y, (int)(this.x + 1), (int)(this.y + this.getHeight()), (int)Color.WHITE.getRGB());
            FileChooserEntry.method_25294((class_4587)matrix, (int)(this.x + this.getWidth() - 1), (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)Color.WHITE.getRGB());
            FileChooserEntry.method_25294((class_4587)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + 1), (int)Color.WHITE.getRGB());
            FileChooserEntry.method_25294((class_4587)matrix, (int)this.x, (int)(this.y + this.getHeight() - 1), (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)Color.WHITE.getRGB());
        }

        public void onClick() {
            File parent;
            if (this.type == Type.BACK && (parent = this.filechooser.directory.getParentFile()).exists() && parent.isDirectory()) {
                String home = null;
                if (this.filechooser.home != null) {
                    home = this.filechooser.home.getPath();
                }
                PopupHandler.displayPopup(new FilePickerPopup(parent.getPath(), home, this.filechooser.fallback, false, this.filechooser.callback, this.filechooser.filetypes.toArray(new String[0])));
            }
            if (this.type == Type.FOLDER) {
                String home = null;
                if (this.filechooser.home != null) {
                    home = this.filechooser.home.getPath();
                }
                PopupHandler.displayPopup(new FilePickerPopup(this.file.getPath(), home, this.filechooser.fallback, false, this.filechooser.callback, this.filechooser.filetypes.toArray(new String[0])));
            }
            if (this.type == Type.FILE) {
                if (this.filechooser.callback != null) {
                    this.filechooser.callback.accept(new File(this.file.getAbsolutePath().replace("\\", "/")));
                }
                this.filechooser.setDisplayed(false);
                if (this.filechooser.fallback != null) {
                    PopupHandler.displayPopup(this.filechooser.fallback);
                }
            }
        }

        @Override
        public int getHeight() {
            return 20;
        }

        public static enum Type {
            FILE,
            FOLDER,
            BACK;

        }
    }
}

